/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.ee.cms.core.AliveAndReadySignal;
import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureRecoveryActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.GroupLeadershipNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.Property;

@Scoped(value=PerLookup.class)
@Service
public class GMSAdapterImpl
implements GMSAdapter,
PostConstruct,
CallBack {
    private static final Logger logger = LogDomains.getLogger(GMSAdapterImpl.class, (String)"javax.org.glassfish.gms");
    private static final String BEGINS_WITH = "^";
    private static final String GMS_PROPERTY_PREFIX = "GMS_";
    private static final String GMS_PROPERTY_PREFIX_REGEXP = "^GMS_";
    private GroupManagementService gms;
    private static final String CORE = "CORE";
    private static final String SPECTATOR = "SPECTATOR";
    private static final String MEMBERTYPE_STRING = "MEMBER_TYPE";
    private static final int UMC_GMS_LISTENER_PORT = 9090;
    private static final String KEEP_FORMER_MEMBER_HISTORY = "KEEP_FORMER_MEMBER_HISTORY";
    private String instanceName = null;
    private Cluster cluster = null;
    private String clusterName = null;
    private Config clusterConfig = null;
    private long joinTime = 0L;
    private ConcurrentHashMap<CallBack, JoinNotificationActionFactory> callbackJoinActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, JoinedAndReadyNotificationActionFactory> callbackJoinedAndReadyActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, FailureNotificationActionFactory> callbackFailureActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, FailureSuspectedActionFactory> callbackFailureSuspectedActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, GroupLeadershipNotificationActionFactory> callbackGroupLeadershipActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, PlannedShutdownActionFactory> callbackPlannedShutdownActionFactoryMapping = new ConcurrentHashMap();
    private EventListener glassfishEventListener = null;
    private boolean aliveAndReadyLoggingEnabled = false;
    private boolean testFailureRecoveryHandler = false;
    @Inject
    Events events;
    @Inject
    ServerEnvironment env;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    Habitat habitat;
    @Inject
    Clusters clusters;
    @Inject
    Nodes nodes;
    @Inject
    Servers servers;
    private HealthHistory hHistory;
    AtomicBoolean initialized = new AtomicBoolean(false);
    AtomicBoolean initializationComplete = new AtomicBoolean(false);

    public void postConstruct() {
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean initialize(String clusterName) {
        if (this.initialized.compareAndSet(false, true)) {
            this.clusterName = clusterName;
            if (clusterName == null) {
                logger.log(Level.SEVERE, "gmsservice.no.cluster.name");
                return false;
            }
            try {
                this.gms = GMSFactory.getGMSModule((String)clusterName);
            }
            catch (GMSException ge) {
                // empty catch block
            }
            if (this.gms != null) {
                logger.log(Level.SEVERE, "gmsservice.multiple.adapter", clusterName);
                return false;
            }
            if (this.server.isClusteredDas()) {
                this.instanceName = this.server.getClusterMemberName();
                this.initializeHealthHistory(this.instanceName);
                this.clusterConfig = this.server.getConfig();
            } else {
                Domain domain = (Domain)this.habitat.getComponent(Domain.class);
                this.instanceName = this.env.getInstanceName();
                this.cluster = this.server.getCluster();
                if (this.cluster == null && this.clusters != null) {
                    for (Cluster clusterI : this.clusters.getCluster()) {
                        if (clusterName.compareTo(clusterI.getName()) != 0) continue;
                        this.cluster = clusterI;
                        break;
                    }
                }
                if (this.cluster == null) {
                    logger.log(Level.WARNING, "gmsservice.nocluster.warning");
                    return false;
                }
                if (this.env.isDas()) {
                    this.initializeHealthHistory(this.cluster);
                }
                this.clusterConfig = domain.getConfigNamed(clusterName + "-config");
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "clusterName=" + clusterName + " clusterConfig=" + this.clusterConfig);
            }
            try {
                this.initializeGMS();
            }
            catch (GMSException e) {
                logger.log(Level.SEVERE, "gmsservice.failed.to.start", e);
                return false;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "gmsservice.failed.to.start.unexpected", t);
                return false;
            }
            this.initializationComplete.set(true);
        }
        return this.initialized.get();
    }

    public void complete() {
        this.initialized.compareAndSet(true, false);
        this.initializationComplete.compareAndSet(true, false);
        this.gms = null;
        GMSFactory.removeGMSModule((String)this.clusterName);
    }

    public HealthHistory getHealthHistory() {
        this.checkInitialized();
        return this.hHistory;
    }

    private void initializeHealthHistory(Cluster cluster) {
        try {
            this.hHistory = new HealthHistory(cluster);
            Dom.unwrap((ConfigBeanProxy)cluster).addListener((ConfigListener)this.hHistory);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "gmsexception.new.health.history", t.getLocalizedMessage());
        }
    }

    private void initializeHealthHistory(String instanceName) {
        boolean keepFormerMembers = false;
        Property keepFormerMemberProp = this.server.getConfig().getGroupManagementService().getProperty(KEEP_FORMER_MEMBER_HISTORY);
        if (keepFormerMemberProp != null) {
            keepFormerMembers = Boolean.parseBoolean(keepFormerMemberProp.getValue());
        }
        try {
            this.hHistory = new HealthHistory(instanceName, keepFormerMembers);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "gmsexception.new.health.history", t.getLocalizedMessage());
        }
    }

    private void readGMSConfigProps(Properties configProps) {
        String value;
        String name;
        List props;
        if (this.env.isDas() && !this.server.isClusteredDas()) {
            configProps.put(MEMBERTYPE_STRING, SPECTATOR);
        } else {
            configProps.put(MEMBERTYPE_STRING, CORE);
        }
        configProps.put("SHOAL_GROUP_COMMUNICATION_PROVIDER", "grizzly1_9");
        block16: for (ServiceProviderConfigurationKeys key : ServiceProviderConfigurationKeys.values()) {
            String keyName = key.toString();
            try {
                switch (key) {
                    case MULTICASTADDRESS: {
                        String value2;
                        if (this.cluster == null || (value2 = this.cluster.getGmsMulticastAddress()) == null) continue block16;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case MULTICASTPORT: {
                        String value2;
                        if (this.cluster == null || (value2 = this.cluster.getGmsMulticastPort()) == null) continue block16;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getHeartbeatFrequencyInMillis()) == null) continue block16;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_RETRIES: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getMaxMissedHeartbeats()) == null) continue block16;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_VERIFICATION_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureWaittimeInMillis()) == null) continue block16;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case DISCOVERY_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getGroupDiscoveryTimeoutInMillis()) == null) continue block16;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case IS_BOOTSTRAPPING_NODE: {
                        configProps.put(keyName, this.env.isDas() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        break;
                    }
                    case VIRTUAL_MULTICAST_URI_LIST: {
                        break;
                    }
                    case BIND_INTERFACE_ADDRESS: {
                        String addr = null;
                        if (this.server.isClusteredDas()) {
                            addr = this.clusterConfig.getPropertyValue("GMS_BIND_INTERFACE_ADDRESS");
                        } else if (this.cluster != null) {
                            addr = this.cluster.getGmsBindInterfaceAddress();
                        }
                        if (addr != null) {
                            addr = addr.trim();
                        }
                        if (addr == null || addr.length() <= 1 || addr.charAt(0) == '$') continue block16;
                        if (NetworkUtility.isBindAddressValid((String)addr)) {
                            configProps.put(keyName, addr);
                            break;
                        }
                        logger.log(Level.SEVERE, "gmsservice.bind.int.address.invalid", addr);
                        break;
                    }
                    case FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT: {
                        String value3;
                        if (this.clusterConfig == null || (value3 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureConnectTimeoutInMillis()) == null) continue block16;
                        configProps.put(keyName, value3);
                        break;
                    }
                    case MULTICAST_POOLSIZE: 
                    case INCOMING_MESSAGE_QUEUE_SIZE: 
                    case FAILURE_DETECTION_TCP_RETRANSMIT_PORT: {
                        if (this.clusterConfig == null) continue block16;
                        Property prop = this.clusterConfig.getGroupManagementService().getProperty(keyName);
                        if (prop == null) {
                            if (!logger.isLoggable(Level.FINE)) continue block16;
                            logger.log(Level.FINE, String.format("No config property found for %s", keyName));
                            break;
                        }
                        String value4 = prop.getValue().trim();
                        if (value4 == null) continue block16;
                        configProps.put(keyName, value4);
                        break;
                    }
                    case LOOPBACK: {
                        break;
                    }
                    default: {
                        if (!logger.isLoggable(Level.FINE)) continue block16;
                        logger.log(Level.FINE, String.format("service provider key %s ignored", keyName));
                    }
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "gmsexception.processing.config.props", t.getLocalizedMessage());
            }
        }
        if (this.server.isClusteredDas()) {
            configProps.put(GrizzlyConfigConstants.TCPSTARTPORT.toString(), (Object)9090);
            configProps.put(GrizzlyConfigConstants.TCPENDPORT.toString(), (Object)9090);
        }
        if (this.clusterConfig != null) {
            props = this.clusterConfig.getGroupManagementService().getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                if (name == null || value == null) continue;
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "processing group-management-service property name=" + name + " value= " + value);
                }
                if (value.startsWith("${")) {
                    if (!logger.isLoggable(Level.CONFIG)) continue;
                    logger.log(Level.CONFIG, "skipping group-management-service property name=" + name + " since value is unresolved symbolic token=" + value);
                    continue;
                }
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "processing group-management-service property name=" + name + " value= " + value);
                }
                if (name.startsWith(GMS_PROPERTY_PREFIX)) {
                    name = name.replaceFirst(GMS_PROPERTY_PREFIX_REGEXP, "");
                }
                configProps.put(name, value);
                if (this.validateGMSProperty(name)) continue;
                logger.log(Level.WARNING, "gmsexception.ignoring.property", new Object[]{name, value, ""});
            }
        }
        if (this.cluster != null) {
            props = this.cluster.getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                if (name == null || value == null) continue;
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "processing cluster property name=" + name + " value= " + value);
                }
                if (value.startsWith("${")) {
                    if (!logger.isLoggable(Level.CONFIG)) continue;
                    logger.log(Level.CONFIG, "skipping cluster property name=" + name + " since value is unresolved symbolic token=" + value);
                    continue;
                }
                if (name.startsWith(GMS_PROPERTY_PREFIX)) {
                    name = name.replaceFirst(GMS_PROPERTY_PREFIX_REGEXP, "");
                }
                if (name.compareTo("ALIVEANDREADY_LOGGING") == 0) {
                    this.aliveAndReadyLoggingEnabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (name.compareTo("LISTENER_PORT") == 0) {
                    configProps.put(GrizzlyConfigConstants.TCPSTARTPORT.toString(), value);
                    configProps.put(GrizzlyConfigConstants.TCPENDPORT.toString(), value);
                    continue;
                }
                if (name.compareTo("TEST_FAILURE_RECOVERY") == 0) {
                    this.testFailureRecoveryHandler = Boolean.parseBoolean(value);
                    continue;
                }
                if (ServiceProviderConfigurationKeys.DISCOVERY_URI_LIST.name().equals(name) && "generate".equals(value)) {
                    value = this.generateDiscoveryUriList();
                    configProps.put(name, value);
                    continue;
                }
                configProps.put(name, value);
                logger.log(Level.CONFIG, "processing cluster property name=" + name + " value= " + value);
                if (this.validateGMSProperty(name)) continue;
                logger.log(Level.WARNING, "gmsexception.cluster.property.error", new Object[]{name, value, ""});
            }
        }
    }

    private String generateDiscoveryUriList() {
        int lastCommaIndex;
        String clusterPort = null;
        Property gmsPortProp = this.cluster.getProperty("GMS_LISTENER_PORT");
        if (gmsPortProp == null || gmsPortProp.getValue() == null || gmsPortProp.getValue().trim().charAt(0) == '$') {
            clusterPort = "9090";
            logger.log(Level.WARNING, "gmsservice.listener.port.required", new Object[]{this.cluster.getName(), clusterPort});
        } else {
            clusterPort = gmsPortProp.getValue();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "will use gms listener port: " + clusterPort);
            }
        }
        HashSet<String> instanceNames = new HashSet<String>();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("checking cluster.getServerRef() for '%s'", this.cluster.getName()));
        }
        for (ServerRef sRef : this.cluster.getServerRef()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("adding server ref %s to set of instance names", sRef.getRef()));
            }
            instanceNames.add(sRef.getRef());
        }
        StringBuilder sb = new StringBuilder();
        String SEP = ",";
        String scheme = "tcp://";
        for (String name : instanceNames) {
            Node node;
            Server server = this.servers.getServer(name);
            if (server == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("found server for name %s", name));
            }
            if ((node = this.nodes.getNode(server.getNodeRef())) == null) continue;
            String host = "tcp://" + node.getNodeHost() + ":" + clusterPort;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("Adding host '%s' to discovery list", host));
            }
            sb.append(host).append(",");
        }
        if (this.server.isInstance()) {
            try {
                ServerDirs sDirs = new ServerDirs(this.env.getInstanceRoot());
                File dasPropsFile = sDirs.getDasPropertiesFile();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("found das.props file at %s", dasPropsFile.getAbsolutePath()));
                }
                Properties dasProps = this.getProperties(dasPropsFile);
                String host = "tcp://" + dasProps.getProperty("agent.das.host") + ":" + clusterPort;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("adding '%s' from das.props file", host));
                }
                sb.append(host).append(",");
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe.toString());
            }
        }
        if ((lastCommaIndex = sb.lastIndexOf(",")) != -1) {
            sb.deleteCharAt(lastCommaIndex);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("returning discovery list '%s'", sb.toString()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Properties getProperties(File propFile) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            props.load(fis);
            fis.close();
            fis = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
        return props;
    }

    private boolean validateGMSProperty(String propertyName) {
        boolean result = false;
        GrizzlyConfigConstants key = null;
        try {
            key = GrizzlyConfigConstants.valueOf((String)propertyName);
            result = true;
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (key == null) {
            try {
                key = ServiceProviderConfigurationKeys.valueOf((String)propertyName);
                result = true;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return key != null && result;
    }

    private void initializeGMS() throws GMSException {
        Properties configProps = new Properties();
        int HA_MAX_GMS_MESSAGE_LENGTH = 0x400800;
        configProps.put(ServiceProviderConfigurationKeys.MAX_MESSAGE_LENGTH.toString(), Integer.toString(HA_MAX_GMS_MESSAGE_LENGTH));
        this.readGMSConfigProps(configProps);
        this.printProps(configProps);
        String memberType = (String)configProps.get(MEMBERTYPE_STRING);
        this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)this.instanceName, (String)this.clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.valueOf((String)memberType), (Properties)configProps);
        GMSFactory.setGMSEnabledState((String)this.clusterName, (Boolean)Boolean.TRUE);
        if (this.gms != null) {
            try {
                this.registerJoinedAndReadyNotificationListener(this);
                this.registerJoinNotificationListener(this);
                this.registerFailureNotificationListener(this);
                this.registerPlannedShutdownListener(this);
                this.registerFailureSuspectedListener(this);
                if (this.testFailureRecoveryHandler && CORE.equals(configProps.getProperty(MEMBERTYPE_STRING))) {
                    this.registerFailureRecoveryListener("GlassfishFailureRecoveryHandlerTest", this);
                }
                this.glassfishEventListener = new EventListener(){

                    public void event(EventListener.Event event) {
                        if (GMSAdapterImpl.this.gms == null) {
                            return;
                        }
                        if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                            logger.log(Level.INFO, "gmsservice.server_shutdown.received", new Object[]{GMSAdapterImpl.this.gms.getInstanceName(), GMSAdapterImpl.this.gms.getGroupName(), event.name()});
                            GMSAdapterImpl.this.removeJoinedAndReadyNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeJoinNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeFailureNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeFailureSuspectedListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                            GMSAdapterImpl.this.removePlannedShutdownListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.events.unregister(GMSAdapterImpl.this.glassfishEventListener);
                        } else if (event.is(EventTypes.SERVER_READY)) {
                            GMSAdapterImpl.this.gms.reportJoinedAndReadyState();
                        }
                    }
                };
                this.events.register(this.glassfishEventListener);
                this.gms.join();
                this.joinTime = System.currentTimeMillis();
                logger.log(Level.INFO, "gmsservice.member.joined.group", new Object[]{this.instanceName, this.clusterName});
            }
            catch (GMSException e) {
                this.events.unregister(this.glassfishEventListener);
                throw e;
            }
        } else {
            throw new GMSException("gms object is null.");
        }
        logger.log(Level.INFO, "gmsservice.started", new Object[]{this.instanceName, this.clusterName});
    }

    private void printProps(Properties prop) {
        if (!logger.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : prop.stringPropertyNames()) {
            sb.append(key).append(" = ").append(prop.get(key)).append("  ");
        }
        logger.log(Level.CONFIG, "Printing all GMS properties: ", sb.toString());
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    private void checkInitialized() {
        if (!this.initialized.get() || !this.initializationComplete.get()) {
            throw new IllegalStateException("GMSAdapter not properly initialized.");
        }
    }

    public GroupManagementService getModule() {
        this.checkInitialized();
        return this.gms;
    }

    public GroupManagementService getGMS(String groupName) {
        try {
            return GMSFactory.getGMSModule((String)groupName);
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, "gmsexception.cannot.get.group.module", new Object[]{groupName, e.getLocalizedMessage()});
            return null;
        }
    }

    public void processNotification(Signal signal) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "GMSService: Received a notification ", signal.getClass().getName());
        }
        try {
            if (this.hHistory != null) {
                this.hHistory.updateHealth(signal);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "gmsexception.update.health.history", t.getLocalizedMessage());
        }
        if (this.testFailureRecoveryHandler && signal instanceof FailureRecoverySignal) {
            FailureRecoverySignal frsSignal = (FailureRecoverySignal)signal;
            logger.log(Level.INFO, "gmsservice.failurerecovery.start.notification", new Object[]{frsSignal.getComponentName(), frsSignal.getMemberToken()});
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            logger.log(Level.INFO, "gmsservice.failurerecovery.completed.notification", new Object[]{frsSignal.getComponentName(), frsSignal.getMemberToken()});
        }
        if (this.aliveAndReadyLoggingEnabled && (signal instanceof JoinedAndReadyNotificationSignal || signal instanceof FailureNotificationSignal || signal instanceof PlannedShutdownSignal)) {
            PlannedShutdownSignal pssig;
            AliveAndReadySignal arSignal = (AliveAndReadySignal)signal;
            String signalSubevent = "";
            if (signal instanceof JoinedAndReadyNotificationSignal) {
                JoinedAndReadyNotificationSignal jrsig = (JoinedAndReadyNotificationSignal)signal;
                if (jrsig.getEventSubType() == GMSConstants.startupType.GROUP_STARTUP) {
                    signalSubevent = " Subevent: " + GMSConstants.startupType.GROUP_STARTUP;
                } else if (jrsig.getRejoinSubevent() != null) {
                    signalSubevent = " Subevent: " + jrsig.getRejoinSubevent();
                }
            }
            if (signal instanceof PlannedShutdownSignal && (pssig = (PlannedShutdownSignal)signal).getEventSubType() == GMSConstants.shutdownType.GROUP_SHUTDOWN) {
                signalSubevent = " Subevent:" + GMSConstants.shutdownType.GROUP_SHUTDOWN.toString();
            }
            AliveAndReadyView current = arSignal.getCurrentView();
            AliveAndReadyView previous = arSignal.getPreviousView();
            logger.log(Level.INFO, "gmsservice.alive.ready.signal", new Object[]{signal.getClass().getSimpleName() + signalSubevent, signal.getMemberToken(), signal.getGroupName(), current, previous});
        }
    }

    public void registerJoinNotificationListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            JoinNotificationActionFactoryImpl jnaf = new JoinNotificationActionFactoryImpl(callback);
            this.gms.addActionFactory((JoinNotificationActionFactory)jnaf);
            this.callbackJoinActionFactoryMapping.put(callback, (JoinNotificationActionFactory)jnaf);
        }
    }

    public void registerJoinedAndReadyNotificationListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            JoinedAndReadyNotificationActionFactoryImpl jnaf = new JoinedAndReadyNotificationActionFactoryImpl(callback);
            this.gms.addActionFactory((JoinedAndReadyNotificationActionFactory)jnaf);
            this.callbackJoinedAndReadyActionFactoryMapping.put(callback, (JoinedAndReadyNotificationActionFactory)jnaf);
        }
    }

    public void registerMemberLeavingListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            this.registerFailureNotificationListener(callback);
            this.registerPlannedShutdownListener(callback);
            this.registerJoinNotificationListener(callback);
        }
    }

    public void registerPlannedShutdownListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            PlannedShutdownActionFactoryImpl psaf = new PlannedShutdownActionFactoryImpl(callback);
            this.callbackPlannedShutdownActionFactoryMapping.put(callback, (PlannedShutdownActionFactory)psaf);
            this.gms.addActionFactory((PlannedShutdownActionFactory)psaf);
        }
    }

    public void registerFailureSuspectedListener(CallBack callback) {
        if (this.gms != null) {
            FailureSuspectedActionFactoryImpl fsaf = new FailureSuspectedActionFactoryImpl(callback);
            this.callbackFailureSuspectedActionFactoryMapping.put(callback, (FailureSuspectedActionFactory)fsaf);
            this.gms.addActionFactory((FailureSuspectedActionFactory)fsaf);
        }
    }

    public void registerFailureNotificationListener(CallBack callback) {
        if (this.gms != null) {
            FailureNotificationActionFactoryImpl fnaf = new FailureNotificationActionFactoryImpl(callback);
            this.callbackFailureActionFactoryMapping.put(callback, (FailureNotificationActionFactory)fnaf);
            this.gms.addActionFactory((FailureNotificationActionFactory)fnaf);
        }
    }

    public void registerFailureRecoveryListener(String componentName, CallBack callback) {
        if (this.gms != null) {
            this.gms.addActionFactory(componentName, (FailureRecoveryActionFactory)new FailureRecoveryActionFactoryImpl(callback));
        }
    }

    public void registerMessageListener(String componentName, CallBack messageListener) {
        if (this.gms != null) {
            this.gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl(messageListener), componentName);
        }
    }

    public void registerGroupLeadershipNotificationListener(CallBack callback) {
        if (this.gms != null) {
            this.gms.addActionFactory((GroupLeadershipNotificationActionFactory)new GroupLeadershipNotificationActionFactoryImpl(callback));
        }
    }

    public void removeFailureRecoveryListener(String componentName) {
        if (this.gms != null) {
            this.gms.removeFailureRecoveryActionFactory(componentName);
        }
    }

    public void removeMessageListener(String componentName) {
        if (this.gms != null) {
            this.gms.removeMessageActionFactory(componentName);
        }
    }

    public void removeFailureNotificationListener(CallBack callback) {
        FailureNotificationActionFactory fnaf;
        if (this.gms != null && (fnaf = this.callbackFailureActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeActionFactory(fnaf);
        }
    }

    public void removeFailureSuspectedListener(CallBack callback) {
        FailureSuspectedActionFactory fsaf;
        if (this.gms != null && (fsaf = this.callbackFailureSuspectedActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeFailureSuspectedActionFactory(fsaf);
        }
    }

    public void removeJoinNotificationListener(CallBack callback) {
        JoinNotificationActionFactory jaf;
        if (this.gms != null && (jaf = this.callbackJoinActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(jaf);
        }
    }

    public void removeJoinedAndReadyNotificationListener(CallBack callback) {
        JoinedAndReadyNotificationActionFactory jaf;
        if (this.gms != null && (jaf = this.callbackJoinedAndReadyActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(jaf);
        }
    }

    public void removePlannedShutdownListener(CallBack callback) {
        PlannedShutdownActionFactory psaf;
        if (this.gms != null && (psaf = this.callbackPlannedShutdownActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeActionFactory(psaf);
        }
    }

    public void removeGroupLeadershipLNotificationistener(CallBack callback) {
        GroupLeadershipNotificationActionFactory glnf;
        if (this.gms != null && (glnf = this.callbackGroupLeadershipActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(glnf);
        }
    }

    public void removeMemberLeavingListener(CallBack callback) {
        this.removePlannedShutdownListener(callback);
        this.removeFailureNotificationListener(callback);
        this.removeJoinNotificationListener(callback);
    }
}

