/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.server.logging.BooleanLatch;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.LogRotationTimerTask;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.glassfish.api.logging.Task;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
@ContractProvided(value=Handler.class)
public class GFFileHandler
extends StreamHandler
implements PostConstruct,
PreDestroy {
    @Inject
    ServerContext serverContext;
    @Inject
    ServerEnvironmentImpl env;
    @Inject(optional=true)
    Agent agent;
    @Inject
    Version version;
    private MeteredStream meter;
    private static final String LOGS_DIR = "logs";
    private String logFileName = "server.log";
    private String absoluteServerLogName = null;
    private File absoluteFile = null;
    private int flushFrequency = 1;
    private int maxHistoryFiles = 10;
    private static final int MINIMUM_FILE_ROTATION_VALUE = 500000;
    private int limitForFileRotation = 0;
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private AtomicBoolean rotationRequested = new AtomicBoolean(false);
    private static final String LOG_ROTATE_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    private static final SimpleDateFormat logRotateDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
    private BooleanLatch done = new BooleanLatch();
    private Thread pump;
    private static final int MAX_RECENT_ERRORS = 4;
    boolean dayBasedFileRotation = false;
    private String RECORD_BEGIN_MARKER = "[#|";
    private String RECORD_END_MARKER = "|#]";
    private String RECORD_FIELD_SEPARATOR = "|";
    private String RECORD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    String recordBeginMarker;
    String recordEndMarker;
    String recordFieldSeparator;
    String recordDateFormat;

    public void postConstruct() {
        String formatterName;
        Long rotationTimeLimitValue;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String filename = TranslatedConfigView.getTranslatedValue((Object)manager.getProperty(cname + ".file")).toString();
        File serverLog = new File(filename);
        this.absoluteServerLogName = filename;
        if (!serverLog.isAbsolute()) {
            serverLog = new File(this.env.getDomainRoot(), filename);
            this.absoluteServerLogName = this.env.getDomainRoot() + File.separator + filename;
        }
        this.changeFileName(serverLog);
        this.pump = new Thread(){

            public void run() {
                try {
                    while (!GFFileHandler.this.done.isSignalled()) {
                        GFFileHandler.this.log();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.pump.start();
        GFFileHandler gFFileHandler = this;
        LogRecord lr = new LogRecord(Level.INFO, "Running GlassFish Version: " + gFFileHandler.version.getFullVersion());
        lr.setThreadID((int)Thread.currentThread().getId());
        lr.setLoggerName(this.getClass().getName());
        EarlyLogHandler.earlyMessages.add(lr);
        String rotationOnDateChange = manager.getProperty(cname + ".rotationOnDateChange");
        if (rotationOnDateChange != null && !"".equals(rotationOnDateChange.trim()) && Boolean.parseBoolean(rotationOnDateChange)) {
            this.dayBasedFileRotation = true;
            rotationTimeLimitValue = 0L;
            int MILLIS_IN_DAY = 86400000;
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            long systime = System.currentTimeMillis();
            String nextDate = dateFormat.format(date.getTime() + (long)MILLIS_IN_DAY);
            Date nextDay = null;
            try {
                nextDay = dateFormat.parse(nextDate);
            }
            catch (ParseException e) {
                nextDay = new Date();
                lr = new LogRecord(Level.WARNING, "Cannot parse the date.");
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            long nextsystime = nextDay.getTime();
            rotationTimeLimitValue = nextsystime - systime;
            Task rotationTask = new Task(){

                public Object run() {
                    GFFileHandler.this.rotate();
                    return null;
                }
            };
            LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, rotationTimeLimitValue / 60000L));
            this.setLimitForRotation(0);
        } else {
            rotationTimeLimitValue = 0L;
            try {
                rotationTimeLimitValue = Long.parseLong(manager.getProperty(cname + ".rotationTimelimitInMinutes"));
            }
            catch (NumberFormatException e) {
                lr = new LogRecord(Level.SEVERE, "Can't find rotationTimelimitInMinutes property from logging config file");
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            if (rotationTimeLimitValue != 0L) {
                Task rotationTask = new Task(){

                    public Object run() {
                        GFFileHandler.this.rotate();
                        return null;
                    }
                };
                LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, rotationTimeLimitValue));
                this.setLimitForRotation(0);
            } else {
                Integer rotationLimitAttrValue = 0;
                try {
                    rotationLimitAttrValue = Integer.parseInt(manager.getProperty(cname + ".rotationLimitInBytes"));
                }
                catch (NumberFormatException e) {
                    lr = new LogRecord(Level.WARNING, "Can't find rotationLimitInBytes property from logging config file so using default.");
                    lr.setThreadID((int)Thread.currentThread().getId());
                    lr.setLoggerName(this.getClass().getName());
                    EarlyLogHandler.earlyMessages.add(lr);
                }
                this.setLimitForRotation(rotationLimitAttrValue);
            }
        }
        String ff = manager.getProperty(cname + ".flushFrequency");
        if (ff != null) {
            try {
                this.flushFrequency = Integer.parseInt(manager.getProperty(cname + ".flushFrequency"));
            }
            catch (NumberFormatException e) {
                lr = new LogRecord(Level.WARNING, "Can't find flushFrequency property from logging config file so using default.");
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        if (this.flushFrequency <= 0) {
            this.flushFrequency = 1;
        }
        if ((formatterName = manager.getProperty(cname + ".formatter")) == null || UniformLogFormatter.class.getName().equals(formatterName)) {
            UniformLogFormatter formatterClass = null;
            if (this.agent != null) {
                formatterClass = new UniformLogFormatter(new AgentFormatterDelegate(this.agent));
                this.setFormatter(formatterClass);
            } else {
                formatterClass = new UniformLogFormatter();
                this.setFormatter(formatterClass);
            }
            if (formatterClass != null) {
                this.recordBeginMarker = manager.getProperty(cname + ".logFormatBeginMarker");
                if (this.recordBeginMarker == null || "".equals(this.recordBeginMarker)) {
                    this.recordBeginMarker = this.RECORD_BEGIN_MARKER;
                }
                this.recordEndMarker = manager.getProperty(cname + ".logFormatEndMarker");
                if (this.recordEndMarker == null || "".equals(this.recordEndMarker)) {
                    this.recordEndMarker = this.RECORD_END_MARKER;
                }
                this.recordFieldSeparator = manager.getProperty(cname + ".logFormatFieldSeparator");
                if (this.recordFieldSeparator == null || "".equals(this.recordFieldSeparator) || this.recordFieldSeparator.length() > 1) {
                    this.recordFieldSeparator = this.RECORD_FIELD_SEPARATOR;
                }
                this.recordDateFormat = manager.getProperty(cname + ".logFormatDateFormat");
                if (this.recordDateFormat != null && !"".equals(this.recordDateFormat)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(this.recordDateFormat);
                    try {
                        sdf.format(new Date());
                    }
                    catch (Exception e) {
                        this.recordDateFormat = this.RECORD_DATE_FORMAT;
                    }
                } else {
                    this.recordDateFormat = this.RECORD_DATE_FORMAT;
                }
                formatterClass.setRecordBeginMarker(this.recordBeginMarker);
                formatterClass.setRecordEndMarker(this.recordEndMarker);
                formatterClass.setRecordDateFormat(this.recordDateFormat);
                formatterClass.setRecordFieldSeparator(this.recordFieldSeparator);
            }
        } else {
            try {
                this.setFormatter((Formatter)this.getClass().getClassLoader().loadClass(formatterName).newInstance());
            }
            catch (InstantiationException e) {
                lr = new LogRecord(Level.SEVERE, "Cannot instantiate formatter class " + formatterName);
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            catch (IllegalAccessException e) {
                lr = new LogRecord(Level.SEVERE, "Cannot instantiate formatter class " + formatterName);
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            catch (ClassNotFoundException e) {
                lr = new LogRecord(Level.SEVERE, "Cannot load formatter class " + formatterName);
                lr.setThreadID((int)Thread.currentThread().getId());
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
        try {
            this.maxHistoryFiles = Integer.parseInt(manager.getProperty(cname + ".maxHistoryFiles"));
        }
        catch (NumberFormatException e) {
            lr = new LogRecord(Level.WARNING, "Can't find maxHistoryFiles property from logging config file so using default.");
            lr.setThreadID((int)Thread.currentThread().getId());
            lr.setLoggerName(this.getClass().getName());
            EarlyLogHandler.earlyMessages.add(lr);
        }
        if (this.maxHistoryFiles < 0) {
            this.maxHistoryFiles = 10;
        }
    }

    public void preDestroy() {
        LogDomains.getLogger(GFFileHandler.class, (String)"javax.enterprise.system.core").fine("Logger handler killed");
        this.done.tryReleaseShared(1);
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                super.publish(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeFileName(File file) {
        if (file.equals(this.absoluteFile)) {
            return;
        }
        GFFileHandler gFFileHandler = this;
        synchronized (gFFileHandler) {
            super.flush();
            super.close();
            try {
                this.openFile(file);
                this.absoluteFile = file;
            }
            catch (IOException ix) {
                new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE. Please Check to make sure that the directory for Logfile exists. Currently reverting back to use the  default server.log", ix, 4);
                try {
                    this.openFile(this.absoluteFile);
                }
                catch (Exception e) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT RE-OPEN SERVER LOG FILE. ", e, 4);
                }
            }
        }
    }

    public File getCurrentLogFile() {
        return this.absoluteFile;
    }

    synchronized void setLimitForRotation(int rotationLimitInBytes) {
        this.limitForFileRotation = rotationLimitInBytes;
    }

    private void openFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, file.length());
        this.setOutputStream(this.meter);
    }

    void requestRotation() {
        this.rotationRequested.set(true);
    }

    public void cleanUpHistoryLogFiles() {
        if (this.maxHistoryFiles == 0) {
            return;
        }
        File dir = this.absoluteFile.getParentFile();
        if (dir == null) {
            return;
        }
        File[] fset = dir.listFiles();
        ArrayList<String> candidates = new ArrayList<String>();
        for (int i = 0; fset != null && i < fset.length; ++i) {
            if (this.logFileName.equals(fset[i].getName()) || !fset[i].isFile() || !fset[i].getName().startsWith(this.logFileName)) continue;
            candidates.add(fset[i].getAbsolutePath());
        }
        if (candidates.size() <= this.maxHistoryFiles) {
            return;
        }
        Object[] pathes = candidates.toArray();
        Arrays.sort(pathes);
        try {
            for (int i = 0; i < pathes.length - this.maxHistoryFiles; ++i) {
                File logFile = new File((String)pathes[i]);
                boolean delFile = logFile.delete();
                if (delFile) continue;
                this.publish(new LogRecord(Level.SEVERE, "Error, could not delete log file: " + logFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            new ErrorManager().error("FATAL ERROR: COULD NOT DELETE LOG FILE..", e, 0);
        }
    }

    public void rotate() {
        final GFFileHandler thisInstance = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thisInstance.flush();
                thisInstance.close();
                try {
                    if (!GFFileHandler.this.absoluteFile.exists()) {
                        File creatingDeletedLogFile = new File(GFFileHandler.this.absoluteFile.getAbsolutePath());
                        creatingDeletedLogFile.createNewFile();
                        GFFileHandler.this.absoluteFile = creatingDeletedLogFile;
                    }
                    File oldFile = GFFileHandler.this.absoluteFile;
                    StringBuffer renamedFileName = new StringBuffer(GFFileHandler.this.absoluteFile + "_");
                    logRotateDateFormatter.format(new Date(), renamedFileName, new FieldPosition(0));
                    File rotatedFile = new File(renamedFileName.toString());
                    boolean renameSuccess = oldFile.renameTo(rotatedFile);
                    if (!renameSuccess) {
                        FileUtils.copy((File)GFFileHandler.this.absoluteFile, (File)rotatedFile);
                        File freshServerLogFile = GFFileHandler.this.getLogFileName();
                        FileOutputStream fo = new FileOutputStream(freshServerLogFile);
                        fo.close();
                    }
                    FileOutputStream oldFileFO = new FileOutputStream(oldFile);
                    oldFileFO.close();
                    GFFileHandler.this.openFile(GFFileHandler.this.getLogFileName());
                    GFFileHandler.this.absoluteFile = GFFileHandler.this.getLogFileName();
                    if (GFFileHandler.this.dayBasedFileRotation) {
                        LogRotationTimer.getInstance().restartTimerForDayBasedRotation();
                    } else {
                        LogRotationTimer.getInstance().restartTimer();
                    }
                    GFFileHandler.this.cleanUpHistoryLogFiles();
                }
                catch (IOException ix) {
                    System.out.println("Error, could not find log file : " + ix.getMessage());
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        try {
            LogRecord record = this.pendingRecords.take();
            super.publish(record);
        }
        catch (InterruptedException e) {
            return;
        }
        Vector v = new Vector();
        int msgs = this.pendingRecords.drainTo(v, this.flushFrequency);
        for (int j = 0; j < msgs; ++j) {
            super.publish((LogRecord)v.get(j));
        }
        this.flush();
        if (this.rotationRequested.get() || this.limitForFileRotation > 0 && this.meter.written >= (long)this.limitForFileRotation) {
            AtomicBoolean atomicBoolean = this.rotationRequested;
            synchronized (atomicBoolean) {
                this.rotate();
                this.rotationRequested.set(false);
            }
        }
    }

    public void publish(LogRecord record) {
        if (this.done.isSignalled()) {
            return;
        }
        try {
            this.pendingRecords.add(record);
        }
        catch (IllegalStateException e) {
            try {
                this.pendingRecords.put(record);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected File getLogFileName() {
        return new File(this.absoluteServerLogName);
    }

    private final class MeteredStream
    extends OutputStream {
        private volatile boolean isOpen = false;
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
            this.isOpen = true;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            if (this.isOpen) {
                this.isOpen = false;
                this.flush();
                this.out.close();
            }
        }
    }
}

