/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.io.StorageRandomAccessFile;

class RAFContainer4
extends RAFContainer {
    private FileChannel ourChannel = null;
    private final Object channelCleanupMonitor = new Object();
    private Thread threadDoingRestore = null;
    private volatile int threadsInPageIO = 0;
    private volatile boolean restoreChannelInProgress = false;
    private boolean giveUpIO = false;
    private final Object giveUpIOm = new Object();
    private int iosInProgress = 0;

    public RAFContainer4(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    private FileChannel getChannel(StorageRandomAccessFile storageRandomAccessFile) {
        if (storageRandomAccessFile instanceof RandomAccessFile) {
            return ((RandomAccessFile)((Object)storageRandomAccessFile)).getChannel();
        }
        return null;
    }

    private FileChannel getChannel() {
        if (this.ourChannel == null) {
            this.ourChannel = this.getChannel(this.fileData);
        }
        return this.ourChannel;
    }

    synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        return super.openContainer(containerKey);
    }

    synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        super.createContainer(containerKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeContainer() {
        if (this.ourChannel != null) {
            try {
                this.ourChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ourChannel = null;
            }
        }
        super.closeContainer();
    }

    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        this.readPage(l, byArray, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPage(long l, byte[] byArray, long l2) throws IOException, StandardException {
        Object object;
        int n;
        boolean bl;
        boolean bl2 = Thread.holdsLock(this);
        boolean bl3 = Thread.holdsLock(this.allocCache);
        boolean bl4 = bl = bl2 || bl3;
        if (!bl) {
            Object object2 = this.channelCleanupMonitor;
            synchronized (object2) {
                n = 120;
                while (this.restoreChannelInProgress && Thread.currentThread() != this.threadDoingRestore) {
                    if (n-- == 0) {
                        throw StandardException.newException("XSDG9.D");
                    }
                    try {
                        this.channelCleanupMonitor.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                ++this.threadsInPageIO;
            }
        }
        boolean bl5 = false;
        n = 120;
        try {
            while (!bl5) {
                try {
                    if (l == 0L) {
                        object = this;
                        synchronized (object) {
                            this.readPage0(l, byArray, l2);
                        }
                    } else {
                        this.readPage0(l, byArray, l2);
                    }
                    bl5 = true;
                }
                catch (AsynchronousCloseException asynchronousCloseException) {
                    if (Thread.currentThread().isInterrupted() && this.recoverContainerAfterInterrupt(asynchronousCloseException.toString(), bl)) continue;
                    this.awaitRestoreChannel(asynchronousCloseException, bl);
                }
                catch (ClosedChannelException closedChannelException) {
                    InterruptStatus.noteAndClearInterrupt("readPage in ClosedChannelException", this.threadsInPageIO, this.hashCode());
                    this.awaitRestoreChannel(closedChannelException, bl);
                    if (n-- != 0) continue;
                    throw StandardException.newException("XSDG9.D");
                    return;
                }
            }
        }
        finally {
            if (!bl) {
                object = this.channelCleanupMonitor;
                synchronized (object) {
                    --this.threadsInPageIO;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage0(long l, byte[] byArray, long l2) throws IOException, StandardException {
        FileChannel fileChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            fileChannel = this.getChannel();
        }
        if (fileChannel != null) {
            long l3 = l * (long)this.pageSize;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            if (l2 == -1L) {
                this.readFull(byteBuffer, fileChannel, l3);
            } else {
                this.readFull(byteBuffer, fileChannel, l2);
            }
            if (this.dataFactory.databaseEncrypted() && l != 0L && l != -1L) {
                this.decryptPage(byArray, this.pageSize);
            }
        } else {
            super.readPage(l, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        Object object;
        int n;
        boolean bl2 = Thread.holdsLock(this.allocCache);
        if (!bl2) {
            Object object2 = this.channelCleanupMonitor;
            synchronized (object2) {
                n = 120;
                while (this.restoreChannelInProgress) {
                    if (n-- == 0) {
                        throw StandardException.newException("XSDG9.D");
                    }
                    try {
                        this.channelCleanupMonitor.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                ++this.threadsInPageIO;
            }
        }
        boolean bl3 = false;
        n = 120;
        try {
            while (!bl3) {
                try {
                    if (l == 0L) {
                        object = this;
                        synchronized (object) {
                            this.writePage0(l, byArray, bl);
                        }
                    } else {
                        this.writePage0(l, byArray, bl);
                    }
                    bl3 = true;
                }
                catch (AsynchronousCloseException asynchronousCloseException) {
                    if (Thread.currentThread().isInterrupted() && this.recoverContainerAfterInterrupt(asynchronousCloseException.toString(), bl2)) continue;
                    this.awaitRestoreChannel(asynchronousCloseException, bl2);
                }
                catch (ClosedChannelException closedChannelException) {
                    InterruptStatus.noteAndClearInterrupt("writePage in ClosedChannelException", this.threadsInPageIO, this.hashCode());
                    this.awaitRestoreChannel(closedChannelException, bl2);
                    if (n-- != 0) continue;
                    throw StandardException.newException("XSDG9.D");
                    return;
                }
            }
        }
        finally {
            if (!bl2) {
                object = this.channelCleanupMonitor;
                synchronized (object) {
                    --this.threadsInPageIO;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitRestoreChannel(Exception exception, boolean bl) throws StandardException {
        if (bl) {
            Object object = this.giveUpIOm;
            synchronized (object) {
                if (this.giveUpIO) {
                    throw StandardException.newException("XSDG9.D");
                }
            }
            throw new InterruptDetectedException();
        }
        Object object = this.channelCleanupMonitor;
        synchronized (object) {
            --this.threadsInPageIO;
        }
        int n = -1;
        Object object2 = this.channelCleanupMonitor;
        synchronized (object2) {
            while (this.restoreChannelInProgress) {
                if (++n > 120) {
                    throw StandardException.newException("XSDG9.D", exception);
                }
                try {
                    this.channelCleanupMonitor.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            ++this.threadsInPageIO;
        }
        object2 = this.giveUpIOm;
        synchronized (object2) {
            if (this.giveUpIO) {
                --this.threadsInPageIO;
                throw StandardException.newException("XSDG9.D");
            }
        }
        if (n == -1) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean recoverContainerAfterInterrupt(String var1_1, boolean var2_2) throws StandardException {
        if (var2_2 && this.restoreChannelInProgress) {
            InterruptStatus.noteAndClearInterrupt(var1_1, this.threadsInPageIO, this.hashCode());
            return false;
        }
        var3_3 = this.channelCleanupMonitor;
        // MONITORENTER : var3_3
        if (this.restoreChannelInProgress) {
            InterruptStatus.noteAndClearInterrupt(var1_1, this.threadsInPageIO, this.hashCode());
            // MONITOREXIT : var3_3
            return false;
        }
        if (!var2_2) {
            --this.threadsInPageIO;
        }
        this.restoreChannelInProgress = true;
        this.threadDoingRestore = Thread.currentThread();
        // MONITOREXIT : var3_3
        var3_4 = 120;
        while (true) {
            var4_5 = this.channelCleanupMonitor;
            // MONITORENTER : var4_5
            if (this.threadsInPageIO == 0) {
                // MONITOREXIT : var4_5
                var4_5 = this.channelCleanupMonitor;
                // MONITORENTER : var4_5
                ** try [egrp 4[TRYBLOCK] [15 : 191->319)] { 
lbl26:
                // 1 sources

                break;
            }
            if (var3_4-- == 0) {
                this.threadDoingRestore = null;
                this.restoreChannelInProgress = false;
                this.channelCleanupMonitor.notifyAll();
                throw StandardException.newException("XSDG9.D");
            }
            // MONITOREXIT : var4_5
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException var4_6) {
                InterruptStatus.setInterrupted();
            }
        }
        {
            InterruptStatus.noteAndClearInterrupt(var1_1, this.threadsInPageIO, this.hashCode());
            var5_7 = this;
            // MONITORENTER : var5_7
            // MONITOREXIT : var5_7
            while (true) {
                var5_7 = this;
                // MONITORENTER : var5_7
                try {
                    this.closeContainer();
                    this.reopenContainer(this.currentIdentity);
                }
                catch (InterruptDetectedException var6_8) {
                    RAFContainer4.debugTrace("interrupted during recovery's readEmbryonicPage");
                    // MONITOREXIT : var5_7
                    continue;
                }
                catch (Exception var6_9) {
                    var7_10 = this.giveUpIOm;
                    // MONITORENTER : var7_10
                    this.giveUpIO = true;
                    throw StandardException.newException("XSDG9.D", var6_9);
                }
                break;
            }
            // MONITOREXIT : var5_7
            if (var2_2) {
                return true;
            }
            ++this.threadsInPageIO;
            return true;
        }
lbl66:
        // 1 sources

        finally {
            this.restoreChannelInProgress = false;
            this.threadDoingRestore = null;
            this.channelCleanupMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePage0(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        FileChannel fileChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            if (this.getCommittedDropState()) {
                return;
            }
            fileChannel = this.getChannel();
        }
        if (fileChannel != null) {
            long l2 = l * (long)this.pageSize;
            byte[] byArray2 = null;
            if (this.dataFactory.databaseEncrypted()) {
                byArray2 = new byte[this.pageSize];
            }
            byte[] byArray3 = this.updatePageArray(l, byArray, byArray2, false);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            this.dataFactory.writeInProgress();
            try {
                this.writeFull(byteBuffer, fileChannel, l2);
            }
            catch (ClosedChannelException closedChannelException) {
                RAFContainer4 rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    block25: {
                        if (!this.getCommittedDropState()) break block25;
                        return;
                    }
                    throw closedChannelException;
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    fileChannel.force(false);
                    return;
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                RAFContainer4 rAFContainer43 = this;
                synchronized (rAFContainer43) {
                    this.needsSync = true;
                    return;
                }
            }
        }
        super.writePage(l, byArray, bl);
    }

    void writeAtOffset(StorageRandomAccessFile storageRandomAccessFile, byte[] byArray, long l) throws IOException, StandardException {
        FileChannel fileChannel = this.getChannel(storageRandomAccessFile);
        if (fileChannel != null) {
            this.writeFull(ByteBuffer.wrap(byArray), fileChannel, l);
        } else {
            super.writeAtOffset(storageRandomAccessFile, byArray, l);
        }
    }

    byte[] getEmbryonicPage(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        FileChannel fileChannel = this.getChannel(storageRandomAccessFile);
        if (fileChannel != null) {
            byte[] byArray = new byte[204];
            this.readPage(-1L, byArray, l);
            return byArray;
        }
        return super.getEmbryonicPage(storageRandomAccessFile, l);
    }

    private void readFull(ByteBuffer byteBuffer, FileChannel fileChannel, long l) throws IOException, StandardException {
        while (byteBuffer.remaining() > 0) {
            if (fileChannel.read(byteBuffer, l + (long)byteBuffer.position()) == -1) {
                throw new EOFException("Reached end of file while attempting to read a whole page.");
            }
            if (!Thread.currentThread().isInterrupted() || fileChannel.isOpen()) continue;
            throw new ClosedByInterruptException();
        }
    }

    private void writeFull(ByteBuffer byteBuffer, FileChannel fileChannel, long l) throws IOException {
        while (byteBuffer.remaining() > 0) {
            fileChannel.write(byteBuffer, l + (long)byteBuffer.position());
            if (!Thread.currentThread().isInterrupted() || fileChannel.isOpen()) continue;
            throw new ClosedByInterruptException();
        }
    }

    private static void debugTrace(String string) {
    }
}

