/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.DispatchedHttpServletRequest;
import com.sun.grizzly.http.servlet.DispatchedHttpServletResponse;
import com.sun.grizzly.http.servlet.DispatcherConstants;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RequestDispatcherImpl
implements RequestDispatcher {
    private static final Logger logger = Logger.getLogger(RequestDispatcherImpl.class.getName());
    private Boolean crossContextFlag = null;
    private String name = null;
    private String requestURI = null;
    private String servletPath = null;
    private String pathInfo = null;
    private String queryString = null;
    private ServletAdapter wrapper = null;

    public RequestDispatcherImpl(ServletAdapter wrapper, String requestURI, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + queryString + ", name=" + this.name);
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response, DispatcherConstants.DispatcherType.FORWARD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletRequest request, ServletResponse response, DispatcherConstants.DispatcherType dispatcherType) throws ServletException, IOException {
        boolean isCommit;
        if (!(DispatcherConstants.DispatcherType.FORWARD.equals((Object)dispatcherType) || DispatcherConstants.DispatcherType.ERROR.equals((Object)dispatcherType) || DispatcherConstants.DispatcherType.ASYNC.equals((Object)dispatcherType))) {
            throw new IllegalArgumentException("Illegal dispatcher type");
        }
        boolean bl = isCommit = DispatcherConstants.DispatcherType.FORWARD.equals((Object)dispatcherType) || DispatcherConstants.DispatcherType.ERROR.equals((Object)dispatcherType);
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedDispatch dp = new PrivilegedDispatch(request, response, dispatcherType);
                AccessController.doPrivileged(dp);
                if (!isCommit) return;
                RequestDispatcherImpl.closeResponse(response);
                return;
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (!(e instanceof ServletException)) throw (IOException)e;
                throw (ServletException)e;
            }
        } else {
            this.doDispatch(request, response, dispatcherType);
            if (!isCommit) return;
            RequestDispatcherImpl.closeResponse(response);
        }
    }

    private void doDispatch(ServletRequest request, ServletResponse response, DispatcherConstants.DispatcherType dispatcherType) throws ServletException, IOException {
        if (!DispatcherConstants.DispatcherType.ASYNC.equals((Object)dispatcherType)) {
            if (response.isCommitted()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  Forward on committed response --> ISE");
                }
                throw new IllegalStateException("Cannot forward after response has been committed");
            }
            try {
                response.resetBuffer();
            }
            catch (IllegalStateException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  Forward resetBuffer() returned ISE: " + e);
                }
                throw e;
            }
        }
        State state = new State(request, response, dispatcherType);
        HttpServletRequest hrequest = null;
        if (request instanceof HttpServletRequest) {
            hrequest = (HttpServletRequest)request;
        }
        HttpServletResponse hresponse = null;
        if (response instanceof HttpServletResponse) {
            hresponse = (HttpServletResponse)response;
        }
        if (hrequest == null || hresponse == null) {
            DispatchedHttpServletRequest wrequest = this.wrapRequest(state);
            this.processRequest(request, response, state, wrequest.getRequestFacade());
            this.unwrapRequest(state);
            wrequest.recycle();
        } else if (this.servletPath == null && this.pathInfo == null) {
            DispatchedHttpServletRequest wrequest = this.wrapRequest(state);
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state, wrequest.getRequestFacade());
            this.unwrapRequest(state);
            wrequest.recycle();
        } else {
            DispatchedHttpServletRequest wrequest = this.wrapRequest(state);
            if (DispatcherConstants.DispatcherType.FORWARD.equals((Object)dispatcherType) && hrequest.getAttribute("javax.servlet.forward.request_uri") == null || DispatcherConstants.DispatcherType.ASYNC.equals((Object)dispatcherType) && hrequest.getAttribute("javax.servlet.async.request_uri") == null) {
                wrequest.initSpecialAttributes(hrequest.getRequestURI(), hrequest.getContextPath(), hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString());
            }
            String targetContextPath = this.wrapper.getContextPath();
            HttpServletRequestImpl requestFacade = wrequest.getRequestFacade();
            String originContextPath = requestFacade.getContextPath();
            if (originContextPath != null && originContextPath.equals(targetContextPath)) {
                targetContextPath = hrequest.getContextPath();
            }
            wrequest.setContextPath(targetContextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
            }
            this.processRequest(request, response, state, wrequest.getRequestFacade());
            this.unwrapRequest(state);
            wrequest.recycle();
        }
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state, HttpServletRequestImpl requestFacade) throws IOException, ServletException {
        if (request != null) {
            if (state.dispatcherType != DispatcherConstants.DispatcherType.ERROR) {
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.getCombinedPath());
                this.invoke(state.outerRequest, response, requestFacade);
            } else {
                this.invoke(state.outerRequest, response, requestFacade);
            }
        }
    }

    private String getCombinedPath() {
        if (this.servletPath == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return this.servletPath;
        }
        return this.servletPath + this.pathInfo;
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, DispatcherConstants.DispatcherType.INCLUDE);
        this.wrapResponse(state);
        if (this.name != null) {
            DispatchedHttpServletRequest wrequest = this.wrapRequest(state);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            try {
                this.invoke(state.outerRequest, state.outerResponse, wrequest.getRequestFacade());
            }
            finally {
                this.unwrapRequest(state);
                this.unwrapResponse(state);
            }
        }
        DispatchedHttpServletRequest wrequest = this.wrapRequest(state);
        wrequest.initSpecialAttributes(this.requestURI, this.wrapper.getContextPath(), this.servletPath, this.pathInfo, this.queryString);
        if (this.queryString != null) {
            wrequest.setQueryString(this.queryString);
        }
        wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
        try {
            this.invoke(state.outerRequest, state.outerResponse, wrequest.getRequestFacade());
        }
        finally {
            this.unwrapRequest(state);
            this.unwrapResponse(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response, HttpServletRequestImpl requestFacade) throws IOException, ServletException {
        boolean crossContext = false;
        if (this.crossContextFlag != null && this.crossContextFlag.booleanValue()) {
            crossContext = true;
        }
        try {
            this.doInvoke(request, response, crossContext, requestFacade);
        }
        finally {
            this.crossContextFlag = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke(ServletRequest request, ServletResponse response, boolean crossContext, HttpServletRequestImpl requestFacade) throws IOException, ServletException {
        ClassLoader oldCCL = null;
        try {
            ClassLoader contextClassLoader;
            if (crossContext && (contextClassLoader = this.wrapper.getClassLoader()) != null) {
                oldCCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            this.wrapper.doServletService(request, response);
            if (oldCCL != null) {
                Thread.currentThread().setContextClassLoader(oldCCL);
            }
        }
        catch (Throwable throwable) {
            if (oldCCL != null) {
                Thread.currentThread().setContextClassLoader(oldCCL);
            }
            throw throwable;
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !(current instanceof HttpServletRequestImpl)) {
            if (current == state.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    state.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && !(current instanceof HttpServletResponseImpl)) {
            if (current == state.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    state.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private DispatchedHttpServletRequest wrapRequest(State state) {
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && current instanceof ServletRequestWrapper && !(current instanceof DispatchedHttpServletRequest) && !(current instanceof HttpServletRequestImpl)) {
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        if (current == null) {
            return null;
        }
        HttpServletRequest hcurrent = (HttpServletRequest)current;
        boolean crossContext = !this.wrapper.getContextPath().equals(hcurrent.getContextPath());
        this.crossContextFlag = crossContext;
        DispatchedHttpServletRequest wrapper = new DispatchedHttpServletRequest(hcurrent, state.dispatcherType);
        if (previous == null) {
            state.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest((ServletRequest)wrapper);
        }
        state.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && current instanceof ServletResponseWrapper && !(current instanceof DispatchedHttpServletResponse) && !(current instanceof HttpServletResponseImpl)) {
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        if (current == null) {
            return null;
        }
        HttpServletResponse hcurrent = (HttpServletResponse)current;
        DispatchedHttpServletResponse wrapper = new DispatchedHttpServletResponse(hcurrent, DispatcherConstants.DispatcherType.INCLUDE.equals((Object)state.dispatcherType));
        if (previous == null) {
            state.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse((ServletResponse)wrapper);
        }
        state.wrapResponse = wrapper;
        return wrapper;
    }

    private static void closeResponse(ServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            writer.flush();
            writer.close();
        }
        catch (IllegalStateException e) {
            try {
                ServletOutputStream stream = response.getOutputStream();
                stream.flush();
                stream.close();
            }
            catch (IllegalStateException f) {
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class PrivilegedDispatch
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;
        private DispatcherConstants.DispatcherType dispatcherType;

        PrivilegedDispatch(ServletRequest request, ServletResponse response, DispatcherConstants.DispatcherType dispatcherType) {
            this.request = request;
            this.response = response;
            this.dispatcherType = dispatcherType;
        }

        public Object run() throws Exception {
            RequestDispatcherImpl.this.doDispatch(this.request, this.response, this.dispatcherType);
            return null;
        }
    }

    private class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            RequestDispatcherImpl.this.doInclude(this.request, this.response);
            return null;
        }
    }

    private static class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        DispatcherConstants.DispatcherType dispatcherType;

        State(ServletRequest request, ServletResponse response, DispatcherConstants.DispatcherType dispatcherType) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.dispatcherType = dispatcherType;
        }
    }
}

