/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.glassfish.web.valve.GlassFishValve;

public class AdHocContextValve
implements GlassFishValve {
    private static final Logger LOGGER = LogDomains.getLogger(AdHocContextValve.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = LOGGER.getResourceBundle();
    private static final String VALVE_INFO = "com.sun.enterprise.web.AdHocContextValve";
    private WebModule context;

    public AdHocContextValve(WebModule context) {
        this.context = context;
    }

    public String getInfo() {
        return VALVE_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int invoke(Request request, Response response) throws IOException, ServletException {
        Servlet adHocServlet;
        Wrapper adHocWrapper;
        block6: {
            HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
            HttpServletResponse hres = (HttpServletResponse)response.getResponse();
            String adHocServletName = this.context.getAdHocServletName(hreq.getServletPath());
            adHocWrapper = (Wrapper)this.context.findChild(adHocServletName);
            if (adHocWrapper != null) {
                adHocServlet = null;
                try {
                    try {
                        adHocServlet = adHocWrapper.allocate();
                        adHocServlet.service(hreq, hres);
                    }
                    catch (Throwable t) {
                        hres.sendError(500);
                        String msg = rb.getString("webmodule.adHocContextValve.adHocServletServiceError");
                        msg = MessageFormat.format(msg, hreq.getServletPath());
                        response.setDetailMessage(msg);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, msg, t);
                        }
                        int n = 2;
                        Object var12_10 = null;
                        if (adHocServlet == null) return n;
                        adHocWrapper.deallocate(adHocServlet);
                        return n;
                    }
                    Object var12_9 = null;
                    if (adHocServlet == null) return 2;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    if (adHocServlet == null) throw throwable;
                    adHocWrapper.deallocate(adHocServlet);
                    throw throwable;
                }
            }
            hres.sendError(500);
            String msg = rb.getString("webmodule.adHocContextValve.noAdHocServlet");
            msg = MessageFormat.format(msg, hreq.getServletPath());
            response.setDetailMessage(msg);
            return 2;
        }
        adHocWrapper.deallocate(adHocServlet);
        return 2;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
    }
}

