/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.DataSource;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

@ConnectionDefinition(connectionFactory=javax.sql.DataSource.class, connectionFactoryImpl=DataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class DSManagedConnectionFactory
extends ManagedConnectionFactory {
    private transient javax.sql.DataSource dataSourceObj;
    private static Logger _logger = LogDomains.getLogger(DSManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        javax.sql.DataSource dataSource = this.getDataSource();
        Connection dsConn = null;
        ManagedConnection mc = null;
        try {
            dsConn = this.isEqual(pc, this.getUser(), this.getPassword()) ? dataSource.getConnection() : dataSource.getConnection(pc.getUserName(), new String(pc.getPassword()));
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.exc_create_conn", sqle.getMessage());
            }
            StringManager localStrings = StringManager.getManager(DataSourceObjectBuilder.class);
            String msg = localStrings.getString("jdbc.cannot_allocate_connection", (Object)sqle.getMessage());
            ResourceAllocationException rae = new ResourceAllocationException(msg);
            rae.initCause((Throwable)sqle);
            throw rae;
        }
        try {
            mc = this.constructManagedConnection(null, dsConn, pc, this);
            this.validateAndSetIsolation(mc);
        }
        finally {
            if (mc == null && dsConn != null) {
                try {
                    dsConn.close();
                }
                catch (SQLException e) {
                    _logger.log(Level.FINEST, "Exception while closing connection : createManagedConnection" + dsConn);
                }
            }
        }
        return mc;
    }

    @Override
    public javax.sql.DataSource getDataSource() throws ResourceException {
        if (this.dataSourceObj == null) {
            try {
                this.dataSourceObj = (javax.sql.DataSource)super.getDataSource();
            }
            catch (ClassCastException cce) {
                _logger.log(Level.SEVERE, "jdbc.exc_cce", cce);
                throw new ResourceException(cce.getMessage());
            }
        }
        return this.dataSourceObj;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof DSManagedConnectionFactory) {
            DSManagedConnectionFactory otherMCF = (DSManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }
}

