/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.SessionManager;
import org.glassfish.admin.rest.resources.SessionResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.internal.api.AdminAccessController;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/sessions")
public class SessionsResource {
    @Context
    SessionManager sessionManager;
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    private ThreadLocal<GrizzlyRequest> request;
    @Context
    protected Habitat habitat;

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/xml", "text/html;qs=2"})
    public Response create(HashMap<String, String> data) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        RestActionReporter ar = new RestActionReporter();
        GrizzlyRequest grizzlyRequest = this.request.get();
        String hostName = data.get("remoteHostName");
        AdminAccessController.Access access = AdminAccessController.Access.NONE;
        try {
            access = hostName == null ? AdminAccessController.Access.FULL : ResourceUtil.authenticateViaAdminRealm(this.habitat, grizzlyRequest, hostName);
        }
        catch (Exception e) {
            ar.setMessage("Error while authenticating " + e);
        }
        if (access == AdminAccessController.Access.FULL) {
            responseBuilder.status(Response.Status.OK);
            String username = (String)grizzlyRequest.getAttribute("restUser");
            if (username != null) {
                ar.getExtraProperties().put("username", username);
            }
            ar.getExtraProperties().put("token", this.sessionManager.createSession(grizzlyRequest));
        } else if (access == AdminAccessController.Access.FORBIDDEN) {
            responseBuilder.status(Response.Status.FORBIDDEN);
        }
        return responseBuilder.entity((Object)new ActionReportResult(ar)).build();
    }

    @Path(value="{sessionId}/")
    public SessionResource getSessionResource(@PathParam(value="sessionId") String sessionId) {
        return new SessionResource(this.sessionManager, sessionId, this.requestHeaders, this.uriInfo);
    }
}

