/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class TableExpression
extends DataExpression {
    protected DatabaseTable table;

    public TableExpression() {
    }

    public TableExpression(DatabaseTable aTable) {
        this.table = aTable;
    }

    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        QueryKeyExpression qkExpression;
        if (this.baseExpression.isQueryKeyExpression() && (qkExpression = (QueryKeyExpression)this.baseExpression).getTableAliases() != null && qkExpression.getTableAliases().keyAtValue(table) != null) {
            return;
        }
        super.assignAlias(alias, table);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TableExpression expression = (TableExpression)object;
        return this.getTable() == expression.getTable() || this.getTable() != null && this.getTable().equals(expression.getTable());
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getTable() != null) {
            hashCode += this.getTable().hashCode();
        }
        return hashCode;
    }

    public String descriptionOfNodeType() {
        return "Table";
    }

    public Expression getField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        if (!field.hasTableName()) {
            field.setTable(this.getTable());
        }
        return this.getField(field);
    }

    public Vector getOwnedTables() {
        Vector<DatabaseTable> result = new Vector<DatabaseTable>(1);
        result.addElement(this.getTable());
        return result;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public boolean isTableExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.getTable().getTableQualifier().length() == 0 && normalizer.getSession().getDatasourceLogin().getTableQualifier().length() != 0) {
            this.getTable().setTableQualifier(normalizer.getSession().getDatasourceLogin().getTableQualifier());
        }
        return super.normalize(normalizer);
    }

    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getTable(this.getTable());
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context, oldBase);
        return twistedBase.getTable(this.getTable());
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getTable().toString());
        writer.write(this.tableAliasesDescription());
    }
}

