/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.digest.impl;

import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.DigestParameterGenerator;
import com.sun.enterprise.security.auth.digest.impl.DigestAlgorithmParameterImpl;
import com.sun.enterprise.security.auth.digest.impl.HttpAlgorithmParameterImpl;
import com.sun.enterprise.security.auth.digest.impl.KeyDigestAlgoParamImpl;
import com.sun.enterprise.security.auth.digest.impl.NestedDigestAlgoParamImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public final class HttpDigestParamGenerator
extends DigestParameterGenerator {
    private StringTokenizer commaTokenizer = null;
    private String userName = null;
    private String realmName = null;
    private String nOnce = null;
    private String nc = null;
    private String cnonce = null;
    private String qop = null;
    private String uri = null;
    private String response = null;
    private String method = null;
    private byte[] entityBody = null;
    private String algorithm = "MD5";
    private DigestAlgorithmParameter secret = null;
    private DigestAlgorithmParameter key = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigestAlgorithmParameter[] generateParameters(AlgorithmParameterSpec param) throws InvalidAlgorithmParameterException {
        ServletInputStream sis = null;
        HttpServletRequest request = null;
        if (!(param instanceof HttpAlgorithmParameterImpl)) {
            throw new InvalidAlgorithmParameterException(param.getClass().toString());
        }
        request = ((HttpAlgorithmParameterImpl)param).getValue();
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        this.commaTokenizer = new StringTokenizer(authorization, ",");
        this.method = request.getMethod();
        while (this.commaTokenizer.hasMoreTokens()) {
            String currentToken = this.commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                this.userName = HttpDigestParamGenerator.removeQuotes(currentTokenValue);
                continue;
            }
            if ("realm".equals(currentTokenName)) {
                this.realmName = HttpDigestParamGenerator.removeQuotes(currentTokenValue, true);
                continue;
            }
            if ("nonce".equals(currentTokenName)) {
                this.nOnce = HttpDigestParamGenerator.removeQuotes(currentTokenValue);
                continue;
            }
            if ("nc".equals(currentTokenName)) {
                this.nc = currentTokenValue;
                continue;
            }
            if ("cnonce".equals(currentTokenName)) {
                this.cnonce = HttpDigestParamGenerator.removeQuotes(currentTokenValue);
                continue;
            }
            if ("qop".equals(currentTokenName)) {
                this.qop = HttpDigestParamGenerator.removeQuotes(currentTokenValue);
                continue;
            }
            if ("uri".equals(currentTokenName)) {
                this.uri = HttpDigestParamGenerator.removeQuotes(currentTokenValue);
                continue;
            }
            if (!"response".equals(currentTokenName)) continue;
            this.response = HttpDigestParamGenerator.removeQuotes(currentTokenValue);
        }
        if (this.userName == null || this.realmName == null || this.nOnce == null || this.uri == null || this.response == null) {
            return null;
        }
        if (this.qop == null) {
            this.qop = "auth";
        }
        if ("auth-int".equals(this.qop)) {
            try {
                byte[] data;
                int len;
                sis = request.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((len = sis.read(data = new byte[1024], 0, 1023)) != -1) {
                    bos.write(data, 0, len);
                }
                this.entityBody = bos.toByteArray();
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    sis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, null, ex);
                }
            }
        }
        this.key = this.getA1();
        DigestAlgorithmParameter a2 = this.getA2();
        DigestAlgorithmParameterImpl p1 = new DigestAlgorithmParameterImpl("nonce", this.nOnce.getBytes());
        AlgorithmParameterSpec[] list = null;
        if ("auth-int".equals(this.qop) || "auth".equals(this.qop)) {
            DigestAlgorithmParameterImpl p2 = new DigestAlgorithmParameterImpl("nc", this.nc.getBytes());
            DigestAlgorithmParameterImpl p3 = new DigestAlgorithmParameterImpl("cnonce", this.cnonce.getBytes());
            DigestAlgorithmParameterImpl p4 = new DigestAlgorithmParameterImpl("qop", this.qop.getBytes());
            list = new DigestAlgorithmParameter[]{p1, p2, p3, p4, a2};
        } else {
            list = new DigestAlgorithmParameter[]{p1, a2};
        }
        this.secret = new DigestAlgorithmParameterImpl("response", this.response.getBytes());
        DigestAlgorithmParameter[] data = new DigestAlgorithmParameter[]{new NestedDigestAlgoParamImpl("data", list), this.secret, this.key};
        return data;
    }

    protected DigestAlgorithmParameter getA1() {
        return new KeyDigestAlgoParamImpl(this.algorithm, this.userName, this.realmName);
    }

    protected DigestAlgorithmParameter getA2() {
        DigestAlgorithmParameterImpl p1 = new DigestAlgorithmParameterImpl("method", this.method.getBytes());
        DigestAlgorithmParameterImpl p2 = new DigestAlgorithmParameterImpl("uri", this.uri.getBytes());
        if ("auth".equals(this.qop)) {
            AlgorithmParameterSpec[] list = new DigestAlgorithmParameterImpl[]{p1, p2};
            NestedDigestAlgoParamImpl a2 = new NestedDigestAlgoParamImpl(this.algorithm, "A2", list);
            return a2;
        }
        if ("auth-int".equals(this.qop)) {
            AlgorithmParameterSpec[] list = new AlgorithmParameterSpec[3];
            DigestAlgorithmParameterImpl p3 = new DigestAlgorithmParameterImpl("enity-body", this.algorithm, this.entityBody);
            list[0] = p1;
            list[1] = p2;
            list[2] = p3;
            NestedDigestAlgoParamImpl a2 = new NestedDigestAlgoParamImpl(this.algorithm, "A2", list);
            return a2;
        }
        return null;
    }

    protected static String removeQuotes(String quotedString) {
        return HttpDigestParamGenerator.removeQuotes(quotedString, false);
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }
}

