/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-file-user")
@Scoped(value=PerLookup.class)
@I18n(value="create.file.user")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateFileUser
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateFileUser.class);
    @Param(name="groups", optional=true, separator=58)
    private List<String> groups = new ArrayList<String>(0);
    @Param(name="userpassword", password=true)
    private String userpassword;
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Param(name="username", primary=true)
    private String userName;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    private AdminService adminService;
    @Inject
    private ServerEnvironment se;
    private SecureAdmin secureAdmin = null;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        SecurityService securityService = this.config.getSecurityService();
        AuthRealm fileAuthRealm = null;
        if (this.authRealmName == null) {
            this.authRealmName = securityService.getDefaultRealm();
        }
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(this.authRealmName)) continue;
            fileAuthRealm = authRealm;
            break;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("create.file.user.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("create.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        String kf = keyFile;
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("create.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean exists = new File(kf).exists();
        if (!exists) {
            report.setMessage(localStrings.getLocalString("file.realm.keyfilenonexistent", "The specified physical file {0} associated with the file realm {1} does not exist.", new Object[]{kf, this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final String password = this.userpassword;
        if (password == null) {
            report.setMessage(localStrings.getLocalString("create.file.user.keyfilenotreadable", "Password for user {0} has to be specified in --userpassword option or supplied through AS_ADMIN_USERPASSWORD property in the file specified in --passwordfile option", new Object[]{this.userName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.secureAdmin = this.domain.getSecureAdmin();
        if (SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin) && this.authRealmName.equals(this.adminService.getAuthRealmName()) && (password == null || password.isEmpty())) {
            report.setMessage(localStrings.getLocalString("null_empty_password", "The admin user password is null or empty"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    try {
                        FileRealm fr;
                        block4: {
                            CreateFileUser.this.realmsManager.createRealms(CreateFileUser.this.config);
                            CreateFileUser.refreshRealm(CreateFileUser.this.config.getName(), CreateFileUser.this.authRealmName);
                            fr = (FileRealm)CreateFileUser.this.realmsManager.getFromLoadedRealms(CreateFileUser.this.config.getName(), CreateFileUser.this.authRealmName);
                            CreateFileUser.handleAdminGroup(CreateFileUser.this.authRealmName, CreateFileUser.this.groups);
                            String[] groups1 = CreateFileUser.this.groups.toArray(new String[CreateFileUser.this.groups.size()]);
                            try {
                                fr.addUser(CreateFileUser.this.userName, password.toCharArray(), groups1);
                            }
                            catch (BadRealmException br) {
                                if (CreateFileUser.this.se == null || !CreateFileUser.this.se.isDas()) break block4;
                                throw new BadRealmException(br);
                            }
                        }
                        fr.persist();
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    }
                    catch (Exception e) {
                        String localalizedErrorMsg = e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage();
                        report.setMessage(localStrings.getLocalString("create.file.user.useraddfailed", "Adding User {0} to the file realm {1} failed", new Object[]{CreateFileUser.this.userName, CreateFileUser.this.authRealmName}) + "  " + localalizedErrorMsg);
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)securityService);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.file.user.useraddfailed", "Adding User {0} to the file realm {1} failed", new Object[]{this.userName, this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    public static void refreshRealm(String configName, String realmName) {
        if (realmName != null && realmName.length() > 0) {
            try {
                Realm realm = Realm.getInstance(configName, realmName);
                if (realm != null) {
                    realm.refresh(configName);
                }
            }
            catch (NoSuchRealmException nre) {
            }
            catch (BadRealmException badRealmException) {
                // empty catch block
            }
        }
    }

    static void handleAdminGroup(String lr, List<String> lg) {
        String fr = "admin-realm";
        String fg = "asadmin";
        if (fr.equals(lr) && lg != null) {
            lg.clear();
            lg.add(fg);
        }
    }
}

