/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Payload;
import javax.validation.constraints.Pattern;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
@NotDuplicateTargetName(message="{node.duplicate.name}", payload={Node.class})
public interface Node
extends ConfigBeanProxy,
Injectable,
Named,
ReferenceContainer,
RefContainer,
Payload {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @NotTargetKeyword(message="{node.reserved.name}", payload={Node.class})
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{node.invalid.name}", payload={Node.class})
    public String getName();

    @Attribute
    public String getNodeDir();

    @Param(name="nodedir", optional=true)
    public void setNodeDir(String var1) throws PropertyVetoException;

    @Attribute
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\./;#]*", message="{nodehost.invalid.name}", payload={Node.class})
    public String getNodeHost();

    @Param(name="nodehost", optional=true)
    public void setNodeHost(String var1) throws PropertyVetoException;

    @Attribute
    public String getInstallDir();

    @Param(name="installdir", optional=true)
    public void setInstallDir(String var1) throws PropertyVetoException;

    @Attribute
    public String getType();

    @Param(name="type")
    public void setType(String var1) throws PropertyVetoException;

    @Attribute
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\./;#]*", message="{windowsdomain.invalid.name}", payload={Node.class})
    public String getWindowsDomain();

    @Param(name="windowsdomain", optional=true)
    public void setWindowsDomain(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getFreeze();

    public void setFreeze(String var1) throws PropertyVetoException;

    @Element
    public SshConnector getSshConnector();

    public void setSshConnector(SshConnector var1);

    @DuckTyped
    public String getInstallDirUnixStyle();

    @DuckTyped
    public String getNodeDirUnixStyle();

    @DuckTyped
    public String getNodeDirAbsolute();

    @DuckTyped
    public String getNodeDirAbsoluteUnixStyle();

    @DuckTyped
    public boolean nodeInUse();

    @DuckTyped
    public boolean isDefaultLocalNode();

    @DuckTyped
    public boolean isLocal();

    @DuckTyped
    public boolean instanceCreationAllowed();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Node> {
        @Param(name="nodedir", optional=true)
        String nodedir = null;
        @Param(name="nodehost", optional=true)
        String nodehost = null;
        @Param(name="installdir", optional=true)
        String installdir = null;
        @Param(name="type")
        String type = null;
        @Param(name="sshport", optional=true, alias="dcomport")
        String sshPort = null;
        @Param(name="sshnodehost", optional=true, alias="dcomnodehost")
        String sshHost = null;
        @Param(name="sshuser", optional=true, alias="dcomuser")
        String sshuser = null;
        @Param(name="sshkeyfile", optional=true)
        String sshkeyfile;
        @Param(name="sshpassword", optional=true, alias="dcompassword")
        String sshpassword;
        @Param(name="sshkeypassphrase", optional=true)
        String sshkeypassphrase;
        @Param(name="windowsdomain", optional=true)
        String windowsdomain;
        @Inject
        Habitat habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;
        @Inject
        Nodes nodes;

        @Override
        public void decorate(AdminCommandContext context, Node instance) throws TransactionFailure, PropertyVetoException {
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Node.class);
            if (!this.nodes.nodeCreationAllowed()) {
                throw new TransactionFailure(localStrings.getLocalString("nodeCreationNotAllowed", "Node creation is disabled. No new nodes may be created."));
            }
            if (!StringUtils.ok((String)this.nodedir)) {
                instance.setNodeDir(null);
            }
            if (!StringUtils.ok((String)this.installdir)) {
                instance.setInstallDir(null);
            }
            if (!StringUtils.ok((String)this.nodehost)) {
                instance.setNodeHost(null);
            }
            if (!StringUtils.ok((String)this.windowsdomain)) {
                instance.setWindowsDomain(null);
            }
            instance.setType(this.type);
            if (this.type.equals("CONFIG")) {
                return;
            }
            SshConnector sshC = (SshConnector)instance.createChild(SshConnector.class);
            SshAuth sshA = (SshAuth)sshC.createChild(SshAuth.class);
            if (StringUtils.ok((String)this.sshuser)) {
                sshA.setUserName(this.sshuser);
            }
            if (StringUtils.ok((String)this.sshkeyfile)) {
                sshA.setKeyfile(this.sshkeyfile);
            }
            if (StringUtils.ok((String)this.sshpassword)) {
                sshA.setPassword(this.sshpassword);
            }
            if (StringUtils.ok((String)this.sshkeypassphrase)) {
                sshA.setKeyPassphrase(this.sshkeypassphrase);
            }
            sshC.setSshAuth(sshA);
            if (StringUtils.ok((String)this.sshPort)) {
                sshC.setSshPort(this.sshPort);
            }
            if (StringUtils.ok((String)this.sshHost)) {
                sshC.setSshHost(this.sshHost);
            }
            if ("DCOM".equals(this.type)) {
                if (StringUtils.ok((String)this.windowsdomain)) {
                    instance.setWindowsDomain(this.windowsdomain);
                } else if (StringUtils.ok((String)this.nodehost)) {
                    instance.setWindowsDomain(this.nodehost);
                } else if (StringUtils.ok((String)this.sshHost)) {
                    instance.setWindowsDomain(this.sshHost);
                }
            }
            instance.setSshConnector(sshC);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<Nodes, Node> {
        @Inject
        private Domain domain;
        @Inject
        Nodes nodes;
        @Inject
        Servers servers;
        @Inject
        private ServerEnvironment env;

        @Override
        public void decorate(AdminCommandContext context, Nodes parent, Node child) throws PropertyVetoException, TransactionFailure {
            Logger logger = LogDomains.getLogger(Node.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Node.class);
            String nodeName = child.getName();
            if (nodeName.equals("localhost-" + this.domain.getName())) {
                String msg = localStrings.getLocalString("Node.localhost", "Cannot remove Node {0}. ", new Object[]{child.getName()});
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            List<Node> nodeList = this.nodes.getNode();
            List<Server> serversOnNode = this.servers.getServersOnNode(child);
            int n = 0;
            if (serversOnNode != null && serversOnNode.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (Server server : serversOnNode) {
                    if (n > 0) {
                        sb.append(", ");
                    }
                    sb.append(server.getName());
                    ++n;
                }
                String msg = localStrings.getLocalString("Node.referencedByInstance", "Node {0} referenced in server instance(s): {1}.  Remove instances before removing node.", new Object[]{child.getName(), sb.toString()});
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            nodeList.remove(child);
        }
    }

    public static class Duck {
        public static String getInstallDirUnixStyle(Node node) {
            String installDir = node.getInstallDir();
            if (installDir == null) {
                return null;
            }
            return installDir.replaceAll("\\\\", "/");
        }

        public static String getNodeDirUnixStyle(Node node) {
            String nodeDir = node.getNodeDir();
            if (nodeDir == null) {
                return null;
            }
            return nodeDir.replaceAll("\\\\", "/");
        }

        public static String getNodeDirAbsolute(Node node) {
            String nodeDir = node.getNodeDir();
            if (nodeDir == null || nodeDir.length() == 0) {
                return null;
            }
            File nodeDirFile = new File(nodeDir);
            if (nodeDirFile.isAbsolute()) {
                return nodeDir;
            }
            String installDir = node.getInstallDir();
            File installRootFile = new File(installDir, "glassfish");
            File absoluteNodeDirFile = new File(installRootFile, nodeDir);
            return absoluteNodeDirFile.getPath();
        }

        public static String getNodeDirAbsoluteUnixStyle(Node node) {
            String nodeDirAbsolute = Duck.getNodeDirAbsolute(node);
            if (nodeDirAbsolute == null) {
                return null;
            }
            return nodeDirAbsolute.replaceAll("\\\\", "/");
        }

        public static boolean isDefaultLocalNode(Node node) {
            Dom serverDom = Dom.unwrap((ConfigBeanProxy)node);
            Domain domain = (Domain)serverDom.getHabitat().getComponent(Domain.class);
            return node.getName().equals("localhost-" + domain.getName());
        }

        public static boolean isLocal(Node node) {
            Dom serverDom = Dom.unwrap((ConfigBeanProxy)node);
            Domain domain = (Domain)serverDom.getHabitat().getComponent(Domain.class);
            if (node.getName().equals("localhost-" + domain.getName())) {
                return true;
            }
            String nodeHost = node.getNodeHost();
            if (nodeHost == null || nodeHost.length() == 0) {
                return false;
            }
            return NetUtils.isThisHostLocal((String)nodeHost);
        }

        public static boolean nodeInUse(Node node) {
            String nodeName = node.getName();
            Dom serverDom = Dom.unwrap((ConfigBeanProxy)node);
            Servers servers = (Servers)serverDom.getHabitat().getComponent(Servers.class);
            List<Server> serverList = servers.getServer();
            if (serverList != null) {
                for (Server server : serverList) {
                    if (!nodeName.equals(server.getNodeRef())) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean instanceCreationAllowed(Node node) {
            return !Boolean.parseBoolean(node.getFreeze());
        }
    }
}

