/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JAnonymousClass;
import com.sun.codemodel.internal.JArrayClass;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JDeclaration;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDirectClass;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JNullType;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JPrimitiveType;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JTypeVar;
import com.sun.codemodel.internal.writer.FileCodeWriter;
import com.sun.codemodel.internal.writer.ProgressCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCodeModel {
    private HashMap<String, JPackage> packages = new HashMap();
    private final HashMap<Class, JReferencedClass> refClasses = new HashMap();
    public final JNullType NULL = new JNullType(this);
    public final JPrimitiveType VOID = new JPrimitiveType(this, "void", Void.class);
    public final JPrimitiveType BOOLEAN = new JPrimitiveType(this, "boolean", Boolean.class);
    public final JPrimitiveType BYTE = new JPrimitiveType(this, "byte", Byte.class);
    public final JPrimitiveType SHORT = new JPrimitiveType(this, "short", Short.class);
    public final JPrimitiveType CHAR = new JPrimitiveType(this, "char", Character.class);
    public final JPrimitiveType INT = new JPrimitiveType(this, "int", Integer.class);
    public final JPrimitiveType FLOAT = new JPrimitiveType(this, "float", Float.class);
    public final JPrimitiveType LONG = new JPrimitiveType(this, "long", Long.class);
    public final JPrimitiveType DOUBLE = new JPrimitiveType(this, "double", Double.class);
    protected static final boolean isCaseSensitiveFileSystem = JCodeModel.getFileSystemCaseSensitivity();
    private JClass wildcard;
    public static final Map<Class, Class> primitiveToBox;
    public static final Map<Class, Class> boxToPrimitive;

    private static boolean getFileSystemCaseSensitivity() {
        try {
            if (System.getProperty("com.sun.codemodel.internal.FileSystemCaseSensitive") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return File.separatorChar == '/';
    }

    public JPackage _package(String string) {
        JPackage jPackage = this.packages.get(string);
        if (jPackage == null) {
            jPackage = new JPackage(string, this);
            this.packages.put(string, jPackage);
        }
        return jPackage;
    }

    public final JPackage rootPackage() {
        return this._package("");
    }

    public Iterator<JPackage> packages() {
        return this.packages.values().iterator();
    }

    public JDefinedClass _class(String string) throws JClassAlreadyExistsException {
        return this._class(string, ClassType.CLASS);
    }

    public JClass directClass(String string) {
        return new JDirectClass(this, string);
    }

    public JDefinedClass _class(String string, ClassType classType) throws JClassAlreadyExistsException {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return this.rootPackage()._class(string);
        }
        return this._package(string.substring(0, n))._class(1, string.substring(n + 1), classType);
    }

    public JDefinedClass _getClass(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return this.rootPackage()._getClass(string);
        }
        return this._package(string.substring(0, n))._getClass(string.substring(n + 1));
    }

    public JDefinedClass newAnonymousClass(JClass jClass) {
        return new JAnonymousClass(jClass);
    }

    public JDefinedClass anonymousClass(JClass jClass) {
        return new JAnonymousClass(jClass);
    }

    public JDefinedClass anonymousClass(Class clazz) {
        return this.anonymousClass(this.ref(clazz));
    }

    public void build(File file, PrintStream printStream) throws IOException {
        this.build(file, file, printStream);
    }

    public void build(File file, File file2, PrintStream printStream) throws IOException {
        CodeWriter codeWriter = new FileCodeWriter(file);
        CodeWriter codeWriter2 = new FileCodeWriter(file2);
        if (printStream != null) {
            codeWriter = new ProgressCodeWriter(codeWriter, printStream);
            codeWriter2 = new ProgressCodeWriter(codeWriter2, printStream);
        }
        this.build(codeWriter, codeWriter2);
    }

    public void build(File file) throws IOException {
        this.build(file, System.out);
    }

    public void build(File file, File file2) throws IOException {
        this.build(file, file2, System.out);
    }

    public void build(CodeWriter codeWriter) throws IOException {
        this.build(codeWriter, codeWriter);
    }

    public void build(CodeWriter codeWriter, CodeWriter codeWriter2) throws IOException {
        JPackage[] jPackageArray;
        for (JPackage jPackage : jPackageArray = this.packages.values().toArray(new JPackage[this.packages.size()])) {
            jPackage.build(codeWriter, codeWriter2);
        }
        codeWriter.close();
        codeWriter2.close();
    }

    public int countArtifacts() {
        JPackage[] jPackageArray;
        int n = 0;
        for (JPackage jPackage : jPackageArray = this.packages.values().toArray(new JPackage[this.packages.size()])) {
            n += jPackage.countArtifacts();
        }
        return n;
    }

    public JClass ref(Class clazz) {
        JReferencedClass jReferencedClass = this.refClasses.get(clazz);
        if (jReferencedClass == null) {
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException(clazz + " is a primitive");
            }
            if (clazz.isArray()) {
                return new JArrayClass(this, this._ref(clazz.getComponentType()));
            }
            jReferencedClass = new JReferencedClass(clazz);
            this.refClasses.put(clazz, jReferencedClass);
        }
        return jReferencedClass;
    }

    public JType _ref(Class clazz) {
        if (clazz.isPrimitive()) {
            return JType.parse(this, clazz.getName());
        }
        return this.ref(clazz);
    }

    public JClass ref(String string) {
        try {
            return this.ref(Thread.currentThread().getContextClassLoader().loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return this.ref(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new JDirectClass(this, string);
            }
        }
    }

    public JClass wildcard() {
        if (this.wildcard == null) {
            this.wildcard = this.ref(Object.class).wildcard();
        }
        return this.wildcard;
    }

    public JType parseType(String string) throws ClassNotFoundException {
        if (string.endsWith("[]")) {
            return this.parseType(string.substring(0, string.length() - 2)).array();
        }
        try {
            return JType.parse(this, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new TypeNameParser(string).parseTypeName();
        }
    }

    static {
        HashMap<Class<Void>, Class<Object>> hashMap = new HashMap<Class<Void>, Class<Object>>();
        HashMap hashMap2 = new HashMap();
        hashMap.put(Boolean.class, Boolean.TYPE);
        hashMap.put(Byte.class, Byte.TYPE);
        hashMap.put(Character.class, Character.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Float.class, Float.TYPE);
        hashMap.put(Integer.class, Integer.TYPE);
        hashMap.put(Long.class, Long.TYPE);
        hashMap.put(Short.class, Short.TYPE);
        hashMap.put(Void.class, Void.TYPE);
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        boxToPrimitive = Collections.unmodifiableMap(hashMap);
        primitiveToBox = Collections.unmodifiableMap(hashMap2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JReferencedClass
    extends JClass
    implements JDeclaration {
        private final Class _class;

        JReferencedClass(Class clazz) {
            super(JCodeModel.this);
            this._class = clazz;
            assert (!this._class.isArray());
        }

        @Override
        public String name() {
            return this._class.getSimpleName().replace('$', '.');
        }

        @Override
        public String fullName() {
            return this._class.getName().replace('$', '.');
        }

        @Override
        public String binaryName() {
            return this._class.getName();
        }

        @Override
        public JClass outer() {
            Class<?> clazz = this._class.getDeclaringClass();
            if (clazz == null) {
                return null;
            }
            return JCodeModel.this.ref(clazz);
        }

        @Override
        public JPackage _package() {
            String string = this.fullName();
            if (string.indexOf(91) != -1) {
                return JCodeModel.this._package("");
            }
            int n = string.lastIndexOf(46);
            if (n < 0) {
                return JCodeModel.this._package("");
            }
            return JCodeModel.this._package(string.substring(0, n));
        }

        @Override
        public JClass _extends() {
            Class clazz = this._class.getSuperclass();
            if (clazz == null) {
                if (this.isInterface()) {
                    return this.owner().ref(Object.class);
                }
                return null;
            }
            return JCodeModel.this.ref(clazz);
        }

        @Override
        public Iterator<JClass> _implements() {
            final Class[] classArray = this._class.getInterfaces();
            return new Iterator<JClass>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < classArray.length;
                }

                @Override
                public JClass next() {
                    return JCodeModel.this.ref(classArray[this.idx++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean isInterface() {
            return this._class.isInterface();
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this._class.getModifiers());
        }

        @Override
        public JPrimitiveType getPrimitiveType() {
            Class clazz = boxToPrimitive.get(this._class);
            if (clazz != null) {
                return JType.parse(JCodeModel.this, clazz.getName());
            }
            return null;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public void declare(JFormatter jFormatter) {
        }

        @Override
        public JTypeVar[] typeParams() {
            return super.typeParams();
        }

        @Override
        protected JClass substituteParams(JTypeVar[] jTypeVarArray, List<JClass> list) {
            return this;
        }
    }

    private final class TypeNameParser {
        private final String s;
        private int idx;

        public TypeNameParser(String string) {
            this.s = string;
        }

        JClass parseTypeName() throws ClassNotFoundException {
            char c;
            int n = this.idx;
            if (this.s.charAt(this.idx) == '?') {
                ++this.idx;
                this.ws();
                String string = this.s.substring(this.idx);
                if (string.startsWith("extends")) {
                    this.idx += 7;
                    this.ws();
                    return this.parseTypeName().wildcard();
                }
                if (string.startsWith("super")) {
                    throw new UnsupportedOperationException("? super T not implemented");
                }
                throw new IllegalArgumentException("only extends/super can follow ?, but found " + this.s.substring(this.idx));
            }
            while (this.idx < this.s.length() && (Character.isJavaIdentifierStart(c = this.s.charAt(this.idx)) || Character.isJavaIdentifierPart(c) || c == '.')) {
                ++this.idx;
            }
            JClass jClass = JCodeModel.this.ref(this.s.substring(n, this.idx));
            return this.parseSuffix(jClass);
        }

        private JClass parseSuffix(JClass jClass) throws ClassNotFoundException {
            if (this.idx == this.s.length()) {
                return jClass;
            }
            char c = this.s.charAt(this.idx);
            if (c == '<') {
                return this.parseSuffix(this.parseArguments(jClass));
            }
            if (c == '[') {
                if (this.s.charAt(this.idx + 1) == ']') {
                    this.idx += 2;
                    return this.parseSuffix(jClass.array());
                }
                throw new IllegalArgumentException("Expected ']' but found " + this.s.substring(this.idx + 1));
            }
            return jClass;
        }

        private void ws() {
            while (Character.isWhitespace(this.s.charAt(this.idx)) && this.idx < this.s.length()) {
                ++this.idx;
            }
        }

        private JClass parseArguments(JClass jClass) throws ClassNotFoundException {
            if (this.s.charAt(this.idx) != '<') {
                throw new IllegalArgumentException();
            }
            ++this.idx;
            ArrayList<JClass> arrayList = new ArrayList<JClass>();
            while (true) {
                arrayList.add(this.parseTypeName());
                if (this.idx == this.s.length()) {
                    throw new IllegalArgumentException("Missing '>' in " + this.s);
                }
                char c = this.s.charAt(this.idx);
                if (c == '>') {
                    return jClass.narrow(arrayList.toArray(new JClass[arrayList.size()]));
                }
                if (c != ',') {
                    throw new IllegalArgumentException(this.s);
                }
                ++this.idx;
            }
        }
    }
}

