/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JAnnotationWriter;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JClassContainer;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDeclaration;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JEnumConstant;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JGenerifiable;
import com.sun.codemodel.internal.JGenerifiableImpl;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JMods;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JTypeVar;
import com.sun.codemodel.internal.TypedAnnotationWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDefinedClass
extends JClass
implements JDeclaration,
JClassContainer,
JGenerifiable,
JAnnotatable {
    private String name = null;
    private JMods mods;
    private JClass superClass;
    private final Set<JClass> interfaces = new TreeSet<JClass>();
    final Map<String, JFieldVar> fields = new LinkedHashMap<String, JFieldVar>();
    private JBlock init = null;
    private JDocComment jdoc = null;
    private final List<JMethod> constructors = new ArrayList<JMethod>();
    private final List<JMethod> methods = new ArrayList<JMethod>();
    private Map<String, JDefinedClass> classes;
    private boolean hideFile = false;
    public Object metadata;
    private String directBlock;
    private JClassContainer outer = null;
    private final ClassType classType;
    private final Map<String, JEnumConstant> enumConstantsByName = new LinkedHashMap<String, JEnumConstant>();
    private List<JAnnotationUse> annotations = null;
    private final JGenerifiableImpl generifiable = new JGenerifiableImpl(){

        protected JCodeModel owner() {
            return JDefinedClass.this.owner();
        }
    };

    JDefinedClass(JClassContainer jClassContainer, int n, String string, ClassType classType) {
        this(n, string, jClassContainer, jClassContainer.owner(), classType);
    }

    JDefinedClass(JCodeModel jCodeModel, int n, String string) {
        this(n, string, null, jCodeModel);
    }

    private JDefinedClass(int n, String string, JClassContainer jClassContainer, JCodeModel jCodeModel) {
        this(n, string, jClassContainer, jCodeModel, ClassType.CLASS);
    }

    private JDefinedClass(int n, String string, JClassContainer jClassContainer, JCodeModel jCodeModel, ClassType classType) {
        super(jCodeModel);
        if (string != null) {
            if (string.trim().length() == 0) {
                throw new IllegalArgumentException("JClass name empty");
            }
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                String string2 = "JClass name " + string + " contains illegal character" + " for beginning of identifier: " + string.charAt(0);
                throw new IllegalArgumentException(string2);
            }
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                String string3 = "JClass name " + string + " contains illegal character " + string.charAt(i);
                throw new IllegalArgumentException(string3);
            }
        }
        this.classType = classType;
        this.mods = this.isInterface() ? JMods.forInterface(n) : JMods.forClass(n);
        this.name = string;
        this.outer = jClassContainer;
    }

    public final boolean isAnonymous() {
        return this.name == null;
    }

    public JDefinedClass _extends(JClass jClass) {
        if (this.classType == ClassType.INTERFACE) {
            throw new IllegalArgumentException("unable to set the super class for an interface");
        }
        if (jClass == null) {
            throw new NullPointerException();
        }
        for (JClass jClass2 = jClass.outer(); jClass2 != null; jClass2 = jClass2.outer()) {
            if (this != jClass2) continue;
            throw new IllegalArgumentException("Illegal class inheritance loop.  Outer class " + this.name + " may not subclass from inner class: " + jClass2.name());
        }
        this.superClass = jClass;
        return this;
    }

    public JDefinedClass _extends(Class clazz) {
        return this._extends(this.owner().ref(clazz));
    }

    @Override
    public JClass _extends() {
        if (this.superClass == null) {
            this.superClass = this.owner().ref(Object.class);
        }
        return this.superClass;
    }

    public JDefinedClass _implements(JClass jClass) {
        this.interfaces.add(jClass);
        return this;
    }

    public JDefinedClass _implements(Class clazz) {
        return this._implements(this.owner().ref(clazz));
    }

    @Override
    public Iterator<JClass> _implements() {
        return this.interfaces.iterator();
    }

    @Override
    public String name() {
        return this.name;
    }

    public JEnumConstant enumConstant(String string) {
        JEnumConstant jEnumConstant = this.enumConstantsByName.get(string);
        if (null == jEnumConstant) {
            jEnumConstant = new JEnumConstant(this, string);
            this.enumConstantsByName.put(string, jEnumConstant);
        }
        return jEnumConstant;
    }

    @Override
    public String fullName() {
        if (this.outer instanceof JDefinedClass) {
            return ((JDefinedClass)this.outer).fullName() + '.' + this.name();
        }
        JPackage jPackage = this._package();
        if (jPackage.isUnnamed()) {
            return this.name();
        }
        return jPackage.name() + '.' + this.name();
    }

    @Override
    public String binaryName() {
        if (this.outer instanceof JDefinedClass) {
            return ((JDefinedClass)this.outer).binaryName() + '$' + this.name();
        }
        return this.fullName();
    }

    @Override
    public boolean isInterface() {
        return this.classType == ClassType.INTERFACE;
    }

    @Override
    public boolean isAbstract() {
        return this.mods.isAbstract();
    }

    public JFieldVar field(int n, JType jType, String string) {
        return this.field(n, jType, string, null);
    }

    public JFieldVar field(int n, Class clazz, String string) {
        return this.field(n, this.owner()._ref(clazz), string);
    }

    public JFieldVar field(int n, JType jType, String string, JExpression jExpression) {
        JFieldVar jFieldVar = new JFieldVar(this, JMods.forField(n), jType, string, jExpression);
        if (this.fields.put(string, jFieldVar) != null) {
            throw new IllegalArgumentException("trying to create the same field twice: " + string);
        }
        return jFieldVar;
    }

    public boolean isAnnotationTypeDeclaration() {
        return this.classType == ClassType.ANNOTATION_TYPE_DECL;
    }

    @Override
    public JDefinedClass _annotationTypeDeclaration(String string) throws JClassAlreadyExistsException {
        return this._class(1, string, ClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public JDefinedClass _enum(String string) throws JClassAlreadyExistsException {
        return this._class(1, string, ClassType.ENUM);
    }

    public JDefinedClass _enum(int n, String string) throws JClassAlreadyExistsException {
        return this._class(n, string, ClassType.ENUM);
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public JFieldVar field(int n, Class clazz, String string, JExpression jExpression) {
        return this.field(n, this.owner()._ref(clazz), string, jExpression);
    }

    public Map<String, JFieldVar> fields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void removeField(JFieldVar jFieldVar) {
        if (this.fields.remove(jFieldVar.name()) != jFieldVar) {
            throw new IllegalArgumentException();
        }
    }

    public JBlock init() {
        if (this.init == null) {
            this.init = new JBlock();
        }
        return this.init;
    }

    public JMethod constructor(int n) {
        JMethod jMethod = new JMethod(n, this);
        this.constructors.add(jMethod);
        return jMethod;
    }

    public Iterator constructors() {
        return this.constructors.iterator();
    }

    public JMethod getConstructor(JType[] jTypeArray) {
        for (JMethod jMethod : this.constructors) {
            if (!jMethod.hasSignature(jTypeArray)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethod method(int n, JType jType, String string) {
        JMethod jMethod = new JMethod(this, n, jType, string);
        this.methods.add(jMethod);
        return jMethod;
    }

    public JMethod method(int n, Class clazz, String string) {
        return this.method(n, this.owner()._ref(clazz), string);
    }

    public Collection<JMethod> methods() {
        return this.methods;
    }

    public JMethod getMethod(String string, JType[] jTypeArray) {
        for (JMethod jMethod : this.methods) {
            if (!jMethod.name().equals(string) || !jMethod.hasSignature(jTypeArray)) continue;
            return jMethod;
        }
        return null;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isPackage() {
        return false;
    }

    @Override
    public JPackage getPackage() {
        return this.parentContainer().getPackage();
    }

    @Override
    public JDefinedClass _class(int n, String string) throws JClassAlreadyExistsException {
        return this._class(n, string, ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int n, String string, boolean bl) throws JClassAlreadyExistsException {
        return this._class(n, string, bl ? ClassType.INTERFACE : ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int n, String string, ClassType classType) throws JClassAlreadyExistsException {
        String string2 = JCodeModel.isCaseSensitiveFileSystem ? string.toUpperCase() : string;
        if (this.getClasses().containsKey(string2)) {
            throw new JClassAlreadyExistsException(this.getClasses().get(string2));
        }
        JDefinedClass jDefinedClass = new JDefinedClass(this, n, string, classType);
        this.getClasses().put(string2, jDefinedClass);
        return jDefinedClass;
    }

    @Override
    public JDefinedClass _class(String string) throws JClassAlreadyExistsException {
        return this._class(1, string);
    }

    @Override
    public JDefinedClass _interface(int n, String string) throws JClassAlreadyExistsException {
        return this._class(n, string, ClassType.INTERFACE);
    }

    @Override
    public JDefinedClass _interface(String string) throws JClassAlreadyExistsException {
        return this._interface(1, string);
    }

    public JDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new JDocComment(this.owner());
        }
        return this.jdoc;
    }

    public void hide() {
        this.hideFile = true;
    }

    public boolean isHidden() {
        return this.hideFile;
    }

    @Override
    public final Iterator<JDefinedClass> classes() {
        if (this.classes == null) {
            return Collections.emptyList().iterator();
        }
        return this.classes.values().iterator();
    }

    private Map<String, JDefinedClass> getClasses() {
        if (this.classes == null) {
            this.classes = new TreeMap<String, JDefinedClass>();
        }
        return this.classes;
    }

    public final JClass[] listClasses() {
        if (this.classes == null) {
            return new JClass[0];
        }
        return this.classes.values().toArray(new JClass[this.classes.values().size()]);
    }

    @Override
    public JClass outer() {
        if (this.outer.isClass()) {
            return (JClass)((Object)this.outer);
        }
        return null;
    }

    @Override
    public void declare(JFormatter jFormatter) {
        if (this.jdoc != null) {
            jFormatter.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (JAnnotationUse jAnnotationUse : this.annotations) {
                jFormatter.g(jAnnotationUse).nl();
            }
        }
        jFormatter.g(this.mods).p(this.classType.declarationToken).id(this.name).d(this.generifiable);
        if (this.superClass != null && this.superClass != this.owner().ref(Object.class)) {
            jFormatter.nl().i().p("extends").g(this.superClass).nl().o();
        }
        if (!this.interfaces.isEmpty()) {
            if (this.superClass == null) {
                jFormatter.nl();
            }
            jFormatter.i().p(this.classType == ClassType.INTERFACE ? "extends" : "implements");
            jFormatter.g(this.interfaces);
            jFormatter.nl().o();
        }
        this.declareBody(jFormatter);
    }

    protected void declareBody(JFormatter jFormatter) {
        jFormatter.p('{').nl().nl().i();
        boolean bl = true;
        if (!this.enumConstantsByName.isEmpty()) {
            for (JEnumConstant jAnnotatable : this.enumConstantsByName.values()) {
                if (!bl) {
                    jFormatter.p(',').nl();
                }
                jFormatter.d(jAnnotatable);
                bl = false;
            }
            jFormatter.p(';').nl();
        }
        for (JFieldVar jFieldVar : this.fields.values()) {
            jFormatter.d(jFieldVar);
        }
        if (this.init != null) {
            jFormatter.nl().p("static").s(this.init);
        }
        for (JMethod jMethod : this.constructors) {
            jFormatter.nl().d(jMethod);
        }
        for (JMethod jMethod : this.methods) {
            jFormatter.nl().d(jMethod);
        }
        if (this.classes != null) {
            for (JDefinedClass jDefinedClass : this.classes.values()) {
                jFormatter.nl().d(jDefinedClass);
            }
        }
        if (this.directBlock != null) {
            jFormatter.p(this.directBlock);
        }
        jFormatter.nl().o().p('}').nl();
    }

    public void direct(String string) {
        this.directBlock = this.directBlock == null ? string : this.directBlock + string;
    }

    @Override
    public final JPackage _package() {
        JClassContainer jClassContainer = this.outer;
        while (!(jClassContainer instanceof JPackage)) {
            jClassContainer = jClassContainer.parentContainer();
        }
        return (JPackage)jClassContainer;
    }

    @Override
    public final JClassContainer parentContainer() {
        return this.outer;
    }

    @Override
    public JTypeVar generify(String string) {
        return this.generifiable.generify(string);
    }

    @Override
    public JTypeVar generify(String string, Class clazz) {
        return this.generifiable.generify(string, clazz);
    }

    @Override
    public JTypeVar generify(String string, JClass jClass) {
        return this.generifiable.generify(string, jClass);
    }

    @Override
    public JTypeVar[] typeParams() {
        return this.generifiable.typeParams();
    }

    @Override
    protected JClass substituteParams(JTypeVar[] jTypeVarArray, List<JClass> list) {
        return this;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    public JAnnotationUse annotate(JClass jClass) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(jClass);
        this.annotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }
}

