/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JJavaName {
    private static HashSet<String> reservedKeywords;
    private static final Entry[] TABLE;

    public static boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (reservedKeywords.contains(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullyQualifiedClassName(String string) {
        return JJavaName.isJavaPackageName(string);
    }

    public static boolean isJavaPackageName(String string) {
        while (string.length() != 0) {
            int n = string.indexOf(46);
            if (n == -1) {
                n = string.length();
            }
            if (!JJavaName.isJavaIdentifier(string.substring(0, n))) {
                return false;
            }
            if ((string = string.substring(n)).length() == 0) continue;
            string = string.substring(1);
        }
        return true;
    }

    public static String getPluralForm(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n >= 128) {
                return string;
            }
            bl &= !Character.isLowerCase((char)n);
        }
        for (Entry entry : TABLE) {
            String string2 = entry.apply(string);
            if (string2 == null) continue;
            if (bl) {
                string2 = string2.toUpperCase();
            }
            return string2;
        }
        return string;
    }

    static {
        String[] stringArray;
        reservedKeywords = new HashSet();
        for (String string : stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"}) {
            reservedKeywords.add(string);
        }
        stringArray = new String[]{"(.*)child", "$1children", "(.+)fe", "$1ves", "(.*)mouse", "$1mise", "(.+)f", "$1ves", "(.+)ch", "$1ches", "(.+)sh", "$1shes", "(.*)tooth", "$1teeth", "(.+)um", "$1a", "(.+)an", "$1en", "(.+)ato", "$1atoes", "(.*)basis", "$1bases", "(.*)axis", "$1axes", "(.+)is", "$1ises", "(.+)ss", "$1sses", "(.+)us", "$1uses", "(.+)s", "$1s", "(.*)foot", "$1feet", "(.+)ix", "$1ixes", "(.+)ex", "$1ices", "(.+)nx", "$1nxes", "(.+)x", "$1xes", "(.+)y", "$1ies", "(.+)", "$1s"};
        TABLE = new Entry[stringArray.length / 2];
        for (int i = 0; i < stringArray.length; i += 2) {
            JJavaName.TABLE[i / 2] = new Entry(stringArray[i], stringArray[i + 1]);
        }
    }

    private static class Entry {
        private final Pattern pattern;
        private final String replacement;

        public Entry(String string, String string2) {
            this.pattern = Pattern.compile(string, 2);
            this.replacement = string2;
        }

        String apply(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                StringBuffer stringBuffer = new StringBuffer();
                matcher.appendReplacement(stringBuffer, this.replacement);
                return stringBuffer.toString();
            }
            return null;
        }
    }
}

