/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal.fmt;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JResourceFile;
import com.sun.codemodel.internal.JTypeVar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;

public final class JStaticJavaFile
extends JResourceFile {
    private final JPackage pkg;
    private final String className;
    private final URL source;
    private final JStaticClass clazz;
    private final LineFilter filter;

    public JStaticJavaFile(JPackage jPackage, String string, String string2) {
        this(jPackage, string, JStaticJavaFile.class.getClassLoader().getResource(string2), null);
    }

    public JStaticJavaFile(JPackage jPackage, String string, URL uRL, LineFilter lineFilter) {
        super(string + ".java");
        if (uRL == null) {
            throw new NullPointerException();
        }
        this.pkg = jPackage;
        this.clazz = new JStaticClass();
        this.className = string;
        this.source = uRL;
        this.filter = lineFilter;
    }

    public final JClass getJClass() {
        return this.clazz;
    }

    protected boolean isResource() {
        return false;
    }

    protected void build(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.source.openStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        LineFilter lineFilter = this.createLineFilter();
        int n = 1;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = lineFilter.process(string)) != null) {
                    printWriter.println(string);
                }
                ++n;
            }
        }
        catch (ParseException parseException) {
            throw new IOException("unable to process " + this.source + " line:" + n + "\n" + parseException.getMessage());
        }
        printWriter.close();
        bufferedReader.close();
    }

    private LineFilter createLineFilter() {
        LineFilter lineFilter = new LineFilter(){

            public String process(String string) {
                if (!string.startsWith("package ")) {
                    return string;
                }
                if (JStaticJavaFile.this.pkg.isUnnamed()) {
                    return null;
                }
                return "package " + JStaticJavaFile.this.pkg.name() + ";";
            }
        };
        if (this.filter != null) {
            return new ChainFilter(this.filter, lineFilter);
        }
        return lineFilter;
    }

    public static final class ChainFilter
    implements LineFilter {
        private final LineFilter first;
        private final LineFilter second;

        public ChainFilter(LineFilter lineFilter, LineFilter lineFilter2) {
            this.first = lineFilter;
            this.second = lineFilter2;
        }

        public String process(String string) throws ParseException {
            if ((string = this.first.process(string)) == null) {
                return null;
            }
            return this.second.process(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JStaticClass
    extends JClass {
        private final JTypeVar[] typeParams;

        JStaticClass() {
            super(JStaticJavaFile.this.pkg.owner());
            this.typeParams = new JTypeVar[0];
        }

        @Override
        public String name() {
            return JStaticJavaFile.this.className;
        }

        @Override
        public String fullName() {
            if (JStaticJavaFile.this.pkg.isUnnamed()) {
                return JStaticJavaFile.this.className;
            }
            return JStaticJavaFile.this.pkg.name() + '.' + JStaticJavaFile.this.className;
        }

        @Override
        public JPackage _package() {
            return JStaticJavaFile.this.pkg;
        }

        @Override
        public JClass _extends() {
            throw new UnsupportedOperationException();
        }

        public Iterator _implements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInterface() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAbstract() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JTypeVar[] typeParams() {
            return this.typeParams;
        }

        @Override
        protected JClass substituteParams(JTypeVar[] jTypeVarArray, List<JClass> list) {
            return this;
        }
    }

    public static interface LineFilter {
        public String process(String var1) throws ParseException;
    }
}

