/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.internal.jxc.apt.ErrorReceiverImpl;
import com.sun.tools.internal.xjc.api.J2SJAXBModel;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.tools.internal.xjc.api.XJC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator
implements AnnotationProcessorFactory {
    private final Map<String, File> schemaLocations = new HashMap<String, File>();
    private File episodeFile;

    public SchemaGenerator() {
    }

    public SchemaGenerator(Map<String, File> map) {
        this.schemaLocations.putAll(map);
    }

    public void setEpisodeFile(File file) {
        this.episodeFile = file;
    }

    @Override
    public Collection<String> supportedOptions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> supportedAnnotationTypes() {
        return Arrays.asList("*");
    }

    @Override
    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, final AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        return new AnnotationProcessor(){
            final ErrorReceiverImpl errorListener;
            {
                this.errorListener = new ErrorReceiverImpl(annotationProcessorEnvironment);
            }

            public void process() {
                ArrayList<Reference> arrayList = new ArrayList<Reference>();
                for (TypeDeclaration typeDeclaration : annotationProcessorEnvironment.getTypeDeclarations()) {
                    if (!(typeDeclaration instanceof ClassDeclaration)) continue;
                    arrayList.add(new Reference(typeDeclaration, annotationProcessorEnvironment));
                }
                J2SJAXBModel j2SJAXBModel = XJC.createJavaCompiler().bind(arrayList, Collections.<QName, Reference>emptyMap(), null, annotationProcessorEnvironment);
                if (j2SJAXBModel == null) {
                    return;
                }
                try {
                    j2SJAXBModel.generateSchema(new SchemaOutputResolver(){

                        public Result createOutput(String string, String string2) throws IOException {
                            OutputStream outputStream;
                            File file;
                            if (SchemaGenerator.this.schemaLocations.containsKey(string)) {
                                file = (File)SchemaGenerator.this.schemaLocations.get(string);
                                if (file == null) {
                                    return null;
                                }
                                outputStream = new FileOutputStream(file);
                            } else {
                                file = new File(string2);
                                outputStream = annotationProcessorEnvironment.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, "", file);
                                file = file.getAbsoluteFile();
                            }
                            StreamResult streamResult = new StreamResult(outputStream);
                            annotationProcessorEnvironment.getMessager().printNotice("Writing " + file);
                            streamResult.setSystemId(file.toURL().toExternalForm());
                            return streamResult;
                        }
                    }, this.errorListener);
                    if (SchemaGenerator.this.episodeFile != null) {
                        annotationProcessorEnvironment.getMessager().printNotice("Writing " + SchemaGenerator.this.episodeFile);
                        j2SJAXBModel.generateEpisodeFile(new StreamResult(SchemaGenerator.this.episodeFile));
                    }
                }
                catch (IOException iOException) {
                    this.errorListener.error(iOException.getMessage(), iOException);
                }
            }
        };
    }
}

