/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws;

import com.sun.istack.internal.tools.MaskingClassLoader;
import com.sun.istack.internal.tools.ParallelWorldClassLoader;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.xjc.api.util.ToolsJarNotFoundException;
import com.sun.xml.internal.bind.util.Which;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Invoker {
    public static String[] maskedPackages = new String[]{"com.sun.istack.internal.tools.", "com.sun.tools.internal.jxc.", "com.sun.tools.internal.xjc.", "com.sun.tools.internal.ws.", "com.sun.codemodel.internal.", "com.sun.relaxng.", "com.sun.xml.internal.xsom.", "com.sun.xml.internal.bind.", "com.sun.xml.internal.ws."};
    public static boolean noSystemProxies = false;

    static int invoke(String string, String[] stringArray) throws Throwable {
        if (!noSystemProxies) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object;
            Serializable serializable;
            ClassLoader classLoader2 = Invoker.class.getClassLoader();
            if (Arrays.asList(stringArray).contains("-Xendorsed")) {
                classLoader2 = Invoker.createClassLoader(classLoader2);
            } else {
                if (!Invoker.checkIfLoading21API()) {
                    if (Service.class.getClassLoader() == null) {
                        System.err.println(WscompileMessages.INVOKER_NEED_ENDORSED());
                    } else {
                        System.err.println(WscompileMessages.WRAPPER_TASK_LOADING_20_API(Which.which(Service.class)));
                    }
                    int n = -1;
                    return n;
                }
                serializable = new ArrayList<URL>();
                Invoker.findToolsJar(classLoader2, serializable);
                if (serializable.size() > 0) {
                    object = new ArrayList<String>(Arrays.asList(maskedPackages));
                    classLoader2 = new MaskingClassLoader(classLoader2, (Collection<String>)object);
                    classLoader2 = new URLClassLoader(serializable.toArray(new URL[serializable.size()]), classLoader2);
                    classLoader2 = new ParallelWorldClassLoader(classLoader2, "");
                }
            }
            Thread.currentThread().setContextClassLoader(classLoader2);
            serializable = classLoader2.loadClass(string);
            object = ((Class)serializable).getConstructor(OutputStream.class);
            Object t = ((Constructor)object).newInstance(System.out);
            Method method = ((Class)serializable).getMethod("run", String[].class);
            boolean bl = (Boolean)method.invoke(t, new Object[]{stringArray});
            int n = bl ? 0 : 1;
            return n;
        }
        catch (ToolsJarNotFoundException toolsJarNotFoundException) {
            System.err.println(toolsJarNotFoundException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return -1;
    }

    public static boolean checkIfLoading21API() {
        try {
            Service.class.getMethod("getPort", Class.class, WebServiceFeature[].class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public static ClassLoader createClassLoader(ClassLoader classLoader) throws ClassNotFoundException, MalformedURLException, ToolsJarNotFoundException {
        URL[] uRLArray = Invoker.findIstackAPIs(classLoader);
        if (uRLArray.length == 0) {
            return classLoader;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(maskedPackages));
        if (uRLArray.length > 1) {
            arrayList.add("javax.xml.bind.");
            arrayList.add("javax.xml.ws.");
        }
        classLoader = new MaskingClassLoader(classLoader, arrayList);
        classLoader = new URLClassLoader(uRLArray, classLoader);
        classLoader = new ParallelWorldClassLoader(classLoader, "");
        return classLoader;
    }

    private static URL[] findIstackAPIs(ClassLoader classLoader) throws ClassNotFoundException, MalformedURLException, ToolsJarNotFoundException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (Service.class.getClassLoader() == null) {
            URL uRL = classLoader.getResource("javax/xml/ws/EndpointReference.class");
            if (uRL == null) {
                throw new ClassNotFoundException("There's no JAX-WS 2.1 API in the classpath");
            }
            arrayList.add(ParallelWorldClassLoader.toJarUrl(uRL));
            uRL = classLoader.getResource("javax/xml/bind/annotation/XmlSeeAlso.class");
            if (uRL == null) {
                throw new ClassNotFoundException("There's no JAXB 2.1 API in the classpath");
            }
            arrayList.add(ParallelWorldClassLoader.toJarUrl(uRL));
        }
        Invoker.findToolsJar(classLoader, arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static void findToolsJar(ClassLoader classLoader, List<URL> list) throws ToolsJarNotFoundException, MalformedURLException {
        try {
            Class.forName("com.sun.tools.javac.Main", false, classLoader);
            Class.forName("com.sun.tools.apt.Main", false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file = new File(System.getProperty("java.home"));
            File file2 = new File(file.getParent(), "lib/tools.jar");
            if (!file2.exists()) {
                throw new ToolsJarNotFoundException(file2);
            }
            list.add(file2.toURL());
        }
    }

    static {
        try {
            noSystemProxies = Boolean.getBoolean(Invoker.class.getName() + ".noSystemProxies");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

