/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JCatchBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCommentPart;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JTryBlock;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.tools.internal.ws.processor.generator.GeneratorBase;
import com.sun.tools.internal.ws.processor.generator.GeneratorUtil;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.resources.GeneratorMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import org.xml.sax.Locator;

public class ServiceGenerator
extends GeneratorBase {
    public static void generate(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        ServiceGenerator serviceGenerator = new ServiceGenerator(model, wsimportOptions, errorReceiver);
        serviceGenerator.doGeneration();
    }

    private ServiceGenerator(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        super(model, wsimportOptions, errorReceiver);
    }

    public void visit(Service service) {
        JDefinedClass jDefinedClass;
        JavaInterface javaInterface = service.getJavaInterface();
        String string = Names.customJavaTypeClassName(javaInterface);
        if (this.donotOverride && GeneratorUtil.classExists(this.options, string)) {
            this.log("Class " + string + " exists. Not overriding.");
            return;
        }
        try {
            jDefinedClass = this.getClass(string, ClassType.CLASS);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            this.receiver.error(service.getLocator(), GeneratorMessages.GENERATOR_SERVICE_CLASS_ALREADY_EXIST(string, service.getName()));
            return;
        }
        jDefinedClass._extends(javax.xml.ws.Service.class);
        String string2 = JAXBRIContext.mangleNameToClassName((String)service.getName().getLocalPart()).toUpperCase();
        String string3 = string2 + "_WSDL_LOCATION";
        JFieldVar jFieldVar = jDefinedClass.field(28, URL.class, string3);
        jDefinedClass.field(28, Logger.class, "logger", (JExpression)this.cm.ref(Logger.class).staticInvoke("getLogger").arg(JExpr.dotclass(this.cm.ref(string)).invoke("getName")));
        JClass jClass = this.cm.ref(QName.class);
        JInvocation jInvocation = JExpr._new(jClass);
        jInvocation.arg("namespace");
        jInvocation.arg("localpart");
        JBlock jBlock = jDefinedClass.init();
        JVar jVar = jBlock.decl(this.cm.ref(URL.class), "url", JExpr._null());
        JTryBlock jTryBlock = jBlock._try();
        JVar jVar2 = jTryBlock.body().decl(this.cm.ref(URL.class), "baseUrl");
        jTryBlock.body().assign(jVar2, JExpr.dotclass(this.cm.ref(string)).invoke("getResource").arg("."));
        jTryBlock.body().assign(jVar, JExpr._new(this.cm.ref(URL.class)).arg(jVar2).arg(this.wsdlLocation));
        JCatchBlock jCatchBlock = jTryBlock._catch(this.cm.ref(MalformedURLException.class));
        jCatchBlock.param("e");
        jCatchBlock.body().directStatement("logger.warning(\"Failed to create URL for the wsdl Location: " + JExpr.quotify('\'', this.wsdlLocation) + ", retrying as a local file\");");
        jCatchBlock.body().directStatement("logger.warning(e.getMessage());");
        jBlock.assign(jFieldVar, jVar);
        JMethod jMethod = jDefinedClass.constructor(1);
        jMethod.param(URL.class, "wsdlLocation");
        jMethod.param(QName.class, "serviceName");
        jMethod.body().directStatement("super(wsdlLocation, serviceName);");
        jMethod = jDefinedClass.constructor(1);
        jMethod.body().directStatement("super(" + string3 + ", new QName(\"" + service.getName().getNamespaceURI() + "\", \"" + service.getName().getLocalPart() + "\"));");
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(WebServiceClient.class));
        this.writeWebServiceClientAnnotation(service, jAnnotationUse);
        this.writeHandlerConfig(Names.customJavaTypeClassName(service.getJavaInterface()), jDefinedClass, this.options);
        for (Port port : service.getPorts()) {
            JDefinedClass jDefinedClass2;
            if (port.isProvider()) continue;
            try {
                jDefinedClass2 = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
            }
            catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
                PortType portType;
                QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortTypeName");
                Locator locator = null;
                if (qName != null && (portType = port.portTypes.get(qName)) != null) {
                    locator = portType.getLocator();
                }
                this.receiver.error(locator, GeneratorMessages.GENERATOR_SEI_CLASS_ALREADY_EXIST(port.getJavaInterface().getName(), qName));
                return;
            }
            this.writeDefaultGetPort(port, jDefinedClass2, jDefinedClass);
            if (!this.options.target.isLaterThan(Options.Target.V2_1)) continue;
            this.writeGetPort(port, jDefinedClass2, jDefinedClass);
        }
    }

    private void writeGetPort(Port port, JType jType, JDefinedClass jDefinedClass) {
        JMethod jMethod = jDefinedClass.method(1, jType, port.getPortGetter());
        JDocComment jDocComment = jMethod.javadoc();
        if (port.getJavaDoc() != null) {
            jDocComment.add(port.getJavaDoc());
        }
        JCommentPart jCommentPart = jDocComment.addReturn();
        JCommentPart jCommentPart2 = jDocComment.addParam("features");
        jCommentPart2.append("A list of ");
        jCommentPart2.append("{@link " + WebServiceFeature.class.getName() + "}");
        jCommentPart2.append("to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.");
        jCommentPart.add("returns " + jType.name());
        jMethod.varParam(WebServiceFeature.class, "features");
        JBlock jBlock = jMethod.body();
        StringBuffer stringBuffer = new StringBuffer("return ");
        stringBuffer.append("super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        stringBuffer.append(jType.name());
        stringBuffer.append(".class, features);");
        jBlock.directStatement(stringBuffer.toString());
        this.writeWebEndpoint(port, jMethod);
    }

    private void writeDefaultGetPort(Port port, JType jType, JDefinedClass jDefinedClass) {
        String string = port.getPortGetter();
        JMethod jMethod = jDefinedClass.method(1, jType, string);
        JDocComment jDocComment = jMethod.javadoc();
        if (port.getJavaDoc() != null) {
            jDocComment.add(port.getJavaDoc());
        }
        JCommentPart jCommentPart = jDocComment.addReturn();
        jCommentPart.add("returns " + jType.name());
        JBlock jBlock = jMethod.body();
        StringBuffer stringBuffer = new StringBuffer("return ");
        stringBuffer.append("super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        stringBuffer.append(jType.name());
        stringBuffer.append(".class);");
        jBlock.directStatement(stringBuffer.toString());
        this.writeWebEndpoint(port, jMethod);
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse jAnnotationUse) {
        String string = service.getName().getLocalPart();
        String string2 = service.getName().getNamespaceURI();
        jAnnotationUse.param("name", string);
        jAnnotationUse.param("targetNamespace", string2);
        jAnnotationUse.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod jMethod) {
        JAnnotationUse jAnnotationUse = jMethod.annotate(this.cm.ref(WebEndpoint.class));
        jAnnotationUse.param("name", port.getName().getLocalPart());
    }
}

