/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model.java;

import com.sun.tools.internal.ws.processor.model.Parameter;
import com.sun.tools.internal.ws.processor.model.java.JavaParameter;
import com.sun.tools.internal.ws.processor.model.java.JavaType;
import com.sun.tools.internal.ws.resources.ModelMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod {
    private final ErrorReceiver errorReceiver;
    private final String name;
    private final List<JavaParameter> parameters = new ArrayList<JavaParameter>();
    private final List<String> exceptions = new ArrayList<String>();
    private final WsimportOptions options;
    private JavaType returnType;

    public JavaMethod(String string, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        this.name = string;
        this.returnType = null;
        this.errorReceiver = errorReceiver;
        this.options = wsimportOptions;
    }

    public String getName() {
        return this.name;
    }

    public JavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(JavaType javaType) {
        this.returnType = javaType;
    }

    private boolean hasParameter(String string) {
        for (JavaParameter javaParameter : this.parameters) {
            if (!string.equals(javaParameter.getName())) continue;
            return true;
        }
        return false;
    }

    private Parameter getParameter(String string) {
        for (JavaParameter javaParameter : this.parameters) {
            if (!string.equals(javaParameter.getName())) continue;
            return javaParameter.getParameter();
        }
        return null;
    }

    public void addParameter(JavaParameter javaParameter) {
        if (this.hasParameter(javaParameter.getName())) {
            if (this.options.isExtensionMode()) {
                javaParameter.setName(this.getUniqueName(javaParameter.getName()));
            } else {
                Parameter parameter = this.getParameter(javaParameter.getName());
                if (javaParameter.getParameter().isEmbedded()) {
                    this.errorReceiver.error(javaParameter.getParameter().getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE_WRAPPER(javaParameter.getName(), javaParameter.getParameter().getEntityName()));
                    this.errorReceiver.error(parameter.getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE_WRAPPER(javaParameter.getName(), parameter.getEntityName()));
                } else {
                    this.errorReceiver.error(javaParameter.getParameter().getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE(javaParameter.getName(), javaParameter.getParameter().getEntityName()));
                    this.errorReceiver.error(parameter.getLocator(), ModelMessages.MODEL_PARAMETER_NOTUNIQUE(javaParameter.getName(), parameter.getEntityName()));
                }
                return;
            }
        }
        this.parameters.add(javaParameter);
    }

    public List<JavaParameter> getParametersList() {
        return this.parameters;
    }

    public void addException(String string) {
        if (!this.exceptions.contains(string)) {
            this.exceptions.add(string);
        }
    }

    public Iterator<String> getExceptions() {
        return this.exceptions.iterator();
    }

    private String getUniqueName(String string) {
        int n = 0;
        while (this.hasParameter(string)) {
            string = string + Integer.toString(n++);
        }
        return string;
    }
}

