/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.internal.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.internal.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPUse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorContext {
    private Map<String, SEIContext> seiContextMap = new HashMap<String, SEIContext>();
    private int round = 1;
    private boolean modelCompleted = false;

    public void addSEIContext(String string, SEIContext sEIContext) {
        this.seiContextMap.put(string, sEIContext);
    }

    public SEIContext getSEIContext(String string) {
        SEIContext sEIContext = this.seiContextMap.get(string);
        if (sEIContext == null) {
            sEIContext = new SEIContext(string);
            this.addSEIContext(string, sEIContext);
        }
        return sEIContext;
    }

    public SEIContext getSEIContext(TypeDeclaration typeDeclaration) {
        SEIContext sEIContext = this.getSEIContext(typeDeclaration.getQualifiedName());
        return sEIContext;
    }

    public Collection<SEIContext> getSEIContexts() {
        return this.seiContextMap.values();
    }

    public int getRound() {
        return this.round;
    }

    public void incrementRound() {
        ++this.round;
    }

    public static boolean isEncoded(Model model) {
        if (model == null) {
            return false;
        }
        for (Service service : model.getServices()) {
            for (Port port : service.getPorts()) {
                for (Operation operation : port.getOperations()) {
                    if (operation.getUse() == null || !operation.getUse().equals(SOAPUse.LITERAL)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setModelCompleted(boolean bl) {
        this.modelCompleted = bl;
    }

    public boolean isModelCompleted() {
        return this.modelCompleted;
    }

    public static class SEIContext {
        private Map<String, WrapperInfo> reqOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, WrapperInfo> resOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, FaultInfo> exceptionBeanMap = new HashMap<String, FaultInfo>();
        private String seiName;
        private String seiImplName;
        private boolean implementsSEI = false;
        private String namespaceURI = null;

        public SEIContext(String string) {
            this.seiName = string;
        }

        public void setImplementsSEI(boolean bl) {
            this.implementsSEI = bl;
        }

        public boolean getImplementsSEI() {
            return this.implementsSEI;
        }

        public void setNamespaceURI(String string) {
            this.namespaceURI = string;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getSEIImplName() {
            return this.seiImplName;
        }

        public void setSEIImplName(String string) {
            this.seiImplName = string;
        }

        public void setReqWrapperOperation(MethodDeclaration methodDeclaration, WrapperInfo wrapperInfo) {
            this.reqOperationWrapperMap.put(this.methodToString(methodDeclaration), wrapperInfo);
        }

        public WrapperInfo getReqOperationWrapper(MethodDeclaration methodDeclaration) {
            return this.reqOperationWrapperMap.get(this.methodToString(methodDeclaration));
        }

        public void setResWrapperOperation(MethodDeclaration methodDeclaration, WrapperInfo wrapperInfo) {
            this.resOperationWrapperMap.put(this.methodToString(methodDeclaration), wrapperInfo);
        }

        public WrapperInfo getResOperationWrapper(MethodDeclaration methodDeclaration) {
            return this.resOperationWrapperMap.get(this.methodToString(methodDeclaration));
        }

        public String methodToString(MethodDeclaration methodDeclaration) {
            StringBuffer stringBuffer = new StringBuffer(methodDeclaration.getSimpleName());
            for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
                stringBuffer.append(";" + ((Object)parameterDeclaration.getType()).toString());
            }
            return stringBuffer.toString();
        }

        public void clearExceptionMap() {
            this.exceptionBeanMap.clear();
        }

        public void addExceptionBeanEntry(String string, FaultInfo faultInfo, ModelBuilder modelBuilder) {
            this.exceptionBeanMap.put(string, faultInfo);
        }

        public FaultInfo getExceptionBeanName(String string) {
            return this.exceptionBeanMap.get(string);
        }
    }
}

