/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.wsdl;

import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.java.JavaSimpleType;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBMapping;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBModel;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ClassNameAllocatorImpl;
import com.sun.tools.internal.ws.processor.util.ClassNameCollector;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.parser.DOMForestScanner;
import com.sun.tools.internal.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.internal.xjc.api.S2JJAXBModel;
import com.sun.tools.internal.xjc.api.SchemaCompiler;
import com.sun.tools.internal.xjc.api.TypeAndAnnotation;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.LocatorImpl;

public class JAXBModelBuilder {
    private final ErrorReceiver errReceiver;
    private final WsimportOptions options;
    private final MetadataFinder forest;
    private JAXBModel jaxbModel;
    private SchemaCompiler schemaCompiler;
    private final ClassNameAllocatorImpl _classNameAllocator;
    protected static final LocatorImpl NULL_LOCATOR = new LocatorImpl();

    public JAXBModelBuilder(WsimportOptions wsimportOptions, ClassNameCollector classNameCollector, MetadataFinder metadataFinder, ErrorReceiver errorReceiver) {
        this._classNameAllocator = new ClassNameAllocatorImpl(classNameCollector);
        this.errReceiver = errorReceiver;
        this.options = wsimportOptions;
        this.forest = metadataFinder;
        this.internalBuildJAXBModel();
    }

    private void internalBuildJAXBModel() {
        try {
            this.schemaCompiler = this.options.getSchemaCompiler();
            this.schemaCompiler.resetSchema();
            this.schemaCompiler.setEntityResolver(this.options.entityResolver);
            this.schemaCompiler.setClassNameAllocator(this._classNameAllocator);
            this.schemaCompiler.setErrorListener(this.errReceiver);
            int n = 1;
            for (Element inputSourceArray : this.forest.getInlinedSchemaElement()) {
                String string = inputSourceArray.getOwnerDocument().getDocumentURI();
                String string2 = string + "#types?schema" + n++;
                if (this.forest.isMexMetadata) {
                    this.schemaCompiler.parseSchema(string2, inputSourceArray);
                    continue;
                }
                new DOMForestScanner(this.forest).scan(inputSourceArray, this.schemaCompiler.getParserHandler(string2));
            }
            InputSource[] inputSourceArray = this.options.getSchemaBindings();
            if (inputSourceArray != null) {
                for (InputSource inputSource : inputSourceArray) {
                    this.schemaCompiler.parseSchema(inputSource);
                }
            }
        }
        catch (Exception exception) {
            throw new ModelException(exception);
        }
    }

    public JAXBType getJAXBType(QName qName) {
        JAXBMapping jAXBMapping = this.jaxbModel.get(qName);
        if (jAXBMapping == null) {
            return null;
        }
        JavaSimpleType javaSimpleType = new JavaSimpleType(jAXBMapping.getType());
        return new JAXBType(qName, javaSimpleType, jAXBMapping, this.jaxbModel);
    }

    public TypeAndAnnotation getElementTypeAndAnn(QName qName) {
        JAXBMapping jAXBMapping = this.jaxbModel.get(qName);
        if (jAXBMapping == null) {
            return null;
        }
        return jAXBMapping.getType().getTypeAnn();
    }

    protected void bind() {
        S2JJAXBModel s2JJAXBModel = this.schemaCompiler.bind();
        if (s2JJAXBModel == null) {
            throw new AbortException();
        }
        this.options.setCodeModel(s2JJAXBModel.generateCode(null, this.errReceiver));
        this.jaxbModel = new JAXBModel(s2JJAXBModel);
        this.jaxbModel.setGeneratedClassNames(this._classNameAllocator.getJaxbGeneratedClasses());
    }

    protected SchemaCompiler getJAXBSchemaCompiler() {
        return this.schemaCompiler;
    }

    public JAXBModel getJAXBModel() {
        return this.jaxbModel;
    }
}

