/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.wsdl;

import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.internal.ws.processor.modeler.wsdl.WSDLModelerBase;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.document.Binding;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.Message;
import com.sun.tools.internal.ws.wsdl.document.MessagePart;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocument;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBinding;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAP12Binding;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPBinding;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoSchemaBuilder {
    private final StringWriter buf = new StringWriter();
    private final WSDLDocument wsdlDocument;
    private WSDLModeler wsdlModeler;
    private final List<InputSource> schemas = new ArrayList<InputSource>();
    private final HashMap<QName, Port> bindingNameToPortMap = new HashMap();
    private static final String w3ceprSchemaBinding = "<bindings\n  xmlns=\"http://java.sun.com/xml/ns/jaxb\"\n  xmlns:wsa=\"http://www.w3.org/2005/08/addressing\"\n  version=\"2.1\">\n  \n  <bindings scd=\"x-schema::wsa\" if-exists=\"true\">\n    <schemaBindings map=\"false\" />\n    <bindings scd=\"wsa:EndpointReference\">\n      <class ref=\"javax.xml.ws.wsaddressing.W3CEndpointReference\"/>\n    </bindings>\n    <bindings scd=\"~wsa:EndpointReferenceType\">\n      <class ref=\"javax.xml.ws.wsaddressing.W3CEndpointReference\"/>\n    </bindings>\n  </bindings>\n</bindings>";
    private static final String memberSubmissionEPR = "<bindings\n  xmlns=\"http://java.sun.com/xml/ns/jaxb\"\n  xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"\n  version=\"2.1\">\n  \n  <bindings scd=\"x-schema::wsa\" if-exists=\"true\">\n    <schemaBindings map=\"false\" />\n    <bindings scd=\"wsa:EndpointReference\">\n      <class ref=\"com.sun.xml.internal.ws.developer.MemberSubmissionEndpointReference\"/>\n    </bindings>\n    <bindings scd=\"~wsa:EndpointReferenceType\">\n      <class ref=\"com.sun.xml.internal.ws.developer.MemberSubmissionEndpointReference\"/>\n    </bindings>\n  </bindings>\n</bindings>";
    private static final String sysId = "http://dummy.pseudo-schema#schema";
    private WsimportOptions options;
    boolean asyncRespBeanBinding = false;

    public static List<InputSource> build(WSDLModeler wSDLModeler, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        InputSource inputSource;
        int n;
        PseudoSchemaBuilder pseudoSchemaBuilder = new PseudoSchemaBuilder(wSDLModeler.document);
        pseudoSchemaBuilder.wsdlModeler = wSDLModeler;
        pseudoSchemaBuilder.options = wsimportOptions;
        pseudoSchemaBuilder.build();
        for (n = 0; n < pseudoSchemaBuilder.schemas.size(); ++n) {
            inputSource = pseudoSchemaBuilder.schemas.get(n);
            inputSource.setSystemId(sysId + (n + 1));
        }
        if (!wsimportOptions.noAddressingBbinding && wsimportOptions.target.isLaterThan(Options.Target.V2_1)) {
            try {
                inputSource = new InputSource(new ByteArrayInputStream(w3ceprSchemaBinding.getBytes("UTF-8")));
                inputSource.setSystemId(sysId + (++n + 1));
                pseudoSchemaBuilder.schemas.add(inputSource);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error(unsupportedEncodingException);
            }
        }
        return pseudoSchemaBuilder.schemas;
    }

    private PseudoSchemaBuilder(WSDLDocument wSDLDocument) {
        this.wsdlDocument = wSDLDocument;
    }

    private void build() {
        Iterator<Service> iterator = this.wsdlDocument.getDefinitions().services();
        while (iterator.hasNext()) {
            this.build(iterator.next());
        }
    }

    private void build(Service service) {
        Iterator<Port> iterator = service.ports();
        while (iterator.hasNext()) {
            this.build(iterator.next());
        }
    }

    private void build(Port port) {
        if (this.wsdlModeler.isProvider(port)) {
            return;
        }
        Binding binding = port.resolveBinding(this.wsdlDocument);
        SOAPBinding sOAPBinding = (SOAPBinding)WSDLModelerBase.getExtensionOfType(binding, SOAPBinding.class);
        if (sOAPBinding == null) {
            sOAPBinding = (SOAPBinding)WSDLModelerBase.getExtensionOfType(binding, SOAP12Binding.class);
        }
        if (sOAPBinding == null) {
            return;
        }
        PortType portType = binding.resolvePortType(this.wsdlDocument);
        QName qName = WSDLModelerBase.getQNameOf(binding);
        if (this.bindingNameToPortMap.containsKey(qName)) {
            return;
        }
        this.bindingNameToPortMap.put(qName, port);
        Iterator iterator = binding.operations();
        while (iterator.hasNext()) {
            Operation operation;
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            Set set = portType.getOperationsNamed(bindingOperation.getName());
            if (set.size() != 1 || !this.wsdlModeler.isAsync(portType, operation = (Operation)set.iterator().next())) continue;
            this.buildAsync(portType, operation, bindingOperation);
        }
    }

    private void buildAsync(PortType portType, Operation operation, BindingOperation bindingOperation) {
        ArrayList<MessagePart> arrayList;
        String string = this.getCustomizedOperationName(operation);
        if (string == null) {
            return;
        }
        Message message = null;
        if (operation.getOutput() != null) {
            message = operation.getOutput().resolveMessage(this.wsdlDocument);
        }
        if (message != null && (arrayList = new ArrayList<MessagePart>(message.getParts())).size() > 1) {
            this.build(this.getOperationName(string), arrayList);
        }
    }

    private String getCustomizedOperationName(Operation operation) {
        String string;
        JAXWSBinding jAXWSBinding = (JAXWSBinding)WSDLModelerBase.getExtensionOfType(operation, JAXWSBinding.class);
        String string2 = jAXWSBinding != null ? (jAXWSBinding.getMethodName() != null ? jAXWSBinding.getMethodName().getName() : null) : (string = null);
        if (string != null) {
            if (Names.isJavaReservedWord(string)) {
                return null;
            }
            return string;
        }
        return operation.getName();
    }

    private void writeImports(QName qName, List<MessagePart> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MessagePart messagePart : list) {
            String string = messagePart.getDescriptor().getNamespaceURI();
            if (hashSet.contains(string) || string.equals("http://www.w3.org/2001/XMLSchema") || string.equals(qName.getNamespaceURI())) continue;
            this.print("<xs:import namespace=''{0}''/>", string);
            hashSet.add(string);
        }
    }

    private void build(QName qName, List<MessagePart> list) {
        this.print("<xs:schema xmlns:xs=''http://www.w3.org/2001/XMLSchema''           xmlns:jaxb=''http://java.sun.com/xml/ns/jaxb''           xmlns:xjc=''http://java.sun.com/xml/ns/jaxb/xjc''           jaxb:extensionBindingPrefixes=''xjc''           jaxb:version=''1.0''           targetNamespace=''{0}''>", qName.getNamespaceURI());
        this.writeImports(qName, list);
        if (!this.asyncRespBeanBinding) {
            this.print("<xs:annotation><xs:appinfo>  <jaxb:schemaBindings>    <jaxb:package name=''{0}'' />  </jaxb:schemaBindings></xs:appinfo></xs:annotation>", this.wsdlModeler.getJavaPackage());
            this.asyncRespBeanBinding = true;
        }
        this.print("<xs:element name=''{0}''>", qName.getLocalPart());
        this.print("<xs:complexType>");
        this.print("<xs:sequence>");
        for (MessagePart messagePart : list) {
            if (messagePart.getDescriptorKind() == SchemaKinds.XSD_ELEMENT) {
                this.print("<xs:element ref=''types:{0}'' xmlns:types=''{1}''/>", messagePart.getDescriptor().getLocalPart(), messagePart.getDescriptor().getNamespaceURI());
                continue;
            }
            this.print("<xs:element name=''{0}'' type=''{1}'' xmlns=''{2}'' />", messagePart.getName(), messagePart.getDescriptor().getLocalPart(), messagePart.getDescriptor().getNamespaceURI());
        }
        this.print("</xs:sequence>");
        this.print("</xs:complexType>");
        this.print("</xs:element>");
        this.print("</xs:schema>");
        if (this.buf.toString().length() > 0) {
            InputSource inputSource = new InputSource(new StringReader(this.buf.toString()));
            this.schemas.add(inputSource);
            this.buf.getBuffer().setLength(0);
        }
    }

    private QName getOperationName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        return new QName(string2, string + "Response");
    }

    private void print(String string) {
        this.print(string, new Object[0]);
    }

    private void print(String string, Object object) {
        this.print(string, new Object[]{object});
    }

    private void print(String string, Object object, Object object2) {
        this.print(string, new Object[]{object, object2});
    }

    private void print(String string, Object object, Object object2, Object object3) {
        this.print(string, new Object[]{object, object2, object3});
    }

    private void print(String string, Object[] objectArray) {
        this.buf.write(MessageFormat.format(string, objectArray));
        this.buf.write(10);
    }
}

