/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.istack.internal.NotNull;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.wscompile.AuthInfo;
import com.sun.tools.internal.ws.wscompile.BadCommandLineException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DefaultAuthenticator
extends Authenticator {
    private final List<AuthInfo> authInfo = new ArrayList<AuthInfo>();
    private final ErrorReceiver errReceiver;
    private final String proxyUser;
    private final String proxyPasswd;
    public static final String defaultAuthfile = System.getProperty("user.home") + System.getProperty("file.separator") + ".metro" + System.getProperty("file.separator") + "auth";
    private File authFile = new File(defaultAuthfile);
    private boolean giveError;

    public DefaultAuthenticator(@NotNull ErrorReceiver errorReceiver, @NotNull File file) throws BadCommandLineException {
        this.errReceiver = errorReceiver;
        this.proxyUser = System.getProperty("http.proxyUser");
        this.proxyPasswd = System.getProperty("http.proxyPassword");
        if (file != null) {
            this.authFile = file;
            this.giveError = true;
        }
        if (!this.authFile.exists()) {
            try {
                this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(this.authFile.getCanonicalPath(), defaultAuthfile), null));
            }
            catch (IOException iOException) {
                this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(this.authFile, iOException.getMessage()), null));
            }
            return;
        }
        if (!this.authFile.canRead()) {
            this.error(new SAXParseException("Authorization file: " + this.authFile + " does not have read permission!", null));
            return;
        }
        this.parseAuth();
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.proxyUser != null && this.proxyPasswd != null) {
            return new PasswordAuthentication(this.proxyUser, this.proxyPasswd.toCharArray());
        }
        for (AuthInfo authInfo : this.authInfo) {
            if (!authInfo.matchingHost(this.getRequestingURL())) continue;
            return new PasswordAuthentication(authInfo.getUser(), authInfo.getPassword().toCharArray());
        }
        return null;
    }

    private void parseAuth() {
        BufferedReader bufferedReader;
        this.errReceiver.info(new SAXParseException(WscompileMessages.WSIMPORT_READING_AUTH_FILE(this.authFile), null));
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.authFile), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error(new SAXParseException(unsupportedEncodingException.getMessage(), null));
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_FILE_NOT_FOUND(this.authFile, defaultAuthfile), null, fileNotFoundException));
            return;
        }
        LocatorImpl locatorImpl = new LocatorImpl();
        try {
            String string;
            int n = 1;
            locatorImpl.setSystemId(this.authFile.getCanonicalPath());
            while ((string = bufferedReader.readLine()) != null) {
                locatorImpl.setLineNumber(n++);
                try {
                    URL uRL = new URL(string);
                    String string2 = uRL.getUserInfo();
                    if (string2 != null) {
                        int n2 = string2.indexOf(58);
                        if (n2 >= 0) {
                            String string3 = string2.substring(0, n2);
                            String string4 = string2.substring(n2 + 1);
                            this.authInfo.add(new AuthInfo(new URL(string), string3, string4));
                            continue;
                        }
                        this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(uRL), locatorImpl));
                        continue;
                    }
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(uRL), locatorImpl));
                }
                catch (NumberFormatException numberFormatException) {
                    this.error(new SAXParseException(WscompileMessages.WSIMPORT_ILLEGAL_AUTH_INFO(string), locatorImpl));
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.error(new SAXParseException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(this.authFile, iOException.getMessage()), locatorImpl));
        }
    }

    private void error(SAXParseException sAXParseException) {
        if (this.giveError) {
            this.errReceiver.error(sAXParseException);
        } else {
            this.errReceiver.debug(sAXParseException);
        }
    }
}

