/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.wscompile.BadCommandLineException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public boolean verbose;
    public boolean quiet;
    public boolean keep;
    public File destDir = new File(".");
    public File sourceDir;
    public String classpath = System.getProperty("java.class.path");
    public boolean nocompile;
    public Target target = Target.V2_1;
    public static final int STRICT = 1;
    public static final int EXTENSION = 2;
    public int compatibilityMode = 1;
    public File targetDir = new File(".");
    public boolean debug = false;
    public boolean debugMode = false;
    private final List<File> generatedFiles = new ArrayList<File>();
    private ClassLoader classLoader;

    public boolean isExtensionMode() {
        return this.compatibilityMode == 2;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.add(file);
    }

    public void removeGeneratedFiles() {
        for (File file : this.generatedFiles) {
            if (!file.getName().endsWith(".java")) continue;
            file.delete();
        }
        this.generatedFiles.clear();
    }

    public Iterable<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        List<File> list = this.generatedFiles;
        synchronized (list) {
            for (File file : this.generatedFiles) {
                if (!file.getName().endsWith(".java")) continue;
                file.delete();
            }
            this.generatedFiles.clear();
        }
    }

    public void parseArguments(String[] stringArray) throws BadCommandLineException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (stringArray[i].charAt(0) == '-') {
                int n = this.parseArguments(stringArray, i);
                if (n == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(stringArray[i]));
                }
                i += n - 1;
                continue;
            }
            this.addFile(stringArray[i]);
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
    }

    protected void addFile(String string) throws BadCommandLineException {
    }

    protected int parseArguments(String[] stringArray, int n) throws BadCommandLineException {
        if (stringArray[n].equals("-g")) {
            this.debug = true;
            return 1;
        }
        if (stringArray[n].equals("-Xdebug")) {
            this.debugMode = true;
            return 1;
        }
        if (stringArray[n].equals("-Xendorsed")) {
            return 1;
        }
        if (stringArray[n].equals("-verbose")) {
            this.verbose = true;
            return 1;
        }
        if (stringArray[n].equals("-quiet")) {
            this.quiet = true;
            return 1;
        }
        if (stringArray[n].equals("-keep")) {
            this.keep = true;
            return 1;
        }
        if (stringArray[n].equals("-target")) {
            String string = this.requireArgument("-target", stringArray, ++n);
            this.target = Target.parse(string);
            if (this.target == null) {
                throw new BadCommandLineException(WscompileMessages.WSIMPORT_ILLEGAL_TARGET_VERSION(string));
            }
            return 2;
        }
        if (stringArray[n].equals("-d")) {
            this.destDir = new File(this.requireArgument("-d", stringArray, ++n));
            if (!this.destDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.destDir.getPath()));
            }
            return 2;
        }
        if (stringArray[n].equals("-s")) {
            this.sourceDir = new File(this.requireArgument("-s", stringArray, ++n));
            this.keep = true;
            if (!this.sourceDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.sourceDir.getPath()));
            }
            return 2;
        }
        if (stringArray[n].equals("-extension")) {
            this.compatibilityMode = 2;
            return 1;
        }
        if (stringArray[n].startsWith("-help")) {
            WeAreDone weAreDone = new WeAreDone();
            weAreDone.initOptions(this);
            throw weAreDone;
        }
        if (stringArray[n].equals("-Xnocompile")) {
            this.nocompile = true;
            this.keep = true;
            return 1;
        }
        return 0;
    }

    public String requireArgument(String string, String[] stringArray, int n) throws BadCommandLineException {
        if (stringArray[n].startsWith("-")) {
            throw new BadCommandLineException(WscompileMessages.WSCOMPILE_MISSING_OPTION_ARGUMENT(string));
        }
        return stringArray[n];
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(Options.pathToURLs(this.classpath), this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public static URL[] pathToURLs(String string) {
        URL[] uRLArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = Options.fileToURL(new File(stringTokenizer.nextToken()));
            if (uRLArray == null) continue;
            uRLArray2[n++] = uRLArray;
        }
        if (uRLArray2.length != n) {
            uRLArray = new URL[n];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
            uRLArray2 = uRLArray;
        }
        return uRLArray2;
    }

    public static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        V2_0,
        V2_1;


        public boolean isLaterThan(Target target) {
            return this.ordinal() >= target.ordinal();
        }

        public static Target parse(String string) {
            if (string.equals("2.0")) {
                return V2_0;
            }
            if (string.equals("2.1")) {
                return V2_1;
            }
            return null;
        }

        public String getVersion() {
            switch (this) {
                case V2_0: {
                    return "2.0";
                }
                case V2_1: {
                    return "2.1";
                }
            }
            return null;
        }
    }

    public static final class WeAreDone
    extends BadCommandLineException {
    }
}

