/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.istack.internal.tools.ParallelWorldClassLoader;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.tools.apt.Main;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceAP;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.BadCommandLineException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.internal.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.tools.internal.ws.wscompile.WsgenOptions;
import com.sun.tools.internal.ws.wscompile.WsimportListener;
import com.sun.tools.internal.xjc.util.NullStream;
import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.txw2.annotation.XmlAttribute;
import com.sun.xml.internal.txw2.annotation.XmlElement;
import com.sun.xml.internal.txw2.output.StreamSerializer;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.internal.ws.wsdl.writer.WSDLResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Holder;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsgenTool
implements AnnotationProcessorFactory {
    private final PrintStream out;
    private final WsgenOptions options = new WsgenOptions();
    private AnnotationProcessorContext context;
    private final Container container;
    private WebServiceAP webServiceAP;
    private int round = 0;
    static final Collection<String> supportedOptions = Collections.unmodifiableSet(new HashSet());
    static final Collection<String> supportedAnnotations;

    public WsgenTool(OutputStream outputStream, Container container) {
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.container = container;
    }

    public WsgenTool(OutputStream outputStream) {
        this(outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] stringArray) {
        Listener listener = new Listener();
        for (String string : stringArray) {
            if (!string.equals("-version")) continue;
            listener.message(ToolVersion.VERSION.BUILD_VERSION);
            return true;
        }
        try {
            this.options.parseArguments(stringArray);
            this.options.validate();
            if (!this.buildModel(this.options.endpoint.getName(), listener)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Options.WeAreDone weAreDone) {
            this.usage((WsgenOptions)weAreDone.getOptions());
        }
        catch (BadCommandLineException badCommandLineException) {
            if (badCommandLineException.getMessage() != null) {
                System.out.println(badCommandLineException.getMessage());
                System.out.println();
            }
            this.usage((WsgenOptions)badCommandLineException.getOptions());
            int n = 0;
            return n != 0;
        }
        catch (AbortException abortException) {
        }
        finally {
            if (!this.options.keep) {
                this.options.removeGeneratedFiles();
            }
        }
        return true;
    }

    private void workAroundJavacDebug() {
        block2: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                final Class<?> clazz = classLoader.loadClass("com.sun.tools.apt.main.Main");
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        block4: {
                            try {
                                Field field = clazz.getDeclaredField("forcedOpts");
                                field.setAccessible(true);
                                field.set(null, new String[0]);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                if (((WsgenTool)WsgenTool.this).options.verbose) {
                                    noSuchFieldException.printStackTrace();
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                if (!((WsgenTool)WsgenTool.this).options.verbose) break block4;
                                illegalAccessException.printStackTrace();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.options.verbose) break block2;
                classNotFoundException.printStackTrace();
            }
        }
    }

    private static boolean useBootClasspath(Class clazz) {
        try {
            ParallelWorldClassLoader.toJarUrl(clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean buildModel(String string, Listener listener) throws BadCommandLineException {
        final ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(listener);
        this.context = new AnnotationProcessorContext();
        this.webServiceAP = new WebServiceAP(this.options, this.context, errorReceiverFilter, this.out);
        boolean bl = WsgenTool.useBootClasspath(EndpointReference.class) || WsgenTool.useBootClasspath(XmlSeeAlso.class);
        String[] stringArray = new String[8 + (bl ? 1 : 0)];
        stringArray[0] = "-d";
        stringArray[1] = this.options.destDir.getAbsolutePath();
        stringArray[2] = "-classpath";
        stringArray[3] = this.options.classpath;
        stringArray[4] = "-s";
        stringArray[5] = this.options.sourceDir.getAbsolutePath();
        stringArray[6] = "-XclassesAsDecls";
        stringArray[7] = string;
        if (bl) {
            stringArray[8] = "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointReference.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(XmlSeeAlso.class);
        }
        this.workAroundJavacDebug();
        int n = Main.process((AnnotationProcessorFactory)this, stringArray);
        if (n != 0) {
            this.out.println(WscompileMessages.WSCOMPILE_ERROR(WscompileMessages.WSCOMPILE_COMPILATION_FAILED()));
            return false;
        }
        if (this.options.genWsdl) {
            Class<?> clazz;
            String string2 = this.options.destDir.getAbsolutePath() + File.pathSeparator + this.options.classpath;
            URLClassLoader uRLClassLoader = new URLClassLoader(Options.pathToURLs(string2), this.getClass().getClassLoader());
            try {
                clazz = uRLClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_NOT_FOUND(string));
            }
            BindingID bindingID = this.options.getBindingID(this.options.protocol);
            if (!this.options.protocolSet) {
                bindingID = BindingID.parse(clazz);
            }
            WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(clazz);
            RuntimeModeler runtimeModeler = new RuntimeModeler(clazz, this.options.serviceName, bindingID, webServiceFeatureList.toArray());
            runtimeModeler.setClassLoader((ClassLoader)uRLClassLoader);
            if (this.options.portName != null) {
                runtimeModeler.setPortName(this.options.portName);
            }
            AbstractSEIModelImpl abstractSEIModelImpl = runtimeModeler.buildRuntimeModel();
            final File[] fileArray = new File[1];
            final HashMap<String, File> hashMap = new HashMap<String, File>();
            WSDLGenerator wSDLGenerator = new WSDLGenerator(abstractSEIModelImpl, new WSDLResolver(){

                private File toFile(String string) {
                    return new File(((WsgenTool)WsgenTool.this).options.nonclassDestDir, string);
                }

                private Result toResult(File file) {
                    StreamResult streamResult;
                    try {
                        streamResult = new StreamResult(new FileOutputStream(file));
                        streamResult.setSystemId(file.getPath().replace('\\', '/'));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        errorReceiverFilter.error(fileNotFoundException);
                        return null;
                    }
                    return streamResult;
                }

                public Result getWSDL(String string) {
                    File file;
                    fileArray[0] = file = this.toFile(string);
                    return this.toResult(file);
                }

                public Result getSchemaOutput(String string, String string2) {
                    if (string.equals("")) {
                        return null;
                    }
                    File file = this.toFile(string2);
                    hashMap.put(string, file);
                    return this.toResult(file);
                }

                public Result getAbstractWSDL(Holder<String> holder) {
                    return this.toResult(this.toFile((String)holder.value));
                }

                public Result getSchemaOutput(String string, Holder<String> holder) {
                    return this.getSchemaOutput(string, (String)holder.value);
                }
            }, bindingID.createBinding(webServiceFeatureList.toArray()), this.container, clazz, (WSDLGeneratorExtension[])ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
            wSDLGenerator.doGeneration();
            if (this.options.wsgenReport != null) {
                this.generateWsgenReport(clazz, abstractSEIModelImpl, fileArray[0], hashMap);
            }
        }
        return true;
    }

    private void generateWsgenReport(Class<?> clazz, AbstractSEIModelImpl abstractSEIModelImpl, File file, Map<String, File> map) {
        try {
            ReportOutput.Report report = (ReportOutput.Report)TXW.create(ReportOutput.Report.class, (XmlSerializer)new StreamSerializer((OutputStream)new BufferedOutputStream(new FileOutputStream(this.options.wsgenReport))));
            report.wsdl(file.getAbsolutePath());
            ReportOutput.writeQName(abstractSEIModelImpl.getServiceQName(), report.service());
            ReportOutput.writeQName(abstractSEIModelImpl.getPortName(), report.port());
            ReportOutput.writeQName(abstractSEIModelImpl.getPortTypeName(), report.portType());
            report.implClass(clazz.getName());
            for (Map.Entry<String, File> entry : map.entrySet()) {
                ReportOutput.Schema schema = report.schema();
                schema.ns(entry.getKey());
                schema.location(entry.getValue().getAbsolutePath());
            }
            report.commit();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    protected void usage(WsgenOptions wsgenOptions) {
        if (wsgenOptions == null) {
            wsgenOptions = this.options;
        }
        System.out.println(WscompileMessages.WSGEN_HELP("WSGEN", wsgenOptions.protocols, wsgenOptions.nonstdProtocols.keySet()));
        System.out.println(WscompileMessages.WSGEN_USAGE_EXAMPLES());
    }

    @Override
    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    @Override
    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    @Override
    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        if (this.options.verbose) {
            annotationProcessorEnvironment.getMessager().printNotice("\tap round: " + ++this.round);
        }
        this.webServiceAP.init(annotationProcessorEnvironment);
        return this.webServiceAP;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("*");
        hashSet.add("javax.jws.*");
        hashSet.add("javax.jws.soap.*");
        supportedAnnotations = Collections.unmodifiableCollection(hashSet);
    }

    class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        Listener() {
            this.cer = new ConsoleErrorReporter(WsgenTool.this.out == null ? new PrintStream(new NullStream()) : WsgenTool.this.out);
        }

        public void generatedFile(String string) {
            this.message(string);
        }

        public void message(String string) {
            WsgenTool.this.out.println(string);
        }

        public void error(SAXParseException sAXParseException) {
            this.cer.error(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.cer.fatalError(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            this.cer.warning(sAXParseException);
        }

        public void info(SAXParseException sAXParseException) {
            this.cer.info(sAXParseException);
        }
    }

    static class ReportOutput {
        ReportOutput() {
        }

        private static void writeQName(QName qName, QualifiedName qualifiedName) {
            qualifiedName.uri(qName.getNamespaceURI());
            qualifiedName.localName(qName.getLocalPart());
        }

        static interface QualifiedName
        extends TypedXmlWriter {
            @XmlAttribute
            public void uri(String var1);

            @XmlAttribute
            public void localName(String var1);
        }

        @XmlElement(value="report")
        static interface Report
        extends TypedXmlWriter {
            @XmlElement
            public void wsdl(String var1);

            @XmlElement
            public QualifiedName portType();

            @XmlElement
            public QualifiedName service();

            @XmlElement
            public QualifiedName port();

            @XmlElement
            public void implClass(String var1);

            @XmlElement
            public Schema schema();
        }

        static interface Schema
        extends TypedXmlWriter {
            @XmlAttribute
            public void ns(String var1);

            @XmlAttribute
            public void location(String var1);
        }
    }
}

