/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.framework;

import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.EntityAction;
import com.sun.tools.internal.ws.wsdl.framework.EntityReferenceValidator;
import com.sun.tools.internal.ws.wsdl.framework.GloballyKnown;
import com.sun.tools.internal.ws.wsdl.framework.Kind;
import com.sun.tools.internal.ws.wsdl.framework.ValidationException;
import com.sun.tools.internal.ws.wsdl.parser.DOMForest;
import com.sun.tools.internal.ws.wsdl.parser.MetadataFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class AbstractDocument {
    protected final DOMForest forest;
    protected final ErrorReceiver errReceiver;
    private final Map kinds;
    private String _systemId;
    private final Set importedDocuments;
    private final List importedEntities;
    private final Set includedDocuments;
    private final List includedEntities;

    protected AbstractDocument(MetadataFinder metadataFinder, ErrorReceiver errorReceiver) {
        this.forest = metadataFinder;
        this.errReceiver = errorReceiver;
        this.kinds = new HashMap();
        this.importedEntities = new ArrayList();
        this.importedDocuments = new HashSet();
        this.includedEntities = new ArrayList();
        this.includedDocuments = new HashSet();
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String string) {
        if (this._systemId != null && !this._systemId.equals(string)) {
            throw new IllegalArgumentException();
        }
        this._systemId = string;
        if (string != null) {
            this.importedDocuments.add(string);
        }
    }

    public void addIncludedDocument(String string) {
        this.includedDocuments.add(string);
    }

    public boolean isIncludedDocument(String string) {
        return this.includedDocuments.contains(string);
    }

    public void addIncludedEntity(Entity entity) {
        this.includedEntities.add(entity);
    }

    public void addImportedDocument(String string) {
        this.importedDocuments.add(string);
    }

    public boolean isImportedDocument(String string) {
        return this.importedDocuments.contains(string);
    }

    public void addImportedEntity(Entity entity) {
        this.importedEntities.add(entity);
    }

    public void withAllSubEntitiesDo(EntityAction entityAction) {
        if (this.getRoot() != null) {
            entityAction.perform(this.getRoot());
        }
        Iterator iterator = this.importedEntities.iterator();
        while (iterator.hasNext()) {
            entityAction.perform((Entity)iterator.next());
        }
        iterator = this.includedEntities.iterator();
        while (iterator.hasNext()) {
            entityAction.perform((Entity)iterator.next());
        }
    }

    public Map getMap(Kind kind) {
        HashMap hashMap = (HashMap)this.kinds.get(kind.getName());
        if (hashMap == null) {
            hashMap = new HashMap();
            this.kinds.put(kind.getName(), hashMap);
        }
        return hashMap;
    }

    public void define(GloballyKnown globallyKnown) {
        Map map = this.getMap(globallyKnown.getKind());
        if (globallyKnown.getName() == null) {
            return;
        }
        QName qName = new QName(globallyKnown.getDefining().getTargetNamespaceURI(), globallyKnown.getName());
        if (map.containsKey(qName)) {
            this.errReceiver.error(globallyKnown.getLocator(), WsdlMessages.ENTITY_DUPLICATE_WITH_TYPE(globallyKnown.getElementName().getLocalPart(), globallyKnown.getName()));
            throw new AbortException();
        }
        map.put(qName, globallyKnown);
    }

    public GloballyKnown find(Kind kind, QName qName) {
        Map map = this.getMap(kind);
        Object v = map.get(qName);
        if (v == null) {
            this.errReceiver.error(null, WsdlMessages.ENTITY_NOT_FOUND_BY_Q_NAME(kind.getName(), qName, this._systemId));
            throw new AbortException();
        }
        return (GloballyKnown)v;
    }

    public void validateLocally() {
        LocallyValidatingAction locallyValidatingAction = new LocallyValidatingAction();
        this.withAllSubEntitiesDo(locallyValidatingAction);
        if (locallyValidatingAction.getException() != null) {
            throw locallyValidatingAction.getException();
        }
    }

    public abstract void validate(EntityReferenceValidator var1);

    protected abstract Entity getRoot();

    private class LocallyValidatingAction
    implements EntityAction {
        private ValidationException _exception;

        public void perform(Entity entity) {
            block2: {
                try {
                    entity.validateThis();
                    entity.withAllSubEntitiesDo(this);
                }
                catch (ValidationException validationException) {
                    if (this._exception != null) break block2;
                    this._exception = validationException;
                }
            }
        }

        public ValidationException getException() {
            return this._exception;
        }
    }
}

