/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.framework.ParseException;
import com.sun.tools.internal.ws.wsdl.parser.DOMForest;
import com.sun.tools.internal.ws.wsdl.parser.InternalizationLogic;
import com.sun.xml.internal.ws.api.wsdl.parser.MetaDataResolver;
import com.sun.xml.internal.ws.api.wsdl.parser.MetadataResolverFactory;
import com.sun.xml.internal.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataFinder
extends DOMForest {
    public boolean isMexMetadata;
    private String rootWSDL;
    private Set<String> rootWsdls = new HashSet<String>();

    public MetadataFinder(InternalizationLogic internalizationLogic, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        super(internalizationLogic, wsimportOptions, errorReceiver);
    }

    public void parseWSDL() {
        for (InputSource inputSource : this.options.getWSDLs()) {
            String string = inputSource.getSystemId();
            this.errorReceiver.pollAbort();
            Element element = null;
            try {
                Document document;
                if (this.options.entityResolver != null) {
                    inputSource = this.options.entityResolver.resolveEntity(null, string);
                }
                if (inputSource == null) {
                    inputSource = new InputSource(string);
                }
                if ((element = (document = this.parse(inputSource, true)).getDocumentElement()) == null) continue;
                if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !element.getLocalName().equals("definitions")) {
                    throw new SAXParseException(WsdlMessages.INVALID_WSDL(string, WSDLConstants.QNAME_DEFINITIONS, element.getNodeName(), this.locatorTable.getStartLocation(element).getLineNumber()), this.locatorTable.getStartLocation(element));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errorReceiver.error(WsdlMessages.FILE_NOT_FOUND(string), fileNotFoundException);
                return;
            }
            catch (IOException iOException) {
                element = this.getFromMetadataResolver(string, iOException);
            }
            catch (SAXParseException sAXParseException) {
                element = this.getFromMetadataResolver(string, sAXParseException);
            }
            catch (SAXException sAXException) {
                element = this.getFromMetadataResolver(string, sAXException);
            }
            if (element == null) continue;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (this.inlinedSchemaElements.contains(nodeList.item(i))) continue;
                this.inlinedSchemaElements.add((Element)nodeList.item(i));
            }
        }
        this.identifyRootWslds();
    }

    @Nullable
    public String getRootWSDL() {
        return this.rootWSDL;
    }

    @NotNull
    public Set<String> getRootWSDLs() {
        return this.rootWsdls;
    }

    private void identifyRootWslds() {
        for (Object object : this.rootDocuments) {
            Element element;
            Document object2 = this.get((String)object);
            if (object2 == null || (element = object2.getDocumentElement()) == null || element.getLocalName() == null || element.getNamespaceURI() == null || !element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !element.getLocalName().equals("definitions")) continue;
            this.rootWsdls.add((String)object);
            NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
            if (nodeList.getLength() <= 0) continue;
            this.rootWSDL = object;
        }
        if (this.rootWSDL == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.rootWsdls) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            this.errorReceiver.error(null, WsdlMessages.FAILED_NOSERVICE(stringBuffer.toString()));
        }
    }

    @Nullable
    private Element getFromMetadataResolver(String string, Exception exception) {
        ServiceDescriptor serviceDescriptor = null;
        for (MetadataResolverFactory metadataResolverFactory : ServiceFinder.find(MetadataResolverFactory.class)) {
            MetaDataResolver metaDataResolver = metadataResolverFactory.metadataResolver(this.options.entityResolver);
            try {
                serviceDescriptor = metaDataResolver.resolve(new URI(string));
                if (serviceDescriptor == null) continue;
                break;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException(uRISyntaxException);
            }
        }
        if (serviceDescriptor != null) {
            this.errorReceiver.warning(new SAXParseException(WsdlMessages.TRY_WITH_MEX(exception.getMessage()), null, exception));
            return this.parseMetadata(string, serviceDescriptor);
        }
        this.errorReceiver.error(null, WsdlMessages.PARSING_UNABLE_TO_GET_METADATA(exception.getMessage(), WscompileMessages.WSIMPORT_NO_WSDL(string)), exception);
        return null;
    }

    private Element parseMetadata(@NotNull String string, @NotNull ServiceDescriptor serviceDescriptor) {
        Node node;
        Node node2;
        List list = serviceDescriptor.getWSDLs();
        List list2 = serviceDescriptor.getSchemas();
        Document document = null;
        for (Source source : list) {
            NodeList nodeList;
            if (!(source instanceof DOMSource)) continue;
            node2 = ((DOMSource)source).getNode();
            if (node2.getNodeType() == 1 && node2.getOwnerDocument() == null) {
                node = DOMUtil.createDom();
                node.importNode(node2, true);
            } else {
                node = node2.getOwnerDocument();
            }
            if (document == null && (nodeList = node.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service")).getLength() > 0) {
                document = node;
                this.rootWSDL = source.getSystemId();
            }
            nodeList = node.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttribute("location");
                if (string2 == null || this.externalReferences.contains(string2)) continue;
                this.externalReferences.add(string2);
            }
            if (this.core.keySet().contains(string)) {
                this.core.remove(string);
            }
            this.core.put(source.getSystemId(), node);
            this.isMexMetadata = true;
        }
        for (Source source : list2) {
            if (!(source instanceof DOMSource)) continue;
            node2 = ((DOMSource)source).getNode();
            node = node2.getNodeType() == 1 ? (Element)node2 : DOMUtil.getFirstElementChild((Node)node2);
            this.inlinedSchemaElements.add(node);
        }
        return document.getDocumentElement();
    }
}

