/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.resources.WsdlMessages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class VersionChecker
extends XMLFilterImpl {
    private String version = null;
    private boolean seenRoot = false;
    private boolean seenBindings = false;
    private Locator locator;
    private Locator rootTagStart;
    private static final Set<String> VERSIONS = new HashSet<String>(Arrays.asList("2.0", "2.1"));

    public VersionChecker(XMLReader xMLReader) {
        this.setParent(xMLReader);
    }

    public VersionChecker(ContentHandler contentHandler, ErrorHandler errorHandler, EntityResolver entityResolver) {
        this.setContentHandler(contentHandler);
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            this.setEntityResolver(entityResolver);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (!this.seenRoot) {
            this.seenRoot = true;
            this.rootTagStart = new LocatorImpl(this.locator);
            this.version = attributes.getValue("http://java.sun.com/xml/ns/jaxws", "version");
            if (string.equals("http://java.sun.com/xml/ns/jaxws")) {
                String string4 = attributes.getValue("", "version");
                if (this.version != null && string4 != null) {
                    SAXParseException sAXParseException = new SAXParseException(WsdlMessages.INTERNALIZER_TWO_VERSION_ATTRIBUTES(), this.locator);
                    this.getErrorHandler().error(sAXParseException);
                }
                if (this.version == null) {
                    String string5 = this.version = string4 != null ? string4 : "2.0";
                }
            }
        }
        if ("http://java.sun.com/xml/ns/jaxws".equals(string)) {
            this.seenBindings = true;
            if (this.version == null) {
                this.version = "2.0";
            }
        }
    }

    public void endDocument() throws SAXException {
        SAXParseException sAXParseException;
        super.endDocument();
        if (this.seenBindings && this.version == null) {
            sAXParseException = new SAXParseException(WsdlMessages.INTERNALIZER_VERSION_NOT_PRESENT(), this.rootTagStart);
            this.getErrorHandler().error(sAXParseException);
        }
        if (this.version != null && !VERSIONS.contains(this.version)) {
            sAXParseException = new SAXParseException(WsdlMessages.INTERNALIZER_INCORRECT_VERSION(), this.rootTagStart);
            this.getErrorHandler().error(sAXParseException);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }
}

