/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensionHandler;
import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.document.Binding;
import com.sun.tools.internal.ws.wsdl.document.BindingFault;
import com.sun.tools.internal.ws.wsdl.document.BindingInput;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.BindingOutput;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Import;
import com.sun.tools.internal.ws.wsdl.document.Input;
import com.sun.tools.internal.ws.wsdl.document.Message;
import com.sun.tools.internal.ws.wsdl.document.MessagePart;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.OperationStyle;
import com.sun.tools.internal.ws.wsdl.document.Output;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocument;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaConstants;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.GlobalEntity;
import com.sun.tools.internal.ws.wsdl.framework.ParserListener;
import com.sun.tools.internal.ws.wsdl.framework.TWSDLParserContextImpl;
import com.sun.tools.internal.ws.wsdl.parser.HTTPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Internalizer;
import com.sun.tools.internal.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MIMEExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MemberSubmissionAddressingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.internal.ws.wsdl.parser.SOAP12ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SOAPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import com.sun.tools.internal.ws.wsdl.parser.W3CAddressingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WSDLParser {
    private final ErrorReceiverFilter errReceiver;
    private WsimportOptions options;
    private MetadataFinder forest;
    private final Map extensionHandlers = new HashMap();
    private ArrayList<ParserListener> listeners;

    public WSDLParser(WsimportOptions wsimportOptions, ErrorReceiverFilter errorReceiverFilter) {
        this.options = wsimportOptions;
        this.errReceiver = errorReceiverFilter;
        this.register(new SOAPExtensionHandler(this.extensionHandlers));
        this.register(new HTTPExtensionHandler(this.extensionHandlers));
        this.register(new MIMEExtensionHandler(this.extensionHandlers));
        this.register(new JAXWSBindingExtensionHandler(this.extensionHandlers));
        this.register(new SOAP12ExtensionHandler(this.extensionHandlers));
        this.register(new MemberSubmissionAddressingExtensionHandler(this.extensionHandlers, errorReceiverFilter));
        this.register(new W3CAddressingExtensionHandler(this.extensionHandlers, errorReceiverFilter));
        for (TWSDLExtensionHandler tWSDLExtensionHandler : ServiceFinder.find(TWSDLExtensionHandler.class)) {
            this.register(tWSDLExtensionHandler);
        }
    }

    private void register(TWSDLExtensionHandler tWSDLExtensionHandler) {
        this.extensionHandlers.put(tWSDLExtensionHandler.getNamespaceURI(), tWSDLExtensionHandler);
    }

    public void addParserListener(ParserListener parserListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(parserListener);
    }

    public WSDLDocument parse() throws SAXException, IOException {
        this.forest = new MetadataFinder(new WSDLInternalizationLogic(), this.options, this.errReceiver);
        this.forest.parseWSDL();
        if (this.forest.isMexMetadata) {
            this.errReceiver.reset();
        }
        for (InputSource inputSource : this.options.getWSDLBindings()) {
            this.errReceiver.pollAbort();
            Document document = this.forest.parse(inputSource, false);
            if (document == null) continue;
            Element element = document.getDocumentElement();
            if (!this.fixNull(element.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxws") || !element.getLocalName().equals("bindings")) {
                this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSER_NOT_A_BINDING_FILE(element.getNamespaceURI(), element.getLocalName()));
                continue;
            }
            NodeList nodeList = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.options.addHandlerChainConfiguration((Element)nodeList.item(i));
            }
        }
        return this.buildWSDLDocument();
    }

    private String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public MetadataFinder getDOMForest() {
        return this.forest;
    }

    private WSDLDocument buildWSDLDocument() {
        String string = this.forest.getRootWSDL();
        if (string == null) {
            return null;
        }
        Document document = this.forest.get(string);
        if (document == null) {
            return null;
        }
        WSDLDocument wSDLDocument = new WSDLDocument(this.forest, this.errReceiver);
        wSDLDocument.setSystemId(string);
        TWSDLParserContextImpl tWSDLParserContextImpl = new TWSDLParserContextImpl(this.forest, wSDLDocument, this.listeners, this.errReceiver);
        Definitions definitions = this.parseDefinitions(tWSDLParserContextImpl, document);
        wSDLDocument.setDefinitions(definitions);
        return wSDLDocument;
    }

    private Definitions parseDefinitions(TWSDLParserContextImpl tWSDLParserContextImpl, Document document) {
        tWSDLParserContextImpl.pushWSDLLocation();
        tWSDLParserContextImpl.setWSDLLocation(tWSDLParserContextImpl.getDocument().getSystemId());
        new Internalizer(this.forest, this.options, this.errReceiver).transform();
        Definitions definitions = this.parseDefinitionsNoImport(tWSDLParserContextImpl, document);
        if (definitions == null) {
            Locator locator = this.forest.locatorTable.getStartLocation(document.getDocumentElement());
            this.errReceiver.error(locator, WsdlMessages.PARSING_NOT_AWSDL(locator.getSystemId()));
        }
        this.processImports(tWSDLParserContextImpl);
        tWSDLParserContextImpl.popWSDLLocation();
        return definitions;
    }

    private void processMexDocs(TWSDLParserContextImpl tWSDLParserContextImpl) {
        for (String string : this.forest.listSystemIDs()) {
            Definitions definitions;
            Document document;
            if (tWSDLParserContextImpl.getDocument().isImportedDocument(string) || (document = this.forest.get(string)) == null || (definitions = this.parseDefinitionsNoImport(tWSDLParserContextImpl, document)) == null) continue;
            tWSDLParserContextImpl.getDocument().addImportedEntity(definitions);
            tWSDLParserContextImpl.getDocument().addImportedDocument(string);
        }
    }

    private void processImports(TWSDLParserContextImpl tWSDLParserContextImpl) {
        for (String string : this.forest.getExternalReferences()) {
            Definitions definitions;
            Document document;
            if (tWSDLParserContextImpl.getDocument().isImportedDocument(string) || (document = this.forest.get(string)) == null || (definitions = this.parseDefinitionsNoImport(tWSDLParserContextImpl, document)) == null) continue;
            tWSDLParserContextImpl.getDocument().addImportedEntity(definitions);
            tWSDLParserContextImpl.getDocument().addImportedDocument(string);
        }
    }

    private Definitions parseDefinitionsNoImport(TWSDLParserContextImpl tWSDLParserContextImpl, Document document) {
        Element element;
        Element element2 = document.getDocumentElement();
        if (element2.getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !element2.getLocalName().equals("definitions")) {
            return null;
        }
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element2);
        Definitions definitions = new Definitions(tWSDLParserContextImpl.getDocument(), this.forest.locatorTable.getStartLocation(element2));
        String string = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
        definitions.setName(string);
        String string2 = XmlUtil.getAttributeOrNull((Element)element2, (String)"targetNamespace");
        definitions.setTargetNamespaceURI(string2);
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element2);
        while (iterator.hasNext() && (element = Util.nextElement(iterator)) != null) {
            GlobalEntity globalEntity;
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element2.getLocalName()));
                    return null;
                }
                bl = true;
                if (definitions.getDocumentation() != null) continue;
                definitions.setDocumentation(this.getDocumentationFor(element));
                continue;
            }
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_TYPES)) {
                if (bl2 && !this.options.isExtensionMode()) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_TYPES_ALLOWED("definitions"));
                    return null;
                }
                bl2 = true;
                if (this.options.isExtensionMode()) continue;
                this.validateSchemaImports(element);
                continue;
            }
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_MESSAGE)) {
                globalEntity = this.parseMessage(tWSDLParserContextImpl, definitions, element);
                definitions.add((Message)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_PORT_TYPE)) {
                globalEntity = this.parsePortType(tWSDLParserContextImpl, definitions, element);
                definitions.add((PortType)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_BINDING)) {
                globalEntity = this.parseBinding(tWSDLParserContextImpl, definitions, element);
                definitions.add((Binding)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_SERVICE)) {
                globalEntity = this.parseService(tWSDLParserContextImpl, definitions, element);
                definitions.add((Service)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(tWSDLParserContextImpl, definitions, element));
                continue;
            }
            if (XmlUtil.matchesTagNS(element, SchemaConstants.QNAME_IMPORT)) {
                this.errReceiver.warning(this.forest.locatorTable.getStartLocation(element), WsdlMessages.WARNING_WSI_R_2003());
                continue;
            }
            this.checkNotWsdlElement(element);
            if (this.handleExtension(tWSDLParserContextImpl, definitions, element)) continue;
            this.checkNotWsdlRequired(element);
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    private Message parseMessage(TWSDLParserContextImpl tWSDLParserContextImpl, Definitions definitions, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        Message message = new Message(definitions, this.forest.locatorTable.getStartLocation(element), this.errReceiver);
        String string = Util.getRequiredAttribute(element, "name");
        message.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                message.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PART)) {
                MessagePart messagePart = this.parseMessagePart(tWSDLParserContextImpl, element2);
                message.add(messagePart);
                continue;
            }
            Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    private MessagePart parseMessagePart(TWSDLParserContextImpl tWSDLParserContextImpl, Element element) {
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        MessagePart messagePart = new MessagePart(this.forest.locatorTable.getStartLocation(element));
        String string = Util.getRequiredAttribute(element, "name");
        messagePart.setName(string);
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"element");
        String string3 = XmlUtil.getAttributeOrNull((Element)element, (String)"type");
        if (string2 != null) {
            if (string3 != null) {
                this.errReceiver.error(tWSDLParserContextImpl.getLocation(element), WsdlMessages.PARSING_ONLY_ONE_OF_ELEMENT_OR_TYPE_REQUIRED(string));
            }
            messagePart.setDescriptor(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element), string2));
            messagePart.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (string3 != null) {
            messagePart.setDescriptor(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element), string3));
            messagePart.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            this.errReceiver.warning(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ELEMENT_OR_TYPE_REQUIRED(string));
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_PART, messagePart);
        return messagePart;
    }

    private PortType parsePortType(TWSDLParserContextImpl tWSDLParserContextImpl, Definitions definitions, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        PortType portType = new PortType(definitions, this.forest.locatorTable.getStartLocation(element), this.errReceiver);
        String string = Util.getRequiredAttribute(element, "name");
        portType.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                }
                bl = true;
                if (portType.getDocumentation() != null) continue;
                portType.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OPERATION)) {
                Operation operation = this.parsePortTypeOperation(tWSDLParserContextImpl, element2);
                operation.setParent(portType);
                portType.add(operation);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(tWSDLParserContextImpl, portType, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    private Operation parsePortTypeOperation(TWSDLParserContextImpl tWSDLParserContextImpl, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        Operation operation = new Operation(this.forest.locatorTable.getStartLocation(element));
        String string = Util.getRequiredAttribute(element, "name");
        operation.setName(string);
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"parameterOrder");
        operation.setParameterOrder(string2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            Element element3;
            boolean bl6;
            Object object;
            String string3;
            String string4;
            Entity entity;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element2), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element2.getLocalName()));
                }
                bl = true;
                if (operation.getDocumentation() != null) continue;
                operation.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_INPUT)) {
                if (bl2) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", string));
                }
                tWSDLParserContextImpl.push();
                tWSDLParserContextImpl.registerNamespaces(element2);
                entity = new Input(this.forest.locatorTable.getStartLocation(element2), this.errReceiver);
                ((Input)entity).setParent(operation);
                string4 = Util.getRequiredAttribute(element2, "message");
                ((Input)entity).setMessage(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element2), string4));
                string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((Input)entity).setName(string3);
                operation.setInput((Input)entity);
                bl2 = true;
                if (bl3) {
                    bl5 = false;
                }
                Iterator iterator2 = XmlUtil.getAllAttributes((Element)element2);
                while (iterator2.hasNext()) {
                    object = (Attr)iterator2.next();
                    if (object.getLocalName().equals("message") || object.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute((Attr)object);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)((Object)entity), (Node)object, element2)) continue;
                }
                bl6 = false;
                object = XmlUtil.getAllChildren((Element)element2);
                while (object.hasNext() && (element3 = Util.nextElement((Iterator)object)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                        }
                        bl6 = true;
                        ((Input)entity).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element3), WsdlMessages.PARSING_INVALID_ELEMENT(element3.getTagName(), element3.getNamespaceURI()));
                }
                tWSDLParserContextImpl.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OUTPUT)) {
                if (bl3) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", string));
                }
                tWSDLParserContextImpl.push();
                tWSDLParserContextImpl.registerNamespaces(element2);
                entity = new Output(this.forest.locatorTable.getStartLocation(element2), this.errReceiver);
                ((Output)entity).setParent(operation);
                string4 = Util.getRequiredAttribute(element2, "message");
                ((Output)entity).setMessage(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element2), string4));
                string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((Output)entity).setName(string3);
                operation.setOutput((Output)entity);
                bl3 = true;
                if (bl2) {
                    bl5 = true;
                }
                Iterator iterator3 = XmlUtil.getAllAttributes((Element)element2);
                while (iterator3.hasNext()) {
                    object = (Attr)iterator3.next();
                    if (object.getLocalName().equals("message") || object.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute((Attr)object);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)((Object)entity), (Node)object, element2)) continue;
                }
                bl6 = false;
                object = XmlUtil.getAllChildren((Element)element2);
                while (object.hasNext() && (element3 = Util.nextElement((Iterator)object)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                        }
                        bl6 = true;
                        ((Output)entity).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element3), WsdlMessages.PARSING_INVALID_ELEMENT(element3.getTagName(), element3.getNamespaceURI()));
                }
                tWSDLParserContextImpl.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_FAULT)) {
                tWSDLParserContextImpl.push();
                tWSDLParserContextImpl.registerNamespaces(element2);
                entity = new Fault(this.forest.locatorTable.getStartLocation(element2));
                ((Fault)entity).setParent(operation);
                string4 = Util.getRequiredAttribute(element2, "message");
                ((Fault)entity).setMessage(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element2), string4));
                string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((Fault)entity).setName(string3);
                operation.addFault((Fault)entity);
                bl4 = true;
                Iterator iterator4 = XmlUtil.getAllAttributes((Element)element2);
                while (iterator4.hasNext()) {
                    object = (Attr)iterator4.next();
                    if (object.getLocalName().equals("message") || object.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute((Attr)object);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)((Object)entity), (Node)object, element2)) continue;
                }
                bl6 = false;
                object = XmlUtil.getAllChildren((Element)element2);
                while (object.hasNext() && (element3 = Util.nextElement((Iterator)object)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                        }
                        bl6 = true;
                        if (((Fault)entity).getDocumentation() != null) continue;
                        ((Fault)entity).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    this.checkNotWsdlElement(element3);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)((Object)entity), element3)) continue;
                    this.checkNotWsdlRequired(element3);
                }
                tWSDLParserContextImpl.pop();
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(tWSDLParserContextImpl, operation, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        if (bl2 && !bl3 && !bl4) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (bl2 && bl3 && bl5) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (bl2 && bl3 && !bl5) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (bl3 && !bl2 && !bl4) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_INVALID_OPERATION_STYLE(string));
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    private Binding parseBinding(TWSDLParserContextImpl tWSDLParserContextImpl, Definitions definitions, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        Binding binding = new Binding(definitions, this.forest.locatorTable.getStartLocation(element), this.errReceiver);
        String string = Util.getRequiredAttribute(element, "name");
        binding.setName(string);
        String string2 = Util.getRequiredAttribute(element, "type");
        binding.setPortType(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element), string2));
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                }
                bl = true;
                binding.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation bindingOperation = this.parseBindingOperation(tWSDLParserContextImpl, element2);
                binding.add(bindingOperation);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(tWSDLParserContextImpl, binding, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    private BindingOperation parseBindingOperation(TWSDLParserContextImpl tWSDLParserContextImpl, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        BindingOperation bindingOperation = new BindingOperation(this.forest.locatorTable.getStartLocation(element));
        String string = Util.getRequiredAttribute(element, "name");
        bindingOperation.setName(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            Object object;
            Object object2;
            Object object3;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                }
                bl = true;
                bindingOperation.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_INPUT)) {
                Element element3;
                if (bl2) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", string));
                }
                object3 = XmlUtil.getAllChildren((Element)element2);
                tWSDLParserContextImpl.push();
                tWSDLParserContextImpl.registerNamespaces(element2);
                object2 = new BindingInput(this.forest.locatorTable.getStartLocation(element2));
                String string2 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((BindingInput)object2).setName(string2);
                bindingOperation.setInput((BindingInput)object2);
                bl2 = true;
                if (bl3) {
                    bl5 = false;
                }
                boolean bl6 = false;
                object = XmlUtil.getAllChildren((Element)element2);
                while (object.hasNext() && (element3 = Util.nextElement((Iterator)object)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                        }
                        bl6 = true;
                        ((BindingInput)object2).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    this.checkNotWsdlElement(element3);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)object2, element3)) continue;
                    this.checkNotWsdlRequired(element3);
                }
                tWSDLParserContextImpl.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OUTPUT)) {
                if (bl3) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", string));
                }
                tWSDLParserContextImpl.push();
                tWSDLParserContextImpl.registerNamespaces(element2);
                object3 = new BindingOutput(this.forest.locatorTable.getStartLocation(element2));
                object2 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((BindingOutput)object3).setName((String)object2);
                bindingOperation.setOutput((BindingOutput)object3);
                bl3 = true;
                if (bl2) {
                    bl5 = true;
                }
                boolean bl7 = false;
                Iterator iterator2 = XmlUtil.getAllChildren((Element)element2);
                while (iterator2.hasNext() && (object = Util.nextElement(iterator2)) != null) {
                    if (XmlUtil.matchesTagNS((Element)object, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl7) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                        }
                        bl7 = true;
                        ((BindingOutput)object3).setDocumentation(this.getDocumentationFor((Element)object));
                        continue;
                    }
                    this.checkNotWsdlElement((Element)object);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)object3, (Element)object)) continue;
                    this.checkNotWsdlRequired((Element)object);
                }
                tWSDLParserContextImpl.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_FAULT)) {
                tWSDLParserContextImpl.push();
                tWSDLParserContextImpl.registerNamespaces(element2);
                object3 = new BindingFault(this.forest.locatorTable.getStartLocation(element2));
                object2 = Util.getRequiredAttribute(element2, "name");
                ((BindingFault)object3).setName((String)object2);
                bindingOperation.addFault((BindingFault)object3);
                bl4 = true;
                boolean bl8 = false;
                Iterator iterator3 = XmlUtil.getAllChildren((Element)element2);
                while (iterator3.hasNext() && (object = Util.nextElement(iterator3)) != null) {
                    if (XmlUtil.matchesTagNS((Element)object, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl8) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                        }
                        bl8 = true;
                        if (((BindingFault)object3).getDocumentation() != null) continue;
                        ((BindingFault)object3).setDocumentation(this.getDocumentationFor((Element)object));
                        continue;
                    }
                    this.checkNotWsdlElement((Element)object);
                    if (this.handleExtension(tWSDLParserContextImpl, (TWSDLExtensible)object3, (Element)object)) continue;
                    this.checkNotWsdlRequired((Element)object);
                }
                tWSDLParserContextImpl.pop();
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(tWSDLParserContextImpl, bindingOperation, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        if (bl2 && !bl3 && !bl4) {
            bindingOperation.setStyle(OperationStyle.ONE_WAY);
        } else if (bl2 && bl3 && bl5) {
            bindingOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (bl2 && bl3 && !bl5) {
            bindingOperation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (bl3 && !bl2 && !bl4) {
            bindingOperation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_INVALID_OPERATION_STYLE(string));
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, bindingOperation);
        return bindingOperation;
    }

    private Import parseImport(TWSDLParserContextImpl tWSDLParserContextImpl, Definitions definitions, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        Import import_ = new Import(this.forest.locatorTable.getStartLocation(element));
        String string = Util.getRequiredAttribute(element, "namespace");
        import_.setNamespace(string);
        String string2 = Util.getRequiredAttribute(element, "location");
        import_.setLocation(string2);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                }
                bl = true;
                import_.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element2), WsdlMessages.PARSING_INVALID_ELEMENT(element2.getTagName(), element2.getNamespaceURI()));
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, import_);
        return import_;
    }

    private Service parseService(TWSDLParserContextImpl tWSDLParserContextImpl, Definitions definitions, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        Service service = new Service(definitions, this.forest.locatorTable.getStartLocation(element), this.errReceiver);
        String string = Util.getRequiredAttribute(element, "name");
        service.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                }
                bl = true;
                if (service.getDocumentation() != null) continue;
                service.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(tWSDLParserContextImpl, definitions, element2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(tWSDLParserContextImpl, service, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    private Port parsePort(TWSDLParserContextImpl tWSDLParserContextImpl, Definitions definitions, Element element) {
        Element element2;
        tWSDLParserContextImpl.push();
        tWSDLParserContextImpl.registerNamespaces(element);
        Port port = new Port(definitions, this.forest.locatorTable.getStartLocation(element), this.errReceiver);
        String string = Util.getRequiredAttribute(element, "name");
        port.setName(string);
        String string2 = Util.getRequiredAttribute(element, "binding");
        port.setBinding(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element), string2));
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(element.getLocalName()));
                }
                bl = true;
                if (port.getDocumentation() != null) continue;
                port.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(tWSDLParserContextImpl, port, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        tWSDLParserContextImpl.pop();
        tWSDLParserContextImpl.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    private void validateSchemaImports(Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, SchemaConstants.QNAME_IMPORT)) {
                this.errReceiver.warning(this.forest.locatorTable.getStartLocation(element2), WsdlMessages.WARNING_WSI_R_2003());
                continue;
            }
            this.checkNotWsdlElement(element2);
        }
    }

    private boolean handleExtension(TWSDLParserContextImpl tWSDLParserContextImpl, TWSDLExtensible tWSDLExtensible, Element element) {
        TWSDLExtensionHandler tWSDLExtensionHandler = (TWSDLExtensionHandler)this.extensionHandlers.get(element.getNamespaceURI());
        if (tWSDLExtensionHandler == null) {
            tWSDLParserContextImpl.fireIgnoringExtension(element, (Entity)((Object)tWSDLExtensible));
            return false;
        }
        return tWSDLExtensionHandler.doHandleExtension(tWSDLParserContextImpl, tWSDLExtensible, element);
    }

    private boolean handleExtension(TWSDLParserContextImpl tWSDLParserContextImpl, TWSDLExtensible tWSDLExtensible, Node node, Element element) {
        TWSDLExtensionHandler tWSDLExtensionHandler = (TWSDLExtensionHandler)this.extensionHandlers.get(node.getNamespaceURI());
        if (tWSDLExtensionHandler == null) {
            tWSDLParserContextImpl.fireIgnoringExtension(element, (Entity)((Object)tWSDLExtensible));
            return false;
        }
        return tWSDLExtensionHandler.doHandleExtension(tWSDLParserContextImpl, tWSDLExtensible, element);
    }

    private void checkNotWsdlElement(Element element) {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_INVALID_WSDL_ELEMENT(element.getTagName()));
        }
    }

    private void checkNotWsdlAttribute(Attr attr) {
        if (attr.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(attr.getOwnerElement()), WsdlMessages.PARSING_INVALID_WSDL_ELEMENT(attr.getLocalName()));
        }
    }

    private void checkNotWsdlRequired(Element element) {
        String string = XmlUtil.getAttributeNSOrNull((Element)element, (String)"required", (String)"http://schemas.xmlsoap.org/wsdl/");
        if (string != null && string.equals("true") && !this.options.isExtensionMode()) {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(element), WsdlMessages.PARSING_REQUIRED_EXTENSIBILITY_ELEMENT(element.getTagName(), element.getNamespaceURI()));
        }
    }

    private Documentation getDocumentationFor(Element element) {
        String string = XmlUtil.getTextForNode((Node)element);
        if (string == null) {
            return null;
        }
        return new Documentation(string);
    }
}

