/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.sun.istack.internal.tools.MaskingClassLoader;
import com.sun.istack.internal.tools.ParallelWorldClassLoader;
import com.sun.tools.internal.xjc.XJCFacade;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;

class ClassLoaderBuilder {
    private static String[] maskedPackages = new String[]{"com.sun.tools.", "com.sun.codemodel.internal.", "com.sun.relaxng.", "com.sun.xml.internal.xsom.", "com.sun.xml.internal.bind."};
    private static String[] toolPackages = new String[]{"com.sun.tools.", "com.sun.codemodel.internal.", "com.sun.relaxng.", "com.sun.xml.internal.xsom."};
    public static final boolean noHack = Boolean.getBoolean(XJCFacade.class.getName() + ".nohack");

    ClassLoaderBuilder() {
    }

    protected static ClassLoader createProtectiveClassLoader(ClassLoader classLoader, String string) throws ClassNotFoundException, MalformedURLException {
        if (noHack) {
            return classLoader;
        }
        boolean bl = false;
        if (JAXBContext.class.getClassLoader() == null) {
            bl = true;
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(maskedPackages));
            arrayList.add("javax.xml.bind.");
            classLoader = new MaskingClassLoader(classLoader, arrayList);
            URL uRL = classLoader.getResource("javax/xml/bind/annotation/XmlSeeAlso.class");
            if (uRL == null) {
                throw new ClassNotFoundException("There's no JAXB 2.1 API in the classpath");
            }
            classLoader = new URLClassLoader(new URL[]{ParallelWorldClassLoader.toJarUrl(uRL)}, classLoader);
        }
        if (string.equals("1.0")) {
            if (!bl) {
                classLoader = new MaskingClassLoader(classLoader, toolPackages);
            }
            classLoader = new ParallelWorldClassLoader(classLoader, "1.0/");
        } else if (bl) {
            classLoader = new ParallelWorldClassLoader(classLoader, "");
        }
        return classLoader;
    }
}

