/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.api.impl.s2j;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.SAXParseException2;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.ModelLoader;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.api.ClassNameAllocator;
import com.sun.tools.internal.xjc.api.ErrorListener;
import com.sun.tools.internal.xjc.api.SchemaCompiler;
import com.sun.tools.internal.xjc.api.SpecVersion;
import com.sun.tools.internal.xjc.api.impl.s2j.DowngradingErrorHandler;
import com.sun.tools.internal.xjc.api.impl.s2j.JAXBModelImpl;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.outline.Outline;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForest;
import com.sun.tools.internal.xjc.reader.internalizer.SCDBasedBindingSet;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.xsom.XSSchemaSet;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public final class SchemaCompilerImpl
extends ErrorReceiver
implements SchemaCompiler {
    private ErrorListener errorListener;
    protected final Options opts = new Options();
    @NotNull
    protected DOMForest forest;
    private boolean hadError;
    private static boolean NO_CORRECTNESS_CHECK = false;

    public SchemaCompilerImpl() {
        this.opts.compatibilityMode = 2;
        this.resetSchema();
        if (System.getProperty("xjc-api.test") != null) {
            this.opts.debugMode = true;
            this.opts.verbose = true;
        }
    }

    @NotNull
    public Options getOptions() {
        return this.opts;
    }

    public ContentHandler getParserHandler(String string) {
        return this.forest.getParserHandler(string, true);
    }

    public void parseSchema(String string, Element element) {
        this.checkAbsoluteness(string);
        try {
            DOMScanner dOMScanner = new DOMScanner();
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setSystemId(string);
            dOMScanner.setLocator((Locator)locatorImpl);
            dOMScanner.setContentHandler(this.getParserHandler(string));
            dOMScanner.scan(element);
        }
        catch (SAXException sAXException) {
            this.fatalError((SAXParseException)new SAXParseException2(sAXException.getMessage(), null, string, -1, -1, (Exception)sAXException));
        }
    }

    public void parseSchema(InputSource inputSource) {
        this.checkAbsoluteness(inputSource.getSystemId());
        try {
            this.forest.parse(inputSource, true);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void setTargetVersion(SpecVersion specVersion) {
        if (specVersion == null) {
            specVersion = SpecVersion.LATEST;
        }
        this.opts.target = specVersion;
    }

    public void parseSchema(String string, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.checkAbsoluteness(string);
        this.forest.parse(string, xMLStreamReader, true);
    }

    private void checkAbsoluteness(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("system ID '" + string + "' isn't absolute", uRISyntaxException);
            }
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.forest.setEntityResolver(entityResolver);
        this.opts.entityResolver = entityResolver;
    }

    public void setDefaultPackageName(String string) {
        this.opts.defaultPackage2 = string;
    }

    public void forcePackageName(String string) {
        this.opts.defaultPackage = string;
    }

    public void setClassNameAllocator(ClassNameAllocator classNameAllocator) {
        this.opts.classNameAllocator = classNameAllocator;
    }

    public void resetSchema() {
        this.forest = new DOMForest(new XMLSchemaInternalizationLogic());
        this.forest.setErrorHandler(this);
        this.forest.setEntityResolver(this.opts.entityResolver);
    }

    public JAXBModelImpl bind() {
        for (InputSource sAXException : this.opts.getBindFiles()) {
            this.parseSchema(sAXException);
        }
        SCDBasedBindingSet sCDBasedBindingSet = this.forest.transform(this.opts.isExtensionMode());
        if (!NO_CORRECTNESS_CHECK) {
            SchemaFactory jCodeModel = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            jCodeModel.setErrorHandler(new DowngradingErrorHandler(this));
            this.forest.weakSchemaCorrectnessCheck(jCodeModel);
            if (this.hadError) {
                return null;
            }
        }
        JCodeModel jCodeModel = new JCodeModel();
        ModelLoader modelLoader = new ModelLoader(this.opts, jCodeModel, this);
        try {
            XSSchemaSet xSSchemaSet = modelLoader.createXSOM(this.forest, sCDBasedBindingSet);
            if (xSSchemaSet == null) {
                return null;
            }
            Model model = modelLoader.annotateXMLSchema(xSSchemaSet);
            if (model == null) {
                return null;
            }
            if (this.hadError) {
                return null;
            }
            Outline outline = model.generateCode(this.opts, this);
            if (outline == null) {
                return null;
            }
            if (this.hadError) {
                return null;
            }
            return new JAXBModelImpl(outline);
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void info(SAXParseException sAXParseException) {
        if (this.errorListener != null) {
            this.errorListener.info(sAXParseException);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.errorListener != null) {
            this.errorListener.warning(sAXParseException);
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.hadError = true;
        if (this.errorListener != null) {
            this.errorListener.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.hadError = true;
        if (this.errorListener != null) {
            this.errorListener.fatalError(sAXParseException);
        }
    }

    static {
        try {
            NO_CORRECTNESS_CHECK = Boolean.getBoolean(SchemaCompilerImpl.class.getName() + ".noCorrectnessCheck");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

