/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.generator.bean;

import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JPackage;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlSchemaWriter;
import com.sun.tools.internal.xjc.generator.bean.BeanGenerator;
import com.sun.tools.internal.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.DualObjectFactoryGenerator;
import com.sun.tools.internal.xjc.generator.bean.ObjectFactoryGenerator;
import com.sun.tools.internal.xjc.generator.bean.PublicObjectFactoryGenerator;
import com.sun.tools.internal.xjc.model.CAttributePropertyInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CElement;
import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.CPropertyVisitor;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.CValuePropertyInfo;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.outline.Aspect;
import com.sun.tools.internal.xjc.outline.PackageOutline;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PackageOutlineImpl
implements PackageOutline {
    private final Model _model;
    private final JPackage _package;
    private final ObjectFactoryGenerator objectFactoryGenerator;
    final Set<ClassOutlineImpl> classes = new HashSet<ClassOutlineImpl>();
    private final Set<ClassOutlineImpl> classesView = Collections.unmodifiableSet(this.classes);
    private String mostUsedNamespaceURI;
    private XmlNsForm elementFormDefault;
    private HashMap<String, Integer> uriCountMap = new HashMap();
    private HashMap<String, Integer> propUriCountMap = new HashMap();

    @Override
    public String getMostUsedNamespaceURI() {
        return this.mostUsedNamespaceURI;
    }

    @Override
    public XmlNsForm getElementFormDefault() {
        assert (this.elementFormDefault != null);
        return this.elementFormDefault;
    }

    @Override
    public JPackage _package() {
        return this._package;
    }

    @Override
    public ObjectFactoryGenerator objectFactoryGenerator() {
        return this.objectFactoryGenerator;
    }

    public Set<ClassOutlineImpl> getClasses() {
        return this.classesView;
    }

    @Override
    public JDefinedClass objectFactory() {
        return this.objectFactoryGenerator.getObjectFactory();
    }

    protected PackageOutlineImpl(BeanGenerator beanGenerator, Model model, JPackage jPackage) {
        this._model = model;
        this._package = jPackage;
        switch (model.strategy) {
            case BEAN_ONLY: {
                this.objectFactoryGenerator = new PublicObjectFactoryGenerator(beanGenerator, model, jPackage);
                break;
            }
            case INTF_AND_IMPL: {
                this.objectFactoryGenerator = new DualObjectFactoryGenerator(beanGenerator, model, jPackage);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void calcDefaultValues() {
        if (!this._model.isPackageLevelAnnotations()) {
            this.mostUsedNamespaceURI = "";
            this.elementFormDefault = XmlNsForm.UNQUALIFIED;
            return;
        }
        CPropertyVisitor<Void> cPropertyVisitor = new CPropertyVisitor<Void>(){

            @Override
            public Void onElement(CElementPropertyInfo cElementPropertyInfo) {
                for (CTypeRef cTypeRef : cElementPropertyInfo.getTypes()) {
                    PackageOutlineImpl.this.countURI(PackageOutlineImpl.this.propUriCountMap, cTypeRef.getTagName());
                }
                return null;
            }

            @Override
            public Void onReference(CReferencePropertyInfo cReferencePropertyInfo) {
                for (CElement cElement : cReferencePropertyInfo.getElements()) {
                    PackageOutlineImpl.this.countURI(PackageOutlineImpl.this.propUriCountMap, cElement.getElementName());
                }
                return null;
            }

            @Override
            public Void onAttribute(CAttributePropertyInfo cAttributePropertyInfo) {
                return null;
            }

            @Override
            public Void onValue(CValuePropertyInfo cValuePropertyInfo) {
                return null;
            }
        };
        for (ClassOutlineImpl classOutlineImpl : this.classes) {
            CClassInfo cClassInfo = classOutlineImpl.target;
            this.countURI(this.uriCountMap, cClassInfo.getTypeName());
            this.countURI(this.uriCountMap, cClassInfo.getElementName());
            for (CPropertyInfo cPropertyInfo : cClassInfo.getProperties()) {
                cPropertyInfo.accept(cPropertyVisitor);
            }
        }
        this.mostUsedNamespaceURI = this.getMostUsedURI(this.uriCountMap);
        this.elementFormDefault = this.getFormDefault();
        if (!this.mostUsedNamespaceURI.equals("") || this.elementFormDefault == XmlNsForm.QUALIFIED) {
            XmlSchemaWriter xmlSchemaWriter = this._model.strategy.getPackage(this._package, Aspect.IMPLEMENTATION).annotate2(XmlSchemaWriter.class);
            if (!this.mostUsedNamespaceURI.equals("")) {
                xmlSchemaWriter.namespace(this.mostUsedNamespaceURI);
            }
            if (this.elementFormDefault == XmlNsForm.QUALIFIED) {
                xmlSchemaWriter.elementFormDefault(this.elementFormDefault);
            }
        }
    }

    private void countURI(HashMap<String, Integer> hashMap, QName qName) {
        if (qName == null) {
            return;
        }
        String string = qName.getNamespaceURI();
        if (hashMap.containsKey(string)) {
            hashMap.put(string, hashMap.get(string) + 1);
        } else {
            hashMap.put(string, 1);
        }
    }

    private String getMostUsedURI(HashMap<String, Integer> hashMap) {
        String string = null;
        int n = 0;
        for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
            String string2 = entry.getKey();
            int n2 = entry.getValue();
            if (string == null) {
                string = string2;
                n = n2;
                continue;
            }
            if (n2 <= n && (n2 != n || !string.equals(""))) continue;
            string = string2;
            n = n2;
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    private XmlNsForm getFormDefault() {
        if (this.getMostUsedURI(this.propUriCountMap).equals("")) {
            return XmlNsForm.UNQUALIFIED;
        }
        return XmlNsForm.QUALIFIED;
    }
}

