/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.reader.Messages;
import com.sun.tools.internal.xjc.util.SubtreeCutter;
import com.sun.xml.internal.bind.v2.util.EditDistance;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractExtensionBindingChecker
extends SubtreeCutter {
    protected final NamespaceSupport nsSupport = new NamespaceSupport();
    protected final Set<String> enabledExtensions = new HashSet<String>();
    private final Set<String> recognizableExtensions = new HashSet<String>();
    private Locator locator;
    protected final String schemaLanguage;
    protected final boolean allowExtensions;
    private final Options options;

    public AbstractExtensionBindingChecker(String string, Options options, ErrorHandler errorHandler) {
        this.schemaLanguage = string;
        this.allowExtensions = options.compatibilityMode != 1;
        this.options = options;
        this.setErrorHandler(errorHandler);
        for (Plugin plugin : options.getAllPlugins()) {
            this.recognizableExtensions.addAll(plugin.getCustomizationURIs());
        }
        this.recognizableExtensions.add("http://java.sun.com/xml/ns/jaxb/xjc");
    }

    protected final void checkAndEnable(String string) throws SAXException {
        if (!this.isRecognizableExtension(string)) {
            String string2 = EditDistance.findNearest((String)string, this.recognizableExtensions);
            this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(string, string2));
        } else if (!this.isSupportedExtension(string)) {
            Plugin plugin = null;
            for (Plugin plugin2 : this.options.getAllPlugins()) {
                if (!plugin2.getCustomizationURIs().contains(string)) continue;
                plugin = plugin2;
                break;
            }
            if (plugin != null) {
                this.error(Messages.ERR_PLUGIN_NOT_ENABLED.format(plugin.getOptionName(), string));
            } else {
                this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(string));
            }
        }
        this.enabledExtensions.add(string);
    }

    protected final void verifyTagName(String string, String string2, String string3) throws SAXException {
        if (this.options.pluginURIs.contains(string)) {
            boolean bl = false;
            for (Plugin plugin : this.options.activePlugins) {
                if (!plugin.isCustomizationTagName(string, string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.error(Messages.ERR_ILLEGAL_CUSTOMIZATION_TAGNAME.format(string3));
                this.startCutting();
            }
        }
    }

    protected final boolean isSupportedExtension(String string) {
        return string.equals("http://java.sun.com/xml/ns/jaxb/xjc") || this.options.pluginURIs.contains(string);
    }

    protected final boolean isRecognizableExtension(String string) {
        return this.recognizableExtensions.contains(string);
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.nsSupport.reset();
        this.enabledExtensions.clear();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.nsSupport.pushContext();
        this.nsSupport.declarePrefix(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.nsSupport.popContext();
    }

    protected final SAXParseException error(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this.locator);
        this.getErrorHandler().error(sAXParseException);
        return sAXParseException;
    }

    protected final void warning(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this.locator);
        this.getErrorHandler().warning(sAXParseException);
    }
}

