/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.reader.AbstractExtensionBindingChecker;
import com.sun.tools.internal.xjc.reader.Messages;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class ExtensionBindingChecker
extends AbstractExtensionBindingChecker {
    private int count = 0;

    public ExtensionBindingChecker(String string, Options options, ErrorHandler errorHandler) {
        super(string, options, errorHandler);
    }

    private boolean needsToBePruned(String string) {
        if (string.equals(this.schemaLanguage)) {
            return false;
        }
        if (string.equals("http://java.sun.com/xml/ns/jaxb")) {
            return false;
        }
        if (this.enabledExtensions.contains(string)) {
            return false;
        }
        return this.isRecognizableExtension(string);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.count = 0;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.isCutting()) {
            String string4 = attributes.getValue("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes");
            if (string4 != null) {
                if (this.count != 0) {
                    this.error(Messages.ERR_UNEXPECTED_EXTENSION_BINDING_PREFIXES.format(new Object[0]));
                }
                if (!this.allowExtensions) {
                    this.error(Messages.ERR_VENDOR_EXTENSION_DISALLOWED_IN_STRICT_MODE.format(new Object[0]));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    String string6 = this.nsSupport.getURI(string5);
                    if (string6 == null) {
                        this.error(Messages.ERR_UNDECLARED_PREFIX.format(string5));
                        continue;
                    }
                    this.checkAndEnable(string6);
                }
            }
            if (this.needsToBePruned(string)) {
                if (this.isRecognizableExtension(string)) {
                    this.warning(Messages.ERR_SUPPORTED_EXTENSION_IGNORED.format(string));
                }
                this.startCutting();
            } else {
                this.verifyTagName(string, string2, string3);
            }
        }
        ++this.count;
        super.startElement(string, string2, string3, attributes);
    }
}

