/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.Multiplicity;
import com.sun.xml.internal.bind.v2.model.core.ID;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RawTypeSet {
    public final Set<Ref> refs;
    public final Mode canBeTypeRefs;
    public final Multiplicity mul;
    private CElementPropertyInfo.CollectionMode collectionMode;

    public RawTypeSet(Set<Ref> set, Multiplicity multiplicity) {
        this.refs = set;
        this.mul = multiplicity;
        this.canBeTypeRefs = this.canBeTypeRefs();
    }

    public CElementPropertyInfo.CollectionMode getCollectionMode() {
        return this.collectionMode;
    }

    public boolean isRequired() {
        return this.mul.min > 0;
    }

    private Mode canBeTypeRefs() {
        HashSet<Object> hashSet = new HashSet<Object>();
        this.collectionMode = this.mul.isAtMostOnce() ? CElementPropertyInfo.CollectionMode.NOT_REPEATED : CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT;
        Mode mode = Mode.SHOULD_BE_TYPEREF;
        for (Ref ref : this.refs) {
            if ((mode = mode.or(ref.canBeType(this))) == Mode.MUST_BE_REFERENCE) {
                return mode;
            }
            if (!hashSet.add(ref.toTypeRef(null).getTarget().getType())) {
                return Mode.MUST_BE_REFERENCE;
            }
            if (!ref.isListOfValues()) continue;
            if (this.refs.size() > 1 || !this.mul.isAtMostOnce()) {
                return Mode.MUST_BE_REFERENCE;
            }
            this.collectionMode = CElementPropertyInfo.CollectionMode.REPEATED_VALUE;
        }
        return mode;
    }

    public void addTo(CElementPropertyInfo cElementPropertyInfo) {
        assert (this.canBeTypeRefs != Mode.MUST_BE_REFERENCE);
        if (this.mul.isZero()) {
            return;
        }
        List<CTypeRef> list = cElementPropertyInfo.getTypes();
        for (Ref ref : this.refs) {
            list.add(ref.toTypeRef(cElementPropertyInfo));
        }
    }

    public void addTo(CReferencePropertyInfo cReferencePropertyInfo) {
        if (this.mul.isZero()) {
            return;
        }
        for (Ref ref : this.refs) {
            ref.toElementRef(cReferencePropertyInfo);
        }
    }

    public ID id() {
        for (Ref ref : this.refs) {
            ID iD = ref.id();
            if (iD == ID.NONE) continue;
            return iD;
        }
        return ID.NONE;
    }

    public MimeType getExpectedMimeType() {
        for (Ref ref : this.refs) {
            MimeType mimeType = ref.getExpectedMimeType();
            if (mimeType == null) continue;
            return mimeType;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SHOULD_BE_TYPEREF(0),
        CAN_BE_TYPEREF(1),
        MUST_BE_REFERENCE(2);

        private final int rank;

        private Mode(int n2) {
            this.rank = n2;
        }

        Mode or(Mode mode) {
            switch (Math.max(this.rank, mode.rank)) {
                case 0: {
                    return SHOULD_BE_TYPEREF;
                }
                case 1: {
                    return CAN_BE_TYPEREF;
                }
                case 2: {
                    return MUST_BE_REFERENCE;
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class Ref {
        protected abstract CTypeRef toTypeRef(CElementPropertyInfo var1);

        protected abstract void toElementRef(CReferencePropertyInfo var1);

        protected abstract Mode canBeType(RawTypeSet var1);

        protected abstract boolean isListOfValues();

        protected abstract ID id();

        protected MimeType getExpectedMimeType() {
            return null;
        }
    }
}

