/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.tools.internal.xjc.model.CAdapter;
import com.sun.tools.internal.xjc.model.CClass;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CCustomizations;
import com.sun.tools.internal.xjc.model.CElement;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.Multiplicity;
import com.sun.tools.internal.xjc.model.TypeUse;
import com.sun.tools.internal.xjc.reader.RawTypeSet;
import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.internal.xjc.reader.xmlschema.MultiplicityCounter;
import com.sun.tools.internal.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIDom;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIGlobalBinding;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIXSubstitutable;
import com.sun.xml.internal.bind.v2.model.core.ID;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.visitor.XSTermVisitor;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimeType;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawTypeSetBuilder
implements XSTermVisitor {
    private final Set<QName> elementNames = new HashSet<QName>();
    private final Set<RawTypeSet.Ref> refs = new HashSet<RawTypeSet.Ref>();
    protected final BGMBuilder builder = Ring.get(BGMBuilder.class);

    public static RawTypeSet build(XSParticle xSParticle, boolean bl) {
        RawTypeSetBuilder rawTypeSetBuilder = new RawTypeSetBuilder();
        rawTypeSetBuilder.particle(xSParticle);
        Multiplicity multiplicity = MultiplicityCounter.theInstance.particle(xSParticle);
        if (bl) {
            multiplicity = multiplicity.makeOptional();
        }
        return new RawTypeSet(rawTypeSetBuilder.refs, multiplicity);
    }

    public Set<RawTypeSet.Ref> getRefs() {
        return this.refs;
    }

    private void particle(XSParticle xSParticle) {
        BIDom bIDom = this.builder.getLocalDomCustomization(xSParticle);
        if (bIDom != null) {
            bIDom.markAsAcknowledged();
            this.refs.add(new WildcardRef(WildcardMode.SKIP));
        } else {
            xSParticle.getTerm().visit(this);
        }
    }

    @Override
    public void wildcard(XSWildcard xSWildcard) {
        this.refs.add(new WildcardRef(xSWildcard));
    }

    @Override
    public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
        this.modelGroup(xSModelGroupDecl.getModelGroup());
    }

    @Override
    public void modelGroup(XSModelGroup xSModelGroup) {
        for (XSParticle xSParticle : xSModelGroup.getChildren()) {
            this.particle(xSParticle);
        }
    }

    @Override
    public void elementDecl(XSElementDecl xSElementDecl) {
        QName qName = BGMBuilder.getName(xSElementDecl);
        if (this.elementNames.add(qName)) {
            CElement cElement = Ring.get(ClassSelector.class).bindToType(xSElementDecl, null);
            if (cElement == null) {
                this.refs.add(new XmlTypeRef(xSElementDecl));
            } else if (cElement instanceof CClass) {
                this.refs.add(new CClassRef(xSElementDecl, (CClass)cElement));
            } else {
                this.refs.add(new CElementInfoRef(xSElementDecl, (CElementInfo)cElement));
            }
        }
    }

    public static final class CClassRef
    extends RawTypeSet.Ref {
        public final CClass target;
        public final XSElementDecl decl;

        CClassRef(XSElementDecl xSElementDecl, CClass cClass) {
            this.decl = xSElementDecl;
            this.target = cClass;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            return new CTypeRef(this.target, this.decl);
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            cReferencePropertyInfo.getElements().add(this.target);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            if (this.decl.getSubstitutables().size() > 1) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return false;
        }

        protected ID id() {
            return ID.NONE;
        }
    }

    public final class CElementInfoRef
    extends RawTypeSet.Ref {
        public final CElementInfo target;
        public final XSElementDecl decl;

        CElementInfoRef(XSElementDecl xSElementDecl, CElementInfo cElementInfo) {
            this.decl = xSElementDecl;
            this.target = cElementInfo;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            assert (!this.target.isCollection());
            CAdapter cAdapter = this.target.getProperty().getAdapter();
            if (cAdapter != null && cElementPropertyInfo != null) {
                cElementPropertyInfo.setAdapter(cAdapter);
            }
            return new CTypeRef(this.target.getContentType(), this.decl);
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            cReferencePropertyInfo.getElements().add(this.target);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            if (this.decl.getSubstitutables().size() > 1) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            BIXSubstitutable bIXSubstitutable = RawTypeSetBuilder.this.builder.getBindInfo(this.decl).get(BIXSubstitutable.class);
            if (bIXSubstitutable != null) {
                bIXSubstitutable.markAsAcknowledged();
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            CElementPropertyInfo cElementPropertyInfo = this.target.getProperty();
            if (!(rawTypeSet.refs.size() <= 1 && rawTypeSet.mul.isAtMostOnce() || cElementPropertyInfo.id() == ID.NONE)) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            if (rawTypeSet.refs.size() > 1 && cElementPropertyInfo.getAdapter() != null) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            if (this.target.hasClass()) {
                return RawTypeSet.Mode.CAN_BE_TYPEREF;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return this.target.getProperty().isValueList();
        }

        protected ID id() {
            return this.target.getProperty().id();
        }

        protected MimeType getExpectedMimeType() {
            return this.target.getProperty().getExpectedMimeType();
        }
    }

    public static final class WildcardRef
    extends RawTypeSet.Ref {
        private final WildcardMode mode;

        WildcardRef(XSWildcard xSWildcard) {
            this.mode = WildcardRef.getMode(xSWildcard);
        }

        WildcardRef(WildcardMode wildcardMode) {
            this.mode = wildcardMode;
        }

        private static WildcardMode getMode(XSWildcard xSWildcard) {
            switch (xSWildcard.getMode()) {
                case 1: {
                    return WildcardMode.LAX;
                }
                case 2: {
                    return WildcardMode.STRICT;
                }
                case 3: {
                    return WildcardMode.SKIP;
                }
            }
            throw new IllegalStateException();
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            throw new IllegalStateException();
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            cReferencePropertyInfo.setWildcard(this.mode);
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            return RawTypeSet.Mode.MUST_BE_REFERENCE;
        }

        protected boolean isListOfValues() {
            return false;
        }

        protected ID id() {
            return ID.NONE;
        }
    }

    public static final class XmlTypeRef
    extends RawTypeSet.Ref {
        private final XSElementDecl decl;
        private final TypeUse target;

        public XmlTypeRef(XSElementDecl xSElementDecl) {
            this.decl = xSElementDecl;
            SimpleTypeBuilder simpleTypeBuilder = Ring.get(SimpleTypeBuilder.class);
            simpleTypeBuilder.refererStack.push(xSElementDecl);
            TypeUse typeUse = Ring.get(ClassSelector.class).bindToType(xSElementDecl.getType(), (XSComponent)xSElementDecl);
            simpleTypeBuilder.refererStack.pop();
            this.target = typeUse;
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            if (cElementPropertyInfo != null && this.target.getAdapterUse() != null) {
                cElementPropertyInfo.setAdapter(this.target.getAdapterUse());
            }
            return new CTypeRef(this.target.getInfo(), this.decl);
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            CClassInfo cClassInfo = Ring.get(ClassSelector.class).getCurrentBean();
            Model model = Ring.get(Model.class);
            CCustomizations cCustomizations = Ring.get(BGMBuilder.class).getBindInfo(this.decl).toCustomizationList();
            if (this.target instanceof CClassInfo && Ring.get(BIGlobalBinding.class).isSimpleMode()) {
                CClassInfo cClassInfo2 = new CClassInfo(model, cClassInfo, model.getNameConverter().toClassName(this.decl.getName()), this.decl.getLocator(), null, BGMBuilder.getName(this.decl), (XSComponent)this.decl, cCustomizations);
                cClassInfo2.setBaseClass((CClassInfo)this.target);
                cReferencePropertyInfo.getElements().add(cClassInfo2);
            } else {
                CElementInfo cElementInfo = new CElementInfo(model, BGMBuilder.getName(this.decl), cClassInfo, this.target, this.decl.getDefaultValue(), this.decl, cCustomizations, this.decl.getLocator());
                cReferencePropertyInfo.getElements().add(cElementInfo);
            }
        }

        protected RawTypeSet.Mode canBeType(RawTypeSet rawTypeSet) {
            if (!(rawTypeSet.refs.size() <= 1 && rawTypeSet.mul.isAtMostOnce() || this.target.idUse() == ID.NONE)) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            if (rawTypeSet.refs.size() > 1 && this.target.getAdapterUse() != null) {
                return RawTypeSet.Mode.MUST_BE_REFERENCE;
            }
            if (this.decl.isNillable() && rawTypeSet.mul.isOptional()) {
                return RawTypeSet.Mode.CAN_BE_TYPEREF;
            }
            return RawTypeSet.Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return this.target.isCollection();
        }

        protected ID id() {
            return this.target.idUse();
        }

        protected MimeType getExpectedMimeType() {
            return this.target.getExpectedMimeType();
        }
    }
}

