/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Version;
import java.util.Random;

@Version(value="@(#)Bits.java\t1.21 10/03/23")
public class Bits {
    private static final int wordlen = 32;
    private static final int wordshift = 5;
    private static final int wordmask = 31;
    private int[] bits;

    public Bits() {
        this(new int[1]);
    }

    public Bits(int[] nArray) {
        this.bits = nArray;
    }

    public Bits(int n, int n2) {
        this();
        this.inclRange(n, n2);
    }

    private void sizeTo(int n) {
        if (this.bits.length < n) {
            int[] nArray = new int[n];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public Bits dup() {
        int[] nArray = new int[this.bits.length];
        System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
        return new Bits(nArray);
    }

    public void incl(int n) {
        assert (n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] | 1 << (n & 0x1F);
    }

    public void inclRange(int n, int n2) {
        this.sizeTo((n2 >>> 5) + 1);
        for (int i = n; i < n2; ++i) {
            this.bits[i >>> 5] = this.bits[i >>> 5] | 1 << (i & 0x1F);
        }
    }

    public void excl(int n) {
        assert (n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] & ~(1 << (n & 0x1F));
    }

    public boolean isMember(int n) {
        return 0 <= n && n < this.bits.length << 5 && (this.bits[n >>> 5] & 1 << (n & 0x1F)) != 0;
    }

    public Bits andSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] & bits.bits[i];
        }
        return this;
    }

    public Bits orSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] | bits.bits[i];
        }
        return this;
    }

    public Bits diffSet(Bits bits) {
        for (int i = 0; i < this.bits.length; ++i) {
            if (i >= bits.bits.length) continue;
            this.bits[i] = this.bits[i] & ~bits.bits[i];
        }
        return this;
    }

    public Bits xorSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] ^ bits.bits[i];
        }
        return this;
    }

    private static int trailingZeroBits(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if ((n & 0xFFFF) == 0) {
            n2 += 16;
            n >>>= 16;
        }
        if ((n & 0xFF) == 0) {
            n2 += 8;
            n >>>= 8;
        }
        if ((n & 0xF) == 0) {
            n2 += 4;
            n >>>= 4;
        }
        if ((n & 3) == 0) {
            n2 += 2;
            n >>>= 2;
        }
        return n2 - (n & 1);
    }

    public int nextBit(int n) {
        int n2 = n >>> 5;
        if (n2 >= this.bits.length) {
            return -1;
        }
        int n3 = this.bits[n2] & ~((1 << (n & 0x1F)) - 1);
        while (n3 == 0) {
            if (++n2 >= this.bits.length) {
                return -1;
            }
            n3 = this.bits[n2];
        }
        return (n2 << 5) + Bits.trailingZeroBits(n3);
    }

    public String toString() {
        char[] cArray = new char[this.bits.length * 32];
        for (int i = 0; i < this.bits.length * 32; ++i) {
            cArray[i] = this.isMember(i) ? 49 : 48;
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Random random = new Random();
        Bits bits = new Bits();
        boolean bl = false;
        for (n2 = 0; n2 < 125; ++n2) {
            while (bits.isMember(n = random.nextInt(250))) {
            }
            System.out.println("adding " + n);
            bits.incl(n);
        }
        n2 = 0;
        n = bits.nextBit(0);
        while (n >= 0) {
            System.out.println("found " + n);
            ++n2;
            n = bits.nextBit(n + 1);
        }
        if (n2 != 125) {
            throw new Error();
        }
    }
}

