/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.JDIPermission;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.GenericAttachingConnector;
import com.sun.tools.jdi.GenericListeningConnector;
import com.sun.tools.jdi.VirtualMachineImpl;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import sun.misc.Service;

public class VirtualMachineManagerImpl
implements VirtualMachineManagerService {
    private List connectors = new ArrayList();
    private LaunchingConnector defaultConnector = null;
    private List targets = new ArrayList();
    private List connectionListeners = new ArrayList();
    private final ThreadGroup mainGroupForJDI;
    private ResourceBundle messages = null;
    private int vmSequenceNumber = 0;
    private static final int majorVersion = 1;
    private static final int minorVersion = 6;
    private static final Object lock = new Object();
    private static VirtualMachineManagerImpl vmm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualMachineManager virtualMachineManager() {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new JDIPermission("virtualMachineManager");
            securityManager.checkPermission((Permission)object);
        }
        object = lock;
        synchronized (object) {
            if (vmm == null) {
                vmm = new VirtualMachineManagerImpl();
            }
        }
        return vmm;
    }

    protected VirtualMachineManagerImpl() {
        Object object;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = null;
        while ((threadGroup2 = threadGroup.getParent()) != null) {
            threadGroup = threadGroup2;
        }
        this.mainGroupForJDI = new ThreadGroup(threadGroup, "JDI main");
        Iterator iterator = Service.providers(Connector.class, (ClassLoader)Connector.class.getClassLoader());
        while (iterator.hasNext()) {
            try {
                object = (Connector)iterator.next();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                System.err.println(exception);
                continue;
            }
            catch (Error error) {
                System.err.println(error);
                continue;
            }
            this.addConnector((Connector)object);
        }
        object = Service.providers(TransportService.class, (ClassLoader)TransportService.class.getClassLoader());
        while (object.hasNext()) {
            TransportService transportService;
            try {
                transportService = (TransportService)object.next();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                System.err.println(exception);
                continue;
            }
            catch (Error error) {
                System.err.println(error);
                continue;
            }
            this.addConnector(GenericAttachingConnector.create(transportService));
            this.addConnector(GenericListeningConnector.create(transportService));
        }
        if (this.allConnectors().size() == 0) {
            throw new Error("no Connectors loaded");
        }
        boolean bl = false;
        List list = this.launchingConnectors();
        for (LaunchingConnector launchingConnector : list) {
            if (!launchingConnector.name().equals("com.sun.jdi.CommandLineLaunch")) continue;
            this.setDefaultConnector(launchingConnector);
            bl = true;
            break;
        }
        if (!bl && list.size() > 0) {
            this.setDefaultConnector((LaunchingConnector)list.get(0));
        }
    }

    public LaunchingConnector defaultConnector() {
        if (this.defaultConnector == null) {
            throw new Error("no default LaunchingConnector");
        }
        return this.defaultConnector;
    }

    public void setDefaultConnector(LaunchingConnector launchingConnector) {
        this.defaultConnector = launchingConnector;
    }

    public List launchingConnectors() {
        ArrayList arrayList = new ArrayList(this.connectors.size());
        for (Object e : this.connectors) {
            if (!(e instanceof LaunchingConnector)) continue;
            arrayList.add(e);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List attachingConnectors() {
        ArrayList arrayList = new ArrayList(this.connectors.size());
        for (Object e : this.connectors) {
            if (!(e instanceof AttachingConnector)) continue;
            arrayList.add(e);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List listeningConnectors() {
        ArrayList arrayList = new ArrayList(this.connectors.size());
        for (Object e : this.connectors) {
            if (!(e instanceof ListeningConnector)) continue;
            arrayList.add(e);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List allConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public List connectedVirtualMachines() {
        return Collections.unmodifiableList(this.targets);
    }

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    public synchronized VirtualMachine createVirtualMachine(Connection connection, Process process) throws IOException {
        VirtualMachineImpl virtualMachineImpl;
        if (!connection.isOpen()) {
            throw new IllegalStateException("connection is not open");
        }
        try {
            virtualMachineImpl = new VirtualMachineImpl(this, connection, process, ++this.vmSequenceNumber);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new IOException(vMDisconnectedException.getMessage());
        }
        this.targets.add(virtualMachineImpl);
        return virtualMachineImpl;
    }

    public VirtualMachine createVirtualMachine(Connection connection) throws IOException {
        return this.createVirtualMachine(connection, null);
    }

    public void addVirtualMachine(VirtualMachine virtualMachine) {
        this.targets.add(virtualMachine);
    }

    void disposeVirtualMachine(VirtualMachine virtualMachine) {
        this.targets.remove(virtualMachine);
    }

    public int majorInterfaceVersion() {
        return 1;
    }

    public int minorInterfaceVersion() {
        return 6;
    }

    ThreadGroup mainGroupForJDI() {
        return this.mainGroupForJDI;
    }

    String getString(String string) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi");
        }
        return this.messages.getString(string);
    }
}

