/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.scd;

import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSDeclaration;
import com.sun.xml.internal.xsom.XSFacet;
import com.sun.xml.internal.xsom.XSSchema;
import com.sun.xml.internal.xsom.XSType;
import com.sun.xml.internal.xsom.impl.UName;
import com.sun.xml.internal.xsom.impl.scd.Axis;
import com.sun.xml.internal.xsom.impl.scd.Iterators;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Step<T extends XSComponent> {
    public final Axis<? extends T> axis;
    int predicate = -1;

    protected Step(Axis<? extends T> axis) {
        this.axis = axis;
    }

    protected abstract Iterator<? extends T> filter(Iterator<? extends T> var1);

    public final Iterator<T> evaluate(Iterator<XSComponent> iterator) {
        Iterators.ReadOnly readOnly = new Iterators.Map<T, XSComponent>(iterator){

            @Override
            protected Iterator<? extends T> apply(XSComponent xSComponent) {
                return Step.this.filter(Step.this.axis.iterator(xSComponent));
            }
        };
        readOnly = new Iterators.Unique(readOnly);
        if (this.predicate >= 0) {
            XSComponent xSComponent = null;
            for (int i = this.predicate; i > 0; --i) {
                if (!readOnly.hasNext()) {
                    return Iterators.empty();
                }
                xSComponent = (XSComponent)readOnly.next();
            }
            return new Iterators.Singleton<Object>(xSComponent);
        }
        return readOnly;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AnonymousType
    extends Filtered<XSType> {
        public AnonymousType(Axis<? extends XSType> axis) {
            super(axis);
        }

        @Override
        protected boolean match(XSType xSType) {
            return xSType.isLocal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Any
    extends Step<XSComponent> {
        public Any(Axis<? extends XSComponent> axis) {
            super(axis);
        }

        @Override
        protected Iterator<? extends XSComponent> filter(Iterator<? extends XSComponent> iterator) {
            return iterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Facet
    extends Filtered<XSFacet> {
        private final String name;

        public Facet(Axis<XSFacet> axis, String string) {
            super(axis);
            this.name = string;
        }

        @Override
        protected boolean match(XSFacet xSFacet) {
            return xSFacet.getName().equals(this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Filtered<T extends XSComponent>
    extends Step<T> {
        protected Filtered(Axis<? extends T> axis) {
            super(axis);
        }

        @Override
        protected Iterator<T> filter(Iterator<? extends T> iterator) {
            return new Iterators.Filter<T>(iterator){

                @Override
                protected boolean matches(T t) {
                    return Filtered.this.match(t);
                }
            };
        }

        protected abstract boolean match(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Named
    extends Filtered<XSDeclaration> {
        private final String nsUri;
        private final String localName;

        public Named(Axis<? extends XSDeclaration> axis, UName uName) {
            this(axis, uName.getNamespaceURI(), uName.getName());
        }

        public Named(Axis<? extends XSDeclaration> axis, String string, String string2) {
            super(axis);
            this.nsUri = string;
            this.localName = string2;
        }

        @Override
        protected boolean match(XSDeclaration xSDeclaration) {
            return xSDeclaration.getName().equals(this.localName) && xSDeclaration.getTargetNamespace().equals(this.nsUri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Schema
    extends Filtered<XSSchema> {
        private final String uri;

        public Schema(Axis<XSSchema> axis, String string) {
            super(axis);
            this.uri = string;
        }

        @Override
        protected boolean match(XSSchema xSSchema) {
            return xSSchema.getTargetNamespace().equals(this.uri);
        }
    }
}

