/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.util;

import com.sun.xml.internal.xsom.XSAnnotation;
import com.sun.xml.internal.xsom.XSAttGroupDecl;
import com.sun.xml.internal.xsom.XSAttributeDecl;
import com.sun.xml.internal.xsom.XSAttributeUse;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSContentType;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSFacet;
import com.sun.xml.internal.xsom.XSIdentityConstraint;
import com.sun.xml.internal.xsom.XSListSimpleType;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSNotation;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSRestrictionSimpleType;
import com.sun.xml.internal.xsom.XSSchema;
import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSType;
import com.sun.xml.internal.xsom.XSUnionSimpleType;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.XSXPath;
import com.sun.xml.internal.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.internal.xsom.visitor.XSTermVisitor;
import com.sun.xml.internal.xsom.visitor.XSVisitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xml.sax.Locator;

public class SchemaTreeTraverser
implements XSVisitor,
XSSimpleTypeVisitor {
    private SchemaTreeModel model = SchemaTreeModel.getInstance();
    private SchemaTreeNode currNode = (SchemaTreeNode)this.model.getRoot();

    public SchemaTreeModel getModel() {
        return this.model;
    }

    public void visit(XSSchemaSet xSSchemaSet) {
        for (XSSchema xSSchema : xSSchemaSet.getSchemas()) {
            this.schema(xSSchema);
        }
    }

    public void schema(XSSchema xSSchema) {
        SchemaTreeNode schemaTreeNode;
        if (xSSchema.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        this.currNode = schemaTreeNode = new SchemaTreeNode("Schema " + xSSchema.getLocator().getSystemId(), xSSchema.getLocator());
        this.model.addSchemaNode(schemaTreeNode);
        for (XSAttGroupDecl xSDeclaration : xSSchema.getAttGroupDecls().values()) {
            this.attGroupDecl(xSDeclaration);
        }
        for (XSAttributeDecl xSAttributeDecl : xSSchema.getAttributeDecls().values()) {
            this.attributeDecl(xSAttributeDecl);
        }
        for (XSComplexType xSComplexType : xSSchema.getComplexTypes().values()) {
            this.complexType(xSComplexType);
        }
        for (XSElementDecl xSElementDecl : xSSchema.getElementDecls().values()) {
            this.elementDecl(xSElementDecl);
        }
        for (XSModelGroupDecl xSModelGroupDecl : xSSchema.getModelGroupDecls().values()) {
            this.modelGroupDecl(xSModelGroupDecl);
        }
        for (XSSimpleType xSSimpleType : xSSchema.getSimpleTypes().values()) {
            this.simpleType(xSSimpleType);
        }
    }

    public void attGroupDecl(XSAttGroupDecl xSAttGroupDecl) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode("Attribute group \"" + xSAttGroupDecl.getName() + "\"", xSAttGroupDecl.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        Iterator<XSComponent> iterator = xSAttGroupDecl.iterateAttGroups();
        while (iterator.hasNext()) {
            this.dumpRef(iterator.next());
        }
        iterator = xSAttGroupDecl.iterateDeclaredAttributeUses();
        while (iterator.hasNext()) {
            this.attributeUse((XSAttributeUse)iterator.next());
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void dumpRef(XSAttGroupDecl xSAttGroupDecl) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode("Attribute group ref \"{" + xSAttGroupDecl.getTargetNamespace() + "}" + xSAttGroupDecl.getName() + "\"", xSAttGroupDecl.getLocator());
        this.currNode.add(schemaTreeNode);
    }

    public void attributeUse(XSAttributeUse xSAttributeUse) {
        XSAttributeDecl xSAttributeDecl = xSAttributeUse.getDecl();
        String string = "";
        if (xSAttributeUse.isRequired()) {
            string = string + " use=\"required\"";
        }
        if (xSAttributeUse.getFixedValue() != null && xSAttributeUse.getDecl().getFixedValue() == null) {
            string = string + " fixed=\"" + xSAttributeUse.getFixedValue() + "\"";
        }
        if (xSAttributeUse.getDefaultValue() != null && xSAttributeUse.getDecl().getDefaultValue() == null) {
            string = string + " default=\"" + xSAttributeUse.getDefaultValue() + "\"";
        }
        if (xSAttributeDecl.isLocal()) {
            this.dump(xSAttributeDecl, string);
        } else {
            String string2 = MessageFormat.format("Attribute ref \"'{'{0}'}'{1}{2}\"", xSAttributeDecl.getTargetNamespace(), xSAttributeDecl.getName(), string);
            SchemaTreeNode schemaTreeNode = new SchemaTreeNode(string2, xSAttributeDecl.getLocator());
            this.currNode.add(schemaTreeNode);
        }
    }

    public void attributeDecl(XSAttributeDecl xSAttributeDecl) {
        this.dump(xSAttributeDecl, "");
    }

    private void dump(XSAttributeDecl xSAttributeDecl, String string) {
        XSSimpleType xSSimpleType = xSAttributeDecl.getType();
        String string2 = MessageFormat.format("Attribute \"{0}\"{1}{2}{3}{4}", xSAttributeDecl.getName(), string, xSSimpleType.isLocal() ? "" : MessageFormat.format(" type=\"'{'{0}'}'{1}\"", xSSimpleType.getTargetNamespace(), xSSimpleType.getName()), xSAttributeDecl.getFixedValue() == null ? "" : " fixed=\"" + xSAttributeDecl.getFixedValue() + "\"", xSAttributeDecl.getDefaultValue() == null ? "" : " default=\"" + xSAttributeDecl.getDefaultValue() + "\"");
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(string2, xSAttributeDecl.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        if (xSSimpleType.isLocal()) {
            this.simpleType(xSSimpleType);
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void simpleType(XSSimpleType xSSimpleType) {
        String string = MessageFormat.format("Simple type {0}", xSSimpleType.isLocal() ? "" : " name=\"" + xSSimpleType.getName() + "\"");
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(string, xSSimpleType.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        xSSimpleType.visit(this);
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void listSimpleType(XSListSimpleType xSListSimpleType) {
        XSSimpleType xSSimpleType = xSListSimpleType.getItemType();
        if (xSSimpleType.isLocal()) {
            SchemaTreeNode schemaTreeNode = new SchemaTreeNode("List", xSListSimpleType.getLocator());
            this.currNode.add(schemaTreeNode);
            this.currNode = schemaTreeNode;
            this.simpleType(xSSimpleType);
            this.currNode = (SchemaTreeNode)this.currNode.getParent();
        } else {
            String string = MessageFormat.format("List itemType=\"'{'{0}'}'{1}\"", xSSimpleType.getTargetNamespace(), xSSimpleType.getName());
            SchemaTreeNode schemaTreeNode = new SchemaTreeNode(string, xSSimpleType.getLocator());
            this.currNode.add(schemaTreeNode);
        }
    }

    public void unionSimpleType(XSUnionSimpleType xSUnionSimpleType) {
        Object object;
        int n = xSUnionSimpleType.getMemberSize();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            object = xSUnionSimpleType.getMember(i);
            if (!object.isGlobal()) continue;
            stringBuffer.append(MessageFormat.format(" '{'{0}'}'{1}", object.getTargetNamespace(), object.getName()));
        }
        String string = stringBuffer.length() == 0 ? "Union" : "Union memberTypes=\"" + stringBuffer + "\"";
        object = new SchemaTreeNode(string, xSUnionSimpleType.getLocator());
        this.currNode.add((MutableTreeNode)object);
        this.currNode = object;
        for (int i = 0; i < n; ++i) {
            XSSimpleType xSSimpleType = xSUnionSimpleType.getMember(i);
            if (!xSSimpleType.isLocal()) continue;
            this.simpleType(xSSimpleType);
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void restrictionSimpleType(XSRestrictionSimpleType xSRestrictionSimpleType) {
        if (xSRestrictionSimpleType.getBaseType() == null) {
            if (!xSRestrictionSimpleType.getName().equals("anySimpleType")) {
                throw new InternalError();
            }
            if (!"http://www.w3.org/2001/XMLSchema".equals(xSRestrictionSimpleType.getTargetNamespace())) {
                throw new InternalError();
            }
            return;
        }
        XSSimpleType xSSimpleType = xSRestrictionSimpleType.getSimpleBaseType();
        String string = MessageFormat.format("Restriction {0}", xSSimpleType.isLocal() ? "" : " base=\"{" + xSSimpleType.getTargetNamespace() + "}" + xSSimpleType.getName() + "\"");
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(string, xSSimpleType.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        if (xSSimpleType.isLocal()) {
            this.simpleType(xSSimpleType);
        }
        Iterator<XSFacet> iterator = xSRestrictionSimpleType.iterateDeclaredFacets();
        while (iterator.hasNext()) {
            this.facet(iterator.next());
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void facet(XSFacet xSFacet) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("{0} value=\"{1}\"", xSFacet.getName(), xSFacet.getValue()), xSFacet.getLocator());
        this.currNode.add(schemaTreeNode);
    }

    public void notation(XSNotation xSNotation) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("Notation name='\"0}\" public =\"{1}\" system=\"{2}\"", xSNotation.getName(), xSNotation.getPublicId(), xSNotation.getSystemId()), xSNotation.getLocator());
        this.currNode.add(schemaTreeNode);
    }

    public void complexType(XSComplexType xSComplexType) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("ComplexType {0}", xSComplexType.isLocal() ? "" : " name=\"" + xSComplexType.getName() + "\""), xSComplexType.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        if (xSComplexType.getContentType().asSimpleType() != null) {
            SchemaTreeNode schemaTreeNode2 = new SchemaTreeNode("Simple content", xSComplexType.getContentType().getLocator());
            this.currNode.add(schemaTreeNode2);
            this.currNode = schemaTreeNode2;
            XSType xSType = xSComplexType.getBaseType();
            if (xSComplexType.getDerivationMethod() == 2) {
                String string = MessageFormat.format("Restriction base=\"<{0}>{1}\"", xSType.getTargetNamespace(), xSType.getName());
                SchemaTreeNode schemaTreeNode3 = new SchemaTreeNode(string, xSType.getLocator());
                this.currNode.add(schemaTreeNode3);
                this.currNode = schemaTreeNode3;
                this.dumpComplexTypeAttribute(xSComplexType);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            } else {
                String string = MessageFormat.format("Extension base=\"<{0}>{1}\"", xSType.getTargetNamespace(), xSType.getName());
                SchemaTreeNode schemaTreeNode4 = new SchemaTreeNode(string, xSType.getLocator());
                this.currNode.add(schemaTreeNode4);
                this.currNode = schemaTreeNode4;
                if (xSComplexType.getTargetNamespace().compareTo(xSType.getTargetNamespace()) == 0 && xSComplexType.getName().compareTo(xSType.getName()) == 0) {
                    SchemaTreeNode schemaTreeNode5 = new SchemaTreeNode("redefine", xSComplexType.getLocator());
                    this.currNode.add(schemaTreeNode5);
                    this.currNode = schemaTreeNode5;
                    xSType.visit(this);
                    this.currNode = (SchemaTreeNode)schemaTreeNode5.getParent();
                }
                this.dumpComplexTypeAttribute(xSComplexType);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            }
            this.currNode = (SchemaTreeNode)this.currNode.getParent();
        } else {
            SchemaTreeNode schemaTreeNode6 = new SchemaTreeNode("Complex content", xSComplexType.getContentType().getLocator());
            this.currNode.add(schemaTreeNode6);
            this.currNode = schemaTreeNode6;
            XSComplexType xSComplexType2 = xSComplexType.getBaseType().asComplexType();
            if (xSComplexType.getDerivationMethod() == 2) {
                String string = MessageFormat.format("Restriction base=\"<{0}>{1}\"", xSComplexType2.getTargetNamespace(), xSComplexType2.getName());
                SchemaTreeNode schemaTreeNode7 = new SchemaTreeNode(string, xSComplexType2.getLocator());
                this.currNode.add(schemaTreeNode7);
                this.currNode = schemaTreeNode7;
                xSComplexType.getContentType().visit(this);
                this.dumpComplexTypeAttribute(xSComplexType);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            } else {
                String string = MessageFormat.format("Extension base=\"'{'{0}'}'{1}\"", xSComplexType2.getTargetNamespace(), xSComplexType2.getName());
                SchemaTreeNode schemaTreeNode8 = new SchemaTreeNode(string, xSComplexType2.getLocator());
                this.currNode.add(schemaTreeNode8);
                this.currNode = schemaTreeNode8;
                if (xSComplexType.getTargetNamespace().compareTo(xSComplexType2.getTargetNamespace()) == 0 && xSComplexType.getName().compareTo(xSComplexType2.getName()) == 0) {
                    SchemaTreeNode schemaTreeNode9 = new SchemaTreeNode("redefine", xSComplexType.getLocator());
                    this.currNode.add(schemaTreeNode9);
                    this.currNode = schemaTreeNode9;
                    xSComplexType2.visit(this);
                    this.currNode = (SchemaTreeNode)schemaTreeNode9.getParent();
                }
                xSComplexType.getExplicitContent().visit(this);
                this.dumpComplexTypeAttribute(xSComplexType);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            }
            this.currNode = (SchemaTreeNode)this.currNode.getParent();
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    private void dumpComplexTypeAttribute(XSComplexType xSComplexType) {
        Iterator<XSComponent> iterator = xSComplexType.iterateAttGroups();
        while (iterator.hasNext()) {
            this.dumpRef(iterator.next());
        }
        iterator = xSComplexType.iterateDeclaredAttributeUses();
        while (iterator.hasNext()) {
            this.attributeUse((XSAttributeUse)iterator.next());
        }
    }

    public void elementDecl(XSElementDecl xSElementDecl) {
        this.elementDecl(xSElementDecl, "");
    }

    private void elementDecl(XSElementDecl xSElementDecl, String string) {
        XSType xSType = xSElementDecl.getType();
        String string2 = MessageFormat.format("Element name=\"{0}\"{1}{2}", xSElementDecl.getName(), xSType.isLocal() ? "" : " type=\"{" + xSType.getTargetNamespace() + "}" + xSType.getName() + "\"", string);
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(string2, xSElementDecl.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        if (xSType.isLocal() && xSType.isLocal()) {
            xSType.visit(this);
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("Group name=\"{0}\"", xSModelGroupDecl.getName()), xSModelGroupDecl.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        this.modelGroup(xSModelGroupDecl.getModelGroup());
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void modelGroup(XSModelGroup xSModelGroup) {
        this.modelGroup(xSModelGroup, "");
    }

    private void modelGroup(XSModelGroup xSModelGroup, String string) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("{0}{1}", new Object[]{xSModelGroup.getCompositor(), string}), xSModelGroup.getLocator());
        this.currNode.add(schemaTreeNode);
        this.currNode = schemaTreeNode;
        int n = xSModelGroup.getSize();
        for (int i = 0; i < n; ++i) {
            this.particle(xSModelGroup.getChild(i));
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void particle(XSParticle xSParticle) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = xSParticle.getMaxOccurs();
        if (n == -1) {
            stringBuffer.append(" maxOccurs=\"unbounded\"");
        } else if (n != 1) {
            stringBuffer.append(" maxOccurs=\"" + n + "\"");
        }
        n = xSParticle.getMinOccurs();
        if (n != 1) {
            stringBuffer.append(" minOccurs=\"" + n + "\"");
        }
        final String string = stringBuffer.toString();
        xSParticle.getTerm().visit(new XSTermVisitor(){

            public void elementDecl(XSElementDecl xSElementDecl) {
                if (xSElementDecl.isLocal()) {
                    SchemaTreeTraverser.this.elementDecl(xSElementDecl, string);
                } else {
                    SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("Element ref=\"'{'{0}'}'{1}\"{2}", xSElementDecl.getTargetNamespace(), xSElementDecl.getName(), string), xSElementDecl.getLocator());
                    SchemaTreeTraverser.this.currNode.add(schemaTreeNode);
                }
            }

            public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
                SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("Group ref=\"'{'{0}'}'{1}\"{2}", xSModelGroupDecl.getTargetNamespace(), xSModelGroupDecl.getName(), string), xSModelGroupDecl.getLocator());
                SchemaTreeTraverser.this.currNode.add(schemaTreeNode);
            }

            public void modelGroup(XSModelGroup xSModelGroup) {
                SchemaTreeTraverser.this.modelGroup(xSModelGroup, string);
            }

            public void wildcard(XSWildcard xSWildcard) {
                SchemaTreeTraverser.this.wildcard(xSWildcard, string);
            }
        });
    }

    public void wildcard(XSWildcard xSWildcard) {
        this.wildcard(xSWildcard, "");
    }

    private void wildcard(XSWildcard xSWildcard, String string) {
        SchemaTreeNode schemaTreeNode = new SchemaTreeNode(MessageFormat.format("Any ", string), xSWildcard.getLocator());
        this.currNode.add(schemaTreeNode);
    }

    public void annotation(XSAnnotation xSAnnotation) {
    }

    public void empty(XSContentType xSContentType) {
    }

    public void identityConstraint(XSIdentityConstraint xSIdentityConstraint) {
    }

    public void xpath(XSXPath xSXPath) {
    }

    public static class SchemaRootNode
    extends SchemaTreeNode {
        public SchemaRootNode() {
            super("Schema set", null);
        }
    }

    public static class SchemaTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected final JLabel iconLabel;
        protected final JLabel nameLabel;
        private boolean isSelected;
        public final Color selectedBackground = new Color(255, 244, 232);
        public final Color selectedForeground = new Color(64, 32, 0);
        public final Font nameFont = new Font("Arial", 1, 12);

        public SchemaTreeCellRenderer() {
            FlowLayout flowLayout = new FlowLayout(0, 1, 1);
            this.setLayout(flowLayout);
            this.iconLabel = new JLabel();
            this.iconLabel.setOpaque(false);
            this.iconLabel.setBorder(null);
            this.add(this.iconLabel);
            this.add(Box.createHorizontalStrut(5));
            this.nameLabel = new JLabel();
            this.nameLabel.setOpaque(false);
            this.nameLabel.setBorder(null);
            this.nameLabel.setFont(this.nameFont);
            this.add(this.nameLabel);
            this.isSelected = false;
            this.setOpaque(false);
            this.setBorder(null);
        }

        public final void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.isSelected) {
                graphics.setColor(this.selectedBackground);
                graphics.fillRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(this.selectedForeground);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
            }
            super.paintComponent(graphics);
        }

        protected final void setValues(Icon icon, String string, boolean bl) {
            this.iconLabel.setIcon(icon);
            this.nameLabel.setText(string);
            this.isSelected = bl;
            if (bl) {
                this.nameLabel.setForeground(this.selectedForeground);
            } else {
                this.nameLabel.setForeground(Color.black);
            }
        }

        public final Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof SchemaTreeNode) {
                SchemaTreeNode schemaTreeNode = (SchemaTreeNode)object;
                this.setValues(null, schemaTreeNode.getCaption(), bl);
                return this;
            }
            throw new IllegalStateException("Unknown node");
        }
    }

    public static final class SchemaTreeModel
    extends DefaultTreeModel {
        private SchemaTreeModel(SchemaRootNode schemaRootNode) {
            super(schemaRootNode);
        }

        public static SchemaTreeModel getInstance() {
            SchemaRootNode schemaRootNode = new SchemaRootNode();
            return new SchemaTreeModel(schemaRootNode);
        }

        public void addSchemaNode(SchemaTreeNode schemaTreeNode) {
            ((SchemaRootNode)this.root).add(schemaTreeNode);
        }
    }

    public static class SchemaTreeNode
    extends DefaultMutableTreeNode {
        private String fileName;
        private int lineNumber;
        private String artifactName;

        public SchemaTreeNode(String string, Locator locator) {
            this.artifactName = string;
            if (locator == null) {
                this.fileName = null;
            } else {
                String string2 = locator.getSystemId();
                if ((string2 = string2.replaceAll("%20", " ")).startsWith("file:/")) {
                    string2 = string2.substring(6);
                }
                this.fileName = string2;
                this.lineNumber = locator.getLineNumber() - 1;
            }
        }

        public String getCaption() {
            return this.artifactName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int n) {
            this.lineNumber = n;
        }
    }
}

