/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.v1_0;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Map;
import sun.jvmstat.monitor.AbstractMonitor;
import sun.jvmstat.monitor.IntegerMonitor;
import sun.jvmstat.monitor.LongMonitor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.perfdata.monitor.MonitorDataException;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.MonitorStructureException;
import sun.jvmstat.perfdata.monitor.MonitorTypeException;
import sun.jvmstat.perfdata.monitor.PerfDataBufferImpl;
import sun.jvmstat.perfdata.monitor.PerfIntegerMonitor;
import sun.jvmstat.perfdata.monitor.PerfLongMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringConstantMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringVariableMonitor;
import sun.jvmstat.perfdata.monitor.v1_0.BasicType;
import sun.jvmstat.perfdata.monitor.v1_0.PerfDataBufferPrologue;
import sun.management.counter.Units;
import sun.management.counter.Variability;

public class PerfDataBuffer
extends PerfDataBufferImpl {
    private static final boolean DEBUG = false;
    private static final int syncWaitMs = Integer.getInteger("sun.jvmstat.perdata.syncWaitMs", 5000);
    private static final ArrayList EMPTY_LIST = new ArrayList(0);
    private static final int PERFDATA_ENTRYLENGTH_OFFSET = 0;
    private static final int PERFDATA_ENTRYLENGTH_SIZE = 4;
    private static final int PERFDATA_NAMELENGTH_OFFSET = 4;
    private static final int PERFDATA_NAMELENGTH_SIZE = 4;
    private static final int PERFDATA_VECTORLENGTH_OFFSET = 8;
    private static final int PERFDATA_VECTORLENGTH_SIZE = 4;
    private static final int PERFDATA_DATATYPE_OFFSET = 12;
    private static final int PERFDATA_DATATYPE_SIZE = 1;
    private static final int PERFDATA_FLAGS_OFFSET = 13;
    private static final int PERFDATA_FLAGS_SIZE = 1;
    private static final int PERFDATA_DATAUNITS_OFFSET = 14;
    private static final int PERFDATA_DATAUNITS_SIZE = 1;
    private static final int PERFDATA_DATAATTR_OFFSET = 15;
    private static final int PERFDATA_DATAATTR_SIZE = 1;
    private static final int PERFDATA_NAME_OFFSET = 16;
    PerfDataBufferPrologue prologue;
    int nextEntry;
    int pollForEntry;
    int perfDataItem;
    long lastModificationTime;
    int lastUsed;
    IntegerMonitor overflow;
    ArrayList insertedMonitors;

    public PerfDataBuffer(ByteBuffer byteBuffer, int n) throws MonitorException {
        super(byteBuffer, n);
        this.prologue = new PerfDataBufferPrologue(byteBuffer);
        this.buffer.order(this.prologue.getByteOrder());
    }

    protected void buildMonitorMap(Map map) throws MonitorException {
        assert (Thread.holdsLock(this));
        this.buffer.rewind();
        this.buildPseudoMonitors(map);
        this.buffer.position(this.prologue.getSize());
        this.nextEntry = this.buffer.position();
        this.perfDataItem = 0;
        int n = this.prologue.getUsed();
        long l = this.prologue.getModificationTimeStamp();
        Monitor monitor2 = this.getNextMonitorEntry();
        while (monitor2 != null) {
            map.put(monitor2.getName(), monitor2);
            monitor2 = this.getNextMonitorEntry();
        }
        this.lastUsed = n;
        this.lastModificationTime = l;
        this.synchWithTarget(map);
        this.kludge(map);
        this.insertedMonitors = new ArrayList(map.values());
    }

    protected void getNewMonitors(Map map) throws MonitorException {
        assert (Thread.holdsLock(this));
        int n = this.prologue.getUsed();
        long l = this.prologue.getModificationTimeStamp();
        if (n > this.lastUsed || this.lastModificationTime > l) {
            this.lastUsed = n;
            this.lastModificationTime = l;
            Monitor monitor2 = this.getNextMonitorEntry();
            while (monitor2 != null) {
                String string = monitor2.getName();
                if (!map.containsKey(string)) {
                    map.put(string, monitor2);
                    if (this.insertedMonitors != null) {
                        this.insertedMonitors.add(monitor2);
                    }
                }
                monitor2 = this.getNextMonitorEntry();
            }
        }
    }

    protected MonitorStatus getMonitorStatus(Map map) throws MonitorException {
        assert (Thread.holdsLock(this));
        assert (this.insertedMonitors != null);
        this.getNewMonitors(map);
        ArrayList arrayList = EMPTY_LIST;
        ArrayList arrayList2 = this.insertedMonitors;
        this.insertedMonitors = new ArrayList();
        return new MonitorStatus(arrayList2, arrayList);
    }

    protected void buildPseudoMonitors(Map map) {
        AbstractMonitor abstractMonitor = null;
        String string = null;
        IntBuffer intBuffer = null;
        string = "sun.perfdata.majorVersion";
        intBuffer = this.prologue.majorVersionBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.NONE, Variability.CONSTANT, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.minorVersion";
        intBuffer = this.prologue.minorVersionBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.NONE, Variability.CONSTANT, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.size";
        intBuffer = this.prologue.sizeBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.BYTES, Variability.MONOTONIC, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.used";
        intBuffer = this.prologue.usedBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.BYTES, Variability.MONOTONIC, false, intBuffer);
        map.put(string, abstractMonitor);
        string = "sun.perfdata.overflow";
        intBuffer = this.prologue.overflowBuffer();
        abstractMonitor = new PerfIntegerMonitor(string, Units.BYTES, Variability.MONOTONIC, false, intBuffer);
        map.put(string, abstractMonitor);
        this.overflow = abstractMonitor;
        string = "sun.perfdata.timestamp";
        LongBuffer longBuffer = this.prologue.modificationTimeStampBuffer();
        abstractMonitor = new PerfLongMonitor(string, Units.TICKS, Variability.MONOTONIC, false, longBuffer);
        map.put(string, abstractMonitor);
    }

    protected void synchWithTarget(Map map) throws MonitorException {
        long l = System.currentTimeMillis() + (long)syncWaitMs;
        String string = "hotspot.rt.hrt.ticks";
        LongMonitor longMonitor = (LongMonitor)this.pollFor(map, string, l);
        this.log("synchWithTarget: " + this.lvmid + " ");
        while (longMonitor.longValue() == 0L) {
            this.log(".");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= l) continue;
            this.lognl("failed: " + this.lvmid);
            throw new MonitorException("Could Not Synchronize with target");
        }
        this.lognl("success: " + this.lvmid);
    }

    protected Monitor pollFor(Map map, String string, long l) throws MonitorException {
        Monitor monitor2 = null;
        this.log("polling for: " + this.lvmid + "," + string + " ");
        this.pollForEntry = this.nextEntry;
        while ((monitor2 = (Monitor)map.get(string)) == null) {
            this.log(".");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis();
            if (l2 > l || this.overflow.intValue() > 0) {
                this.lognl("failed: " + this.lvmid + "," + string);
                this.dumpAll(map, this.lvmid);
                throw new MonitorException("Could not find expected counter");
            }
            this.getNewMonitors(map);
        }
        this.lognl("success: " + this.lvmid + "," + string);
        return monitor2;
    }

    protected void kludge(Map map) {
        StringMonitor stringMonitor;
        StringMonitor stringMonitor2;
        if (Boolean.getBoolean("sun.jvmstat.perfdata.disableKludge")) {
            return;
        }
        String string = "java.vm.version";
        StringMonitor stringMonitor3 = (StringMonitor)map.get(string);
        if (stringMonitor3 == null) {
            stringMonitor3 = (StringMonitor)this.findByAlias(string);
        }
        if ((stringMonitor2 = (StringMonitor)map.get(string = "java.vm.name")) == null) {
            stringMonitor2 = (StringMonitor)this.findByAlias(string);
        }
        if ((stringMonitor = (StringMonitor)map.get(string = "hotspot.vm.args")) == null) {
            stringMonitor = (StringMonitor)this.findByAlias(string);
        }
        assert (stringMonitor2 != null && stringMonitor3 != null && stringMonitor != null);
        if (stringMonitor2.stringValue().indexOf("HotSpot") >= 0 && stringMonitor3.stringValue().startsWith("1.4.2")) {
            this.kludgeMantis(map, stringMonitor);
        }
    }

    private void kludgeMantis(Map map, StringMonitor stringMonitor) {
        String string = "hotspot.gc.collector.0.name";
        StringMonitor stringMonitor2 = (StringMonitor)map.get(string);
        if (stringMonitor2.stringValue().compareTo("PSScavenge") == 0) {
            boolean bl = true;
            string = "hotspot.vm.flags";
            StringMonitor stringMonitor3 = (StringMonitor)map.get(string);
            String string2 = stringMonitor3.stringValue() + " " + stringMonitor.stringValue();
            int n = string2.lastIndexOf("+AggressiveHeap");
            int n2 = string2.lastIndexOf("-UseAdaptiveSizePolicy");
            if (n != -1) {
                if (n2 != -1 && n2 > n) {
                    bl = false;
                }
            } else if (n2 != -1) {
                bl = false;
            }
            if (bl) {
                String string3 = "hotspot.gc.generation.0.space.0.size";
                String string4 = "hotspot.gc.generation.0.space.1.size";
                String string5 = "hotspot.gc.generation.0.space.2.size";
                map.remove(string3);
                map.remove(string4);
                map.remove(string5);
                String string6 = "hotspot.gc.generation.0.capacity.max";
                LongMonitor longMonitor = (LongMonitor)map.get(string6);
                PerfLongMonitor perfLongMonitor = null;
                LongBuffer longBuffer = LongBuffer.allocate(1);
                longBuffer.put(longMonitor.longValue());
                perfLongMonitor = new PerfLongMonitor(string3, Units.BYTES, Variability.CONSTANT, false, longBuffer);
                map.put(string3, perfLongMonitor);
                perfLongMonitor = new PerfLongMonitor(string4, Units.BYTES, Variability.CONSTANT, false, longBuffer);
                map.put(string4, perfLongMonitor);
                perfLongMonitor = new PerfLongMonitor(string5, Units.BYTES, Variability.CONSTANT, false, longBuffer);
                map.put(string5, perfLongMonitor);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Monitor getNextMonitorEntry() throws MonitorException {
        void var1_6;
        boolean bl;
        Object var1_1 = null;
        if (this.nextEntry % 4 != 0) {
            throw new MonitorStructureException("Entry index not properly aligned: " + this.nextEntry);
        }
        if (this.nextEntry < 0 || this.nextEntry > this.buffer.limit()) {
            throw new MonitorStructureException("Entry index out of bounds: nextEntry = " + this.nextEntry + ", limit = " + this.buffer.limit());
        }
        if (this.nextEntry == this.buffer.limit()) {
            this.lognl("getNextMonitorEntry(): nextEntry == buffer.limit(): returning");
            return null;
        }
        this.buffer.position(this.nextEntry);
        int n = this.buffer.position();
        int n2 = this.buffer.getInt();
        if (n2 < 0 || n2 > this.buffer.limit()) {
            throw new MonitorStructureException("Invalid entry length: entryLength = " + n2);
        }
        if (n + n2 > this.buffer.limit()) {
            throw new MonitorStructureException("Entry extends beyond end of buffer:  entryStart = " + n + " entryLength = " + n2 + " buffer limit = " + this.buffer.limit());
        }
        if (n2 == 0) {
            return null;
        }
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        Units units = Units.toUnits(this.buffer.get());
        Variability variability = Variability.toVariability(this.buffer.get());
        boolean bl2 = bl = (by2 & 1) != 0;
        if (n3 <= 0 || n3 > n2) {
            throw new MonitorStructureException("Invalid Monitor name length: " + n3);
        }
        if (n4 < 0 || n4 > n2) {
            throw new MonitorStructureException("Invalid Monitor vector length: " + n4);
        }
        byte[] byArray = new byte[n3 - 1];
        for (int i = 0; i < n3 - 1; ++i) {
            byArray[i] = this.buffer.get();
        }
        String string = new String(byArray, 0, n3 - 1);
        if (variability == Variability.INVALID) {
            throw new MonitorDataException("Invalid variability attribute: entry index = " + this.perfDataItem + " name = " + string);
        }
        if (units == Units.INVALID) {
            throw new MonitorDataException("Invalid units attribute:  entry index = " + this.perfDataItem + " name = " + string);
        }
        if (n4 == 0) {
            if (by != BasicType.LONG.intValue()) throw new MonitorTypeException("Invalid Monitor type: entry index = " + this.perfDataItem + " name = " + string + " type = " + by);
            int n5 = n + n2 - 8;
            this.buffer.position(n5);
            LongBuffer longBuffer = this.buffer.asLongBuffer();
            longBuffer.limit(1);
            PerfLongMonitor perfLongMonitor = new PerfLongMonitor(string, units, variability, bl, longBuffer);
            ++this.perfDataItem;
        } else {
            if (by != BasicType.BYTE.intValue()) throw new MonitorTypeException("Invalid Monitor type: entry index = " + this.perfDataItem + " name = " + string + " type = " + by);
            if (units != Units.STRING) {
                throw new MonitorTypeException("Invalid Monitor type: entry index = " + this.perfDataItem + " name = " + string + " type = " + by);
            }
            int n6 = n + 16 + n3;
            this.buffer.position(n6);
            ByteBuffer byteBuffer = this.buffer.slice();
            byteBuffer.limit(n4);
            byteBuffer.position(0);
            if (variability == Variability.CONSTANT) {
                PerfStringConstantMonitor perfStringConstantMonitor = new PerfStringConstantMonitor(string, bl, byteBuffer);
            } else {
                if (variability != Variability.VARIABLE) throw new MonitorDataException("Invalid variability attribute: entry index = " + this.perfDataItem + " name = " + string + " variability = " + variability);
                PerfStringVariableMonitor perfStringVariableMonitor = new PerfStringVariableMonitor(string, bl, byteBuffer, n4 - 1);
            }
            ++this.perfDataItem;
        }
        this.nextEntry = n + n2;
        return var1_6;
    }

    private void dumpAll(Map map, int n) {
    }

    private void lognl(String string) {
    }

    private void log(String string) {
    }
}

