/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.admin.cli.ConnectorSecurityMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Service(name="list-connector-security-maps")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@I18n(value="list.connector.security.maps")
public class ListConnectorSecurityMaps
extends ConnectorSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorSecurityMaps.class);
    @Param(name="securitymap", optional=true)
    String securityMap;
    @Param(name="long", optional=true, defaultValue="false", shortName="l", alias="verbose")
    Boolean long_opt;
    @Param(name="pool-name", primary=true)
    String poolName;
    @Param(optional=true, alias="targetName", obsolete=true)
    private String target = "server";
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report;
        block9: {
            report = context.getActionReport();
            ActionReport.MessagePart mp = report.getTopMessagePart();
            Collection ccPools = this.domain.getResources().getResources(ConnectorConnectionPool.class);
            if (!this.doesPoolNameExist(this.poolName, ccPools)) {
                report.setMessage(localStrings.getLocalString("create.connector.security.map.noSuchPoolFound", "Specified connector connection pool {0} does not exist. Please specify a valid pool name.", new Object[]{this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.securityMap != null && !this.doesMapNameExist(this.poolName, this.securityMap, ccPools)) {
                report.setMessage(localStrings.getLocalString("list.connector.security.maps.securityMapNotFound", "Security map {0} does not exist for connector connection pool {1}. Please give a valid map name.", new Object[]{this.securityMap, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                List<SecurityMap> securityMaps = this.getAllSecurityMapsForPool(this.poolName, ccPools);
                if (securityMaps == null || securityMaps.isEmpty()) break block9;
                if (this.securityMap == null && this.long_opt.booleanValue()) {
                    for (SecurityMap sm : securityMaps) {
                        this.listSecurityMapDetails(sm, mp);
                    }
                    break block9;
                }
                if (this.securityMap == null && !this.long_opt.booleanValue()) {
                    for (SecurityMap sm : securityMaps) {
                        this.listSecurityMapNames(sm, mp);
                    }
                    break block9;
                }
                for (SecurityMap sm : securityMaps) {
                    if (!sm.getName().equals(this.securityMap)) continue;
                    this.listSecurityMapDetails(sm, mp);
                    break;
                }
            }
            catch (Exception e) {
                Logger.getLogger(ListConnectorSecurityMaps.class.getName()).log(Level.SEVERE, "list-connector-security-maps failed", e);
                report.setMessage(localStrings.getLocalString("list.connector.security.maps.fail", "Unable to list security map {0} for connector connection pool {1}", new Object[]{this.securityMap, this.poolName}) + " " + e.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void listSecurityMapNames(SecurityMap sm, ActionReport.MessagePart mp) {
        ActionReport.MessagePart part = mp.addChild();
        part.setMessage(sm.getName());
    }

    private void listSecurityMapDetails(SecurityMap sm, ActionReport.MessagePart mp) {
        List principalList = sm.getPrincipal();
        List groupList = sm.getUserGroup();
        BackendPrincipal bp = sm.getBackendPrincipal();
        ActionReport.MessagePart partSM = mp.addChild();
        partSM.setMessage(sm.getName());
        ActionReport.MessagePart partPG = partSM.addChild();
        if (!principalList.isEmpty()) {
            partPG.setMessage(localStrings.getLocalString("list.connector.security.maps.principals", "\tPrincipal(s)"));
        }
        if (!groupList.isEmpty()) {
            partPG.setMessage(localStrings.getLocalString("list.connector.security.maps.groups", "\tUser Group(s)"));
        }
        for (String principal : principalList) {
            ActionReport.MessagePart partP = partPG.addChild();
            partP.setMessage(localStrings.getLocalString("list.connector.security.maps.eisPrincipal", "\t\t" + principal, new Object[]{principal}));
        }
        for (String group : groupList) {
            ActionReport.MessagePart partG = partPG.addChild();
            partG.setMessage(localStrings.getLocalString("list.connector.security.maps.eisGroup", "\t\t" + group, new Object[]{group}));
        }
        ActionReport.MessagePart partBP = partPG.addChild();
        partBP.setMessage(localStrings.getLocalString("list.connector.security.maps.backendPrincipal", "\tBackend Principal"));
        ActionReport.MessagePart partBPU = partBP.addChild();
        partBPU.setMessage(localStrings.getLocalString("list.connector.security.maps.username", "\t\tUser Name = " + bp.getUserName(), new Object[]{bp.getUserName()}));
        if (bp.getPassword() != null && !bp.getPassword().isEmpty()) {
            ActionReport.MessagePart partBPP = partBP.addChild();
            partBPP.setMessage(localStrings.getLocalString("list.connector.security.maps.password", "\t\tPassword = " + bp.getPassword(), new Object[]{bp.getPassword()}));
        }
    }
}

