/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagHandlerFactory;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.UserTagHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.faces.view.facelets.ValidatorConfig;
import javax.faces.view.facelets.ValidatorHandler;

public abstract class AbstractTagLibrary
implements TagLibrary {
    private final Map factories;
    private final String namespace;
    private final Map functions;

    public AbstractTagLibrary(String namespace) {
        this.namespace = namespace;
        this.factories = new HashMap();
        this.functions = new HashMap();
    }

    protected final void addComponent(String name, String componentType, String rendererType) {
        this.factories.put(name, new ComponentHandlerFactory(componentType, rendererType));
    }

    protected final void addComponent(String name, String componentType, String rendererType, Class handlerType) {
        this.factories.put(name, new UserComponentHandlerFactory(componentType, rendererType, handlerType));
    }

    protected final void addConverter(String name, String converterId) {
        this.factories.put(name, new ConverterHandlerFactory(converterId));
    }

    protected final void addConverter(String name, String converterId, Class type) {
        this.factories.put(name, new UserConverterHandlerFactory(converterId, type));
    }

    protected final void addValidator(String name, String validatorId) {
        this.factories.put(name, new ValidatorHandlerFactory(validatorId));
    }

    protected final void addValidator(String name, String validatorId, Class type) {
        this.factories.put(name, new UserValidatorHandlerFactory(validatorId, type));
    }

    protected final void addBehavior(String name, String behaviorId) {
        this.factories.put(name, new BehaviorHandlerFactory(behaviorId));
    }

    protected final void addBehavior(String name, String behaviorId, Class type) {
        this.factories.put(name, new UserBehaviorHandlerFactory(behaviorId, type));
    }

    protected final void addTagHandler(String name, Class handlerType) {
        this.factories.put(name, new HandlerFactory(handlerType));
    }

    protected final void addUserTag(String name, URL source) {
        this.factories.put(name, new UserTagFactory(source));
    }

    protected final void addFunction(String name, Method method) {
        this.functions.put(name, method);
    }

    public boolean containsNamespace(String ns, Tag t) {
        return this.namespace.equals(ns);
    }

    public boolean containsTagHandler(String ns, String localName) {
        return this.namespace.equals(ns) && this.factories.containsKey(localName);
    }

    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        TagHandlerFactory f;
        if (this.namespace.equals(ns) && (f = (TagHandlerFactory)this.factories.get(localName)) != null) {
            return f.createHandler(tag);
        }
        return null;
    }

    public boolean containsFunction(String ns, String name) {
        if (this.namespace.equals(ns)) {
            return this.functions.containsKey(name);
        }
        return false;
    }

    public Method createFunction(String ns, String name) {
        if (this.namespace.equals(ns)) {
            return (Method)this.functions.get(name);
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof TagLibrary && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static final class BehaviorConfigWrapper
    implements BehaviorConfig {
        private final TagConfig parent;
        private final String behaviorId;

        public BehaviorConfigWrapper(TagConfig parent, String behaviorId) {
            this.parent = parent;
            this.behaviorId = behaviorId;
        }

        public String getBehaviorId() {
            return this.behaviorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static final class BehaviorHandlerFactory
    implements TagHandlerFactory {
        private final String behaviorId;

        public BehaviorHandlerFactory(String behaviorId) {
            this.behaviorId = behaviorId;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new BehaviorHandler(new BehaviorConfigWrapper(cfg, this.behaviorId));
        }
    }

    protected static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ComponentHandlerFactory
    implements TagHandlerFactory {
        protected final String componentType;
        protected final String renderType;

        public ComponentHandlerFactory(String componentType, String renderType) {
            this.componentType = componentType;
            this.renderType = renderType;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
            return new ComponentHandler(ccfg);
        }
    }

    private static class ConverterConfigWrapper
    implements ConverterConfig {
        private final TagConfig parent;
        private final String converterId;

        public ConverterConfigWrapper(TagConfig parent, String converterId) {
            this.parent = parent;
            this.converterId = converterId;
        }

        public String getConverterId() {
            return this.converterId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ConverterHandlerFactory
    implements TagHandlerFactory {
        protected final String converterId;

        public ConverterHandlerFactory(String converterId) {
            this.converterId = converterId;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ConverterHandler(new ConverterConfigWrapper(cfg, this.converterId));
        }
    }

    private static class HandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONSTRUCTOR_SIG = new Class[]{TagConfig.class};
        protected final Class handlerType;

        public HandlerFactory(Class handlerType) {
            this.handlerType = handlerType;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                return (TagHandler)this.handlerType.getConstructor(CONSTRUCTOR_SIG).newInstance(cfg);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof FacesException) {
                    throw (FacesException)t;
                }
                if (t instanceof ELException) {
                    throw (ELException)t;
                }
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), t);
            }
            catch (Exception e) {
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), e);
            }
        }
    }

    private static class UserBehaviorHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{BehaviorConfig.class};
        protected final String behaviorId;
        protected final Class type;
        protected final Constructor constructor;

        public UserBehaviorHandlerFactory(String behaviorId, Class type) {
            this.behaviorId = behaviorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a BehaviorConfig", e);
            }
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                BehaviorConfigWrapper ccfg = new BehaviorConfigWrapper(cfg, this.behaviorId);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating BehaviorHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class UserComponentHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ComponentConfig.class};
        protected final String componentType;
        protected final String renderType;
        protected final Class type;
        protected final Constructor constructor;

        public UserComponentHandlerFactory(String componentType, String renderType, Class type) {
            this.componentType = componentType;
            this.renderType = renderType;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ComponentConfig", e);
            }
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ComponentHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class UserConverterHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ConverterConfig.class};
        protected final String converterId;
        protected final Class type;
        protected final Constructor constructor;

        public UserConverterHandlerFactory(String converterId, Class type) {
            this.converterId = converterId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", e);
            }
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ConverterConfigWrapper ccfg = new ConverterConfigWrapper(cfg, this.converterId);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ConverterHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class UserTagFactory
    implements TagHandlerFactory {
        protected final URL location;

        public UserTagFactory(URL location) {
            this.location = location;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new UserTagHandler(cfg, this.location);
        }
    }

    private static class UserValidatorHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ValidatorConfig.class};
        protected final String validatorId;
        protected final Class type;
        protected final Constructor constructor;

        public UserValidatorHandlerFactory(String validatorId, Class type) {
            this.validatorId = validatorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ValidatorConfig", e);
            }
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ValidatorConfigWrapper ccfg = new ValidatorConfigWrapper(cfg, this.validatorId);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ValidatorHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class ValidatorConfigWrapper
    implements ValidatorConfig {
        private final TagConfig parent;
        private final String validatorId;

        public ValidatorConfigWrapper(TagConfig parent, String validatorId) {
            this.parent = parent;
            this.validatorId = validatorId;
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ValidatorHandlerFactory
    implements TagHandlerFactory {
        protected final String validatorId;

        public ValidatorHandlerFactory(String validatorId) {
            this.validatorId = validatorId;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ValidatorHandler(new ValidatorConfigWrapper(cfg, this.validatorId));
        }
    }
}

