/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.matcher;

public class WildcardMatcher {
    private final String pattern;
    private final String[] parts;

    public WildcardMatcher(String pattern) {
        this.pattern = pattern;
        this.parts = pattern.split("\\*");
    }

    public boolean matches(String text) {
        if (0 == this.parts.length) {
            return true;
        }
        if (!this.pattern.startsWith("*") && !text.startsWith(this.parts[0])) {
            return false;
        }
        for (String part : this.parts) {
            int pos = text.indexOf(part);
            if (pos == -1) {
                return false;
            }
            text = text.substring(pos + part.length());
        }
        return text.length() == 0 || this.pattern.endsWith("*");
    }
}

