/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;

@Service(name="create-lifecycle-module")
@I18n(value="create.lifecycle.module")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class CreateLifecycleModuleCommand
implements AdminCommand {
    @Param(primary=true)
    public String name = null;
    @Param(optional=false)
    public String classname = null;
    @Param(optional=true)
    public String classpath = null;
    @Param(optional=true)
    public String loadorder = null;
    @Param(optional=true, defaultValue="false")
    public Boolean failurefatal = false;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(optional=true)
    public String description = null;
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true, separator=58)
    public Properties property = null;
    @Inject
    Deployment deployment;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateLifecycleModuleCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (this.deployment.isRegistered(this.name)) {
            report.setMessage(localStrings.getLocalString("lifecycle.alreadyreg", "Lifecycle module {0} already registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        DeployCommandParameters commandParams = new DeployCommandParameters();
        commandParams.name = this.name;
        commandParams.enabled = this.enabled;
        commandParams.description = this.description;
        commandParams.target = this.target;
        DeploymentContextImpl deploymentContext = new DeploymentContextImpl(report, logger, null, (OpsParams)commandParams, null);
        Properties appProps = deploymentContext.getAppProps();
        if (this.property != null) {
            appProps.putAll((Map<?, ?>)this.property);
        }
        appProps.setProperty("object-type", "user");
        appProps.setProperty("class-name", this.classname);
        if (this.classpath != null) {
            appProps.setProperty("classpath", this.classpath);
        }
        if (this.loadorder != null) {
            appProps.setProperty("load-order", this.loadorder);
        }
        appProps.setProperty("is-failure-fatal", this.failurefatal.toString());
        appProps.setProperty("isLifecycle", "true");
        try {
            Transaction t = this.deployment.prepareAppConfigChanges((DeploymentContext)deploymentContext);
            this.deployment.registerAppInDomainXML(null, (DeploymentContext)deploymentContext, t);
        }
        catch (Exception e) {
            report.setMessage("Failed to create lifecycle module: " + e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

