/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.SSHCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import com.trilead.ssh2.SCPClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="install-node")
@Scoped(value=PerLookup.class)
public class InstallNodeCommand
extends SSHCommandsBase {
    @Param(name="archive", optional=true)
    private String archive;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean create;
    @Param(optional=true, defaultValue="false")
    private boolean save;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private Habitat habitat;
    @Inject
    private SSHLauncher sshLauncher;
    private String archiveName;
    private boolean delete = true;

    protected void validate() throws CommandException {
        Globals.setDefaultHabitat(this.habitat);
        this.installDir = this.resolver.resolve(this.installDir);
        if (!this.force) {
            for (String host : this.hosts) {
                if (!this.checkIfNodeExistsForHost(host)) continue;
                throw new CommandException(Strings.get("node.already.configured", host));
            }
        }
        this.sshuser = this.resolver.resolve(this.sshuser);
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey;
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && this.isEncryptedKey()) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    protected int executeCommand() throws CommandException {
        File zipFile = null;
        try {
            String baseRootValue = this.getSystemProperty("com.sun.aas.productRoot");
            ArrayList<String> binDirFiles = new ArrayList<String>();
            zipFile = this.createZipFileIfNeeded(baseRootValue, binDirFiles);
            this.copyToHosts(zipFile, binDirFiles);
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        catch (ZipFileException ze) {
            throw new CommandException((Throwable)ze);
        }
        catch (InterruptedException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            if (!this.save && this.delete && zipFile != null) {
                zipFile.delete();
            }
        }
        return 0;
    }

    private void copyToHosts(File zipFile, ArrayList<String> binDirFiles) throws IOException, InterruptedException, CommandException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        for (String host : this.hosts) {
            int status;
            this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            if (this.sshkeyfile != null && !this.sshLauncher.checkConnection()) {
                this.promptPass = true;
            }
            if (this.promptPass) {
                this.sshpassword = this.getSSHPassword(host);
                this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            }
            this.installDir = this.installDir.replaceAll("\\\\", "/");
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            SCPClient scpClient = this.sshLauncher.getSCPClient();
            try {
                if (!sftpClient.exists(this.installDir)) {
                    sftpClient.mkdirs(this.installDir, 493);
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("mkdir.failed", this.installDir, host));
                throw new IOException(ioe);
            }
            if (this.checkIfAlreadyInstalled(host)) continue;
            try {
                String ins = this.resolver.resolve("${com.sun.aas.installRoot}") + "/../";
                File all = new File(ins);
                Set files = FileUtils.getAllFilesAndDirectoriesUnder((File)all);
                logger.finer("Total number of files under " + ins + " = " + files.size());
                String remoteDir = this.installDir;
                ArrayList<String> modList = new ArrayList<String>();
                if (!this.installDir.endsWith("/")) {
                    remoteDir = remoteDir + "/";
                }
                for (Object f : files) {
                    modList.add(remoteDir + FileUtils.makeForwardSlashes((String)((File)f).getPath()));
                }
                this.deleteRemoteFiles(sftpClient, modList, this.installDir, this.force);
            }
            catch (IOException ex) {
                logger.finer("Failed to remove installDir contents");
                throw new IOException(ex);
            }
            String zip = zipFile.getCanonicalPath();
            try {
                logger.info("Copying " + zip + " (" + zipFile.length() + " bytes)" + " to " + host + ":" + this.installDir);
                scpClient.put(zipFile.getAbsolutePath(), FileUtils.quoteString((String)this.installDir));
                logger.finer("Copied " + zip + " to " + host + ":" + this.installDir);
            }
            catch (IOException ex) {
                logger.info(Strings.get("cannot.copy.zip.file", zip, host));
                throw new IOException(ex);
            }
            try {
                logger.info("Installing " + this.archiveName + " into " + host + ":" + this.installDir);
                String unzipCommand = "cd '" + this.installDir + "'; jar -xvf " + this.archiveName;
                status = this.sshLauncher.runCommand(unzipCommand, (OutputStream)outStream);
                if (status != 0) {
                    logger.info(Strings.get("jar.failed", host, outStream.toString()));
                    throw new CommandException("Remote command output: " + outStream.toString());
                }
                logger.finer("Installed " + this.archiveName + " into " + host + ":" + this.installDir);
            }
            catch (IOException ioe) {
                logger.info(Strings.get("jar.failed", host, outStream.toString()));
                throw new IOException(ioe);
            }
            try {
                logger.info("Removing " + host + ":" + this.installDir + "/" + this.archiveName);
                sftpClient.rm(this.installDir + "/" + this.archiveName);
                logger.finer("Removed " + host + ":" + this.installDir + "/" + this.archiveName);
            }
            catch (IOException ioe) {
                logger.info(Strings.get("remove.glassfish.failed", host, this.installDir));
                throw new IOException(ioe);
            }
            logger.info("Fixing file permissions of all files under " + host + ":" + this.installDir + "/bin");
            try {
                if (binDirFiles.isEmpty()) {
                    String cmd = "cd '" + this.installDir + "/glassfish/bin'; chmod 0755 *";
                    status = this.sshLauncher.runCommand(cmd, (OutputStream)outStream);
                    if (status != 0) {
                        logger.info(Strings.get("jar.failed", host, outStream.toString()));
                        throw new CommandException("Remote command output: " + outStream.toString());
                    }
                } else {
                    for (String binDirFile : binDirFiles) {
                        sftpClient.chmod(this.installDir + "/" + binDirFile, 493);
                    }
                }
                logger.finer("Fixed file permissions of all files under " + host + ":" + this.installDir + "/bin");
            }
            catch (IOException ioe) {
                logger.info(Strings.get("fix.permissions.failed", host, this.installDir));
                throw new IOException(ioe);
            }
        }
    }

    private File createZipFileIfNeeded(String baseRootValue, ArrayList<String> binDirFiles) throws IOException, ZipFileException {
        File installRoot = new File(baseRootValue);
        File zipFileLocation = null;
        File glassFishZipFile = null;
        if (this.archive != null) {
            this.archive = this.archive.replaceAll("\\\\", "/");
            this.archiveName = this.archive.substring(this.archive.lastIndexOf("/") + 1, this.archive.length());
            zipFileLocation = new File(this.archive.substring(0, this.archive.lastIndexOf("/")));
            glassFishZipFile = new File(this.archive);
            if (glassFishZipFile.exists() && !this.create) {
                logger.finer("Found " + glassFishZipFile.getCanonicalPath());
                this.delete = false;
                return glassFishZipFile;
            }
            if (!zipFileLocation.canWrite()) {
                throw new IOException("Cannot write to " + this.archive);
            }
        } else {
            zipFileLocation = new File(".");
            if (!zipFileLocation.canWrite()) {
                zipFileLocation = new File(System.getProperty("java.io.tmpdir"));
            }
            glassFishZipFile = File.createTempFile("glassfish", ".zip", zipFileLocation);
            String filePath = glassFishZipFile.getCanonicalPath();
            filePath = filePath.replaceAll("\\\\", "/");
            this.archiveName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        }
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        List<String> resultFiles1 = Arrays.asList(files);
        ArrayList<String> resultFiles = new ArrayList<String>(resultFiles1);
        logger.finer("Number of files to be zipped = " + resultFiles.size());
        Iterator<String> iter = resultFiles.iterator();
        while (iter.hasNext()) {
            String fileName = iter.next();
            String fPath = fileName.substring(fileName.lastIndexOf("/") + 1);
            if (fPath.equals(glassFishZipFile.getName())) {
                logger.finer("Removing file = " + fileName);
                iter.remove();
                continue;
            }
            if (fileName.contains("domains") || fileName.contains("nodes")) {
                iter.remove();
                continue;
            }
            if (!fileName.startsWith("bin") && !fileName.startsWith("glassfish/bin")) continue;
            binDirFiles.add(fileName);
        }
        logger.finer("Final number of files to be zipped = " + resultFiles.size());
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(FileUtils.safeGetCanonicalPath((File)glassFishZipFile), installRoot.toString(), filesToZip);
        writer.safeWrite();
        logger.info("Created installation zip " + glassFishZipFile.getCanonicalPath());
        return glassFishZipFile;
    }

    private void validateKeyFile(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
    }

    private boolean checkIfAlreadyInstalled(String host) throws CommandException, IOException, InterruptedException {
        boolean res = false;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            String cmd = "'" + this.installDir + "/glassfish/bin/asadmin' version --local --terse";
            int status = this.sshLauncher.runCommand(cmd, (OutputStream)outStream);
            if (status == 0) {
                logger.finer(host + ":'" + cmd + "'" + " returned [" + outStream.toString() + "]");
                logger.info(Strings.get("found.glassfish.install", host, this.installDir));
                res = true;
            } else {
                logger.finer(host + ":'" + cmd + "'" + " failed [" + outStream.toString() + "]");
            }
        }
        catch (IOException ex) {
            logger.info(Strings.get("glassfish.install.check.failed", host));
            throw new IOException(ex);
        }
        return res;
    }
}

