/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.SSHCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="uninstall-node")
@Scoped(value=PerLookup.class)
public class UninstallNodeCommand
extends SSHCommandsBase {
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private Habitat habitat;
    @Inject
    SSHLauncher sshLauncher;

    protected void validate() throws CommandException {
        Globals.setDefaultHabitat(this.habitat);
        this.installDir = this.resolver.resolve(this.installDir);
        if (!this.force) {
            for (String host : this.hosts) {
                if (!this.checkIfNodeExistsForHost(host)) continue;
                throw new CommandException(Strings.get("call.delete.node.ssh", host));
            }
        }
        this.sshuser = this.resolver.resolve(this.sshuser);
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey;
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && this.isEncryptedKey()) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    protected int executeCommand() throws CommandException {
        try {
            this.deleteFromHosts();
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        catch (InterruptedException e) {
            throw new CommandException((Throwable)e);
        }
        return 0;
    }

    private void deleteFromHosts() throws CommandException, IOException, InterruptedException {
        for (String host : this.hosts) {
            SFTPClient sftpClient;
            this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            if (this.sshkeyfile != null && !this.sshLauncher.checkConnection()) {
                this.promptPass = true;
            }
            if (this.promptPass) {
                this.sshpassword = this.getSSHPassword(host);
                this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            }
            if (!(sftpClient = this.sshLauncher.getSFTPClient()).exists(this.installDir)) {
                throw new IOException(this.installDir + " Directory does not exist");
            }
            String ins = this.resolver.resolve("${com.sun.aas.installRoot}") + "/../";
            File all = new File(ins);
            Set files = FileUtils.getAllFilesAndDirectoriesUnder((File)all);
            logger.finer("Total number of files under " + ins + " = " + files.size());
            String remoteDir = this.installDir;
            ArrayList<String> modList = new ArrayList<String>();
            if (!this.installDir.endsWith("/")) {
                remoteDir = remoteDir + "/";
            }
            for (Object f : files) {
                modList.add(remoteDir + FileUtils.makeForwardSlashes((String)((File)f).getPath()));
            }
            this.deleteRemoteFiles(sftpClient, modList, this.installDir, this.force);
            if (!sftpClient.ls(this.installDir).isEmpty()) continue;
            sftpClient.rmdir(this.installDir);
        }
    }

    private void validateKeyFile(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
    }
}

