/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Dictionary;
import java.util.HashSet;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.PropertyImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class LocalResourceImpl
extends ResourceImpl {
    private Bundle m_bundle = null;

    LocalResourceImpl(Bundle bundle) throws InvalidSyntaxException {
        this.m_bundle = bundle;
        this.initialize();
    }

    public boolean isLocal() {
        return true;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    private void initialize() throws InvalidSyntaxException {
        String ee;
        final Dictionary dict = this.m_bundle.getHeaders();
        DataModelHelperImpl.populate(new DataModelHelperImpl.Headers(){

            public String getHeader(String name) {
                return (String)dict.get(name);
            }

            public void close() {
            }
        }, this);
        this.convertExportServiceToCapability(dict, this.m_bundle);
        if (this.m_bundle.getBundleId() == 0L && (ee = this.m_bundle.getBundleContext().getProperty("org.osgi.framework.executionenvironment")) != null) {
            CapabilityImpl cap = new CapabilityImpl("ee");
            cap.addProperty("ee", ee);
            this.addCapability(cap);
        }
    }

    private void convertExportServiceToCapability(Dictionary dict, Bundle bundle) {
        HashSet services = new HashSet();
        ServiceReference[] refs = bundle.getRegisteredServices();
        for (int i = 0; refs != null && i < refs.length; ++i) {
            String[] cls = (String[])refs[i].getProperty("objectClass");
            for (int j = 0; cls != null && j < cls.length; ++j) {
                CapabilityImpl cap = new CapabilityImpl();
                cap.setName("service");
                cap.addProperty(new PropertyImpl("service", null, cls[j]));
                this.addCapability(cap);
            }
        }
    }

    public String toString() {
        return this.m_bundle.toString();
    }
}

