/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ApplicationScopedResourceBinding;
import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.ModuleScopedResourceBinding;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class ResourceNamingService
implements ConnectorConstants {
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private ComponentNamingUtil cnu;
    @Inject
    private ProcessEnvironment pe;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");

    public void publishObject(GenericResourceInfo resourceInfo, String jndiName, Object object, boolean rebind) throws NamingException {
        String applicationName = resourceInfo.getApplicationName();
        String moduleName = resourceInfo.getModuleName();
        moduleName = ConnectorsUtil.getActualModuleName(moduleName);
        if (!this.isGlobalName(resourceInfo.getName()) && applicationName != null && moduleName != null) {
            Object alreadyBoundObject = null;
            if (rebind) {
                try {
                    this.namingManager.unbindModuleObject(applicationName, moduleName, this.getModuleScopedName(jndiName));
                }
                catch (NameNotFoundException e) {}
            } else {
                try {
                    alreadyBoundObject = this.namingManager.lookupFromModuleNamespace(applicationName, moduleName, this.getModuleScopedName(jndiName), null);
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                if (alreadyBoundObject != null) {
                    throw new NamingException("Object already bound for jndiName [ " + jndiName + " ] of  module namespace [" + moduleName + "] " + "of application [" + applicationName + "] ");
                }
            }
            ModuleScopedResourceBinding bindings = new ModuleScopedResourceBinding(this.getModuleScopedName(jndiName), object);
            ArrayList<ModuleScopedResourceBinding> list = new ArrayList<ModuleScopedResourceBinding>();
            list.add(bindings);
            if (this._logger.isLoggable(Level.FINEST)) {
                this.debug("application=" + applicationName + ", module name=" + moduleName + ", binding name=" + jndiName);
            }
            this.namingManager.bindToModuleNamespace(applicationName, moduleName, list);
        } else if (!this.isGlobalName(resourceInfo.getName()) && applicationName != null) {
            Object alreadyBoundObject = null;
            if (rebind) {
                try {
                    this.namingManager.unbindAppObject(applicationName, this.getAppScopedName(jndiName));
                }
                catch (NameNotFoundException e) {}
            } else {
                try {
                    alreadyBoundObject = this.namingManager.lookupFromAppNamespace(applicationName, this.getAppScopedName(jndiName), null);
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                if (alreadyBoundObject != null) {
                    throw new NamingException("Object already bound for jndiName [ " + jndiName + " ] of application's namespace [" + applicationName + "]");
                }
            }
            ApplicationScopedResourceBinding bindings = new ApplicationScopedResourceBinding(this.getAppScopedName(jndiName), object);
            ArrayList<ApplicationScopedResourceBinding> list = new ArrayList<ApplicationScopedResourceBinding>();
            list.add(bindings);
            if (this._logger.isLoggable(Level.FINEST)) {
                this.debug("application=" + applicationName + ", binding name=" + jndiName);
            }
            this.namingManager.bindToAppNamespace(applicationName, list);
            this.bindAppScopedNameForAppclient(object, jndiName, applicationName);
        } else {
            this.namingManager.publishObject(jndiName, object, true);
        }
    }

    public void publishObject(ResourceInfo resourceInfo, Object object, boolean rebind) throws NamingException {
        String jndiName = resourceInfo.getName();
        this.publishObject((GenericResourceInfo)resourceInfo, jndiName, object, rebind);
    }

    private void bindAppScopedNameForAppclient(Object object, String jndiName, String applicationName) throws NamingException {
        String internalGlobalJavaAppName = this.cnu.composeInternalGlobalJavaAppName(applicationName, this.getAppScopedName(jndiName));
        if (this._logger.isLoggable(Level.FINEST)) {
            this.debug("binding app-scoped-resource for appclient : " + internalGlobalJavaAppName);
        }
        this.namingManager.publishObject(internalGlobalJavaAppName, object, true);
    }

    public void unpublishObject(GenericResourceInfo resourceInfo, String jndiName) throws NamingException {
        String applicationName = resourceInfo.getApplicationName();
        String moduleName = resourceInfo.getModuleName();
        moduleName = ConnectorsUtil.getActualModuleName(moduleName);
        if (!this.isGlobalName(resourceInfo.getName()) && applicationName != null && moduleName != null) {
            this.namingManager.unbindModuleObject(applicationName, moduleName, this.getModuleScopedName(jndiName));
        } else if (!this.isGlobalName(resourceInfo.getName()) && applicationName != null) {
            this.namingManager.unbindAppObject(applicationName, this.getAppScopedName(jndiName));
            this.unbindAppScopedNameForAppclient(jndiName, applicationName);
        } else {
            this.namingManager.unpublishObject(jndiName);
        }
    }

    private void unbindAppScopedNameForAppclient(String jndiName, String applicationName) throws NamingException {
        String internalGlobalJavaAppName = this.cnu.composeInternalGlobalJavaAppName(applicationName, this.getAppScopedName(jndiName));
        this.namingManager.unpublishObject(internalGlobalJavaAppName);
    }

    private boolean isGlobalName(String jndiName) {
        return jndiName.startsWith("java:global/") || !jndiName.startsWith("java:app/") && !jndiName.startsWith("java:module/");
    }

    public Object lookup(GenericResourceInfo resourceInfo, String name, Hashtable env) throws NamingException {
        String applicationName = resourceInfo.getApplicationName();
        String moduleName = resourceInfo.getModuleName();
        moduleName = ConnectorsUtil.getActualModuleName(moduleName);
        if (!this.isGlobalName(resourceInfo.getName()) && applicationName != null && moduleName != null) {
            return this.namingManager.lookupFromModuleNamespace(applicationName, moduleName, this.getModuleScopedName(name), env);
        }
        if (!this.isGlobalName(resourceInfo.getName()) && applicationName != null) {
            if (this.pe.getProcessType().isServer() || this.pe.getProcessType().isEmbedded()) {
                return this.namingManager.lookupFromAppNamespace(applicationName, this.getAppScopedName(name), env);
            }
            String internalGlobalJavaAppName = this.cnu.composeInternalGlobalJavaAppName(applicationName, this.getAppScopedName(name));
            if (this._logger.isLoggable(Level.FINEST)) {
                this.debug("appclient lookup : " + internalGlobalJavaAppName);
            }
            return this.namingManager.getInitialContext().lookup(internalGlobalJavaAppName);
        }
        if (env != null) {
            InitialContext ic = new InitialContext(env);
            return ic.lookup(name);
        }
        return this.namingManager.getInitialContext().lookup(name);
    }

    public Object lookup(GenericResourceInfo resourceInfo, String name) throws NamingException {
        return this.lookup(resourceInfo, name, null);
    }

    private String getModuleScopedName(String name) {
        return name;
    }

    private String getAppScopedName(String name) {
        return name;
    }

    private void debug(String message) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("[ASR] [ResourceNamingService] : " + message);
        }
    }
}

