/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.util.Arrays;
import org.glassfish.osgijavaeebase.DeploymentException;

class ContextPathCollisionException
extends DeploymentException {
    private final String contextPath;
    private final Long[] collidingWabIds;

    public ContextPathCollisionException(String contextPath, Long[] collidingWabIds) {
        if (collidingWabIds.length < 2) {
            throw new IllegalArgumentException("At least two WAB ids are needed");
        }
        this.contextPath = contextPath;
        this.collidingWabIds = Arrays.copyOf(collidingWabIds, collidingWabIds.length);
        Arrays.sort((Object[])this.collidingWabIds);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public long getCurrentWabId() {
        return this.collidingWabIds[this.collidingWabIds.length - 1];
    }

    public Long[] getExistingWabIds() {
        return Arrays.copyOfRange(this.collidingWabIds, 0, this.collidingWabIds.length - 1);
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("context path [" + this.contextPath + "] is same for following bundles: [");
        for (int i = 0; i < this.collidingWabIds.length; ++i) {
            sb.append(this.collidingWabIds[i]);
            if (i == this.collidingWabIds.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

